/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.zendesk.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mule.modules.zendesk.model.ActivityStream;
import org.mule.modules.zendesk.model.Attachment;
import org.mule.modules.zendesk.model.Automation;
import org.mule.modules.zendesk.model.Category;
import org.mule.modules.zendesk.model.FileUpload;
import org.mule.modules.zendesk.model.Forum;
import org.mule.modules.zendesk.model.ForumSubscription;
import org.mule.modules.zendesk.model.Group;
import org.mule.modules.zendesk.model.GroupMembership;
import org.mule.modules.zendesk.model.JobStatus;
import org.mule.modules.zendesk.model.Locale;
import org.mule.modules.zendesk.model.Macro;
import org.mule.modules.zendesk.model.Organization;
import org.mule.modules.zendesk.model.OrganizationRelated;
import org.mule.modules.zendesk.model.Request;
import org.mule.modules.zendesk.model.SatisfactionRating;
import org.mule.modules.zendesk.model.SharingAgreement;
import org.mule.modules.zendesk.model.SuspendedTicket;
import org.mule.modules.zendesk.model.Ticket;
import org.mule.modules.zendesk.model.TicketAudit;
import org.mule.modules.zendesk.model.TicketComment;
import org.mule.modules.zendesk.model.TicketField;
import org.mule.modules.zendesk.model.TicketMetric;
import org.mule.modules.zendesk.model.Topic;
import org.mule.modules.zendesk.model.TopicComment;
import org.mule.modules.zendesk.model.TopicSubscription;
import org.mule.modules.zendesk.model.TopicVote;
import org.mule.modules.zendesk.model.Trigger;
import org.mule.modules.zendesk.model.User;
import org.mule.modules.zendesk.model.UserIdentity;
import org.mule.modules.zendesk.model.UserRelated;
import org.mule.modules.zendesk.model.View;
import org.mule.modules.zendesk.model.ViewCount;
import org.mule.modules.zendesk.model.responses.SearchResponse;

public enum EntityType {
    TICKET(Ticket.class, "ticket", "tickets"),
    USER(User.class, "user", "users"),
    AUDIT(TicketAudit.class, "audit", "audits"),
    TICKET_FIELD(TicketField.class, "ticket_field", "ticketFields"),
    TICKET_METRIC(TicketMetric.class, "ticket_metric", "ticketMetrics"),
    VIEW(View.class, "view", "views"),
    USER_RELATED(UserRelated.class, "user_related", ""),
    ORGANIZATION_RELATED(OrganizationRelated.class, "organization_related", ""),
    REQUEST(Request.class, "request", "requests"),
    TICKET_COMMENT(TicketComment.class, "comment", "comments"),
    IDENTITY(UserIdentity.class, "identity", "identities"),
    GROUP(Group.class, "group", "groups"),
    GROUP_MEMBERSHIP(GroupMembership.class, "group_membership", "groupMemberships"),
    ORGANIZATION(Organization.class, "organization", "organizations"),
    FORUM(Forum.class, "forum", "forums"),
    FORUM_SUBSCRIPTION(ForumSubscription.class, "forum_subscription", "forumSubscriptions"),
    CATEGORY(Category.class, "category", "categories"),
    TOPIC(Topic.class, "topic", "topics"),
    TOPIC_SUBSCRIPTION(TopicSubscription.class, "topic_subscription", "topicSubscriptions"),
    TOPIC_VOTE(TopicVote.class, "topic_vote", "topicVotes"),
    TOPIC_COMMENT(TopicComment.class, "topic_comment", "topicComments"),
    ACTIVITY_STREAM(ActivityStream.class, "activity", "activities"),
    ATTACHMENT(Attachment.class, "attachment", "attachments"),
    FILE_UPLOAD(FileUpload.class, "upload", ""),
    AUTOMATION(Automation.class, "automation", "automations"),
    JOB_STATUS(JobStatus.class, "job_status", ""),
    LOCALE(Locale.class, "locale", "locales"),
    MACRO(Macro.class, "macro", "macros"),
    SATISFACTION_RATING(SatisfactionRating.class, "satisfaction_rating", "satisfactionRatings"),
    SHARING_AGREEMENT(SharingAgreement.class, "sharing_agreement", "sharing_agreements"),
    SUSPENDED_TICKET(SuspendedTicket.class, "suspended_ticket", "suspendedTickets"),
    TRIGGER(Trigger.class, "trigger", "triggers"),
    SEARCH_RESULTS(SearchResponse.class, "result", "results"),
    VIEW_COUNT(ViewCount.class, "view_count", "view_counts");

    private Class<?> type;
    private String plural;
    private String nameToSerialize;
    private static Map<Class<?>, String> mapLookup;

    private EntityType(Class<?> clazz, String nameToSerialize, String plural) {
        this.type = clazz;
        this.plural = plural;
        this.nameToSerialize = nameToSerialize;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getSimpleName() {
        return this.type.getSimpleName();
    }

    public String getNameForLists() {
        return StringUtils.capitalize(this.plural);
    }

    public static Class getClassOf(String serializeName) {
        if (mapLookup == null) {
            EntityType.initializeMapping();
        }
        if (mapLookup.containsValue(serializeName)) {
            for (Map.Entry<Class<?>, String> entrySet : mapLookup.entrySet()) {
                if (!entrySet.getValue().equals(serializeName)) continue;
                return entrySet.getKey();
            }
        }
        return null;
    }

    public static String getNameToSerialize(Class clazz) {
        if (mapLookup == null) {
            EntityType.initializeMapping();
        }
        if (mapLookup.containsKey(clazz)) {
            return mapLookup.get(clazz);
        }
        return null;
    }

    private static void initializeMapping() {
        mapLookup = new HashMap();
        for (EntityType type : EntityType.values()) {
            mapLookup.put(type.type, type.nameToSerialize);
        }
    }
}

