/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.zendesk.jersey;

import com.sun.jersey.api.client.ClientResponse;
import java.util.Map;
import org.mule.commons.jersey.ResponseHandler;
import org.mule.modules.zendesk.jersey.ZendeskException;
import org.mule.modules.zendesk.model.responses.ErrorResponse;

public class ZendeskResponseHandler
implements ResponseHandler {
    @Override
    public <T> T onSuccess(ClientResponse response, Class<T> entityType) {
        return response.getEntity(entityType);
    }

    @Override
    public <T> T onFailure(ClientResponse response, int status, int[] expectedStatus) {
        ErrorResponse errorResponse = response.getEntity(ErrorResponse.class);
        throw new ZendeskException(String.format("Error trying to call Zendesk services. Status [%s]. Response: [%s]. Error: [%s] ; %s", status, response.toString(), errorResponse.getDescription(), this.showErrorDetails(errorResponse.getDetails())));
    }

    @Override
    public <T> T onNoContent(ClientResponse response) {
        return null;
    }

    private String showErrorDetails(Map<String, Object> errorDetails) {
        StringBuilder errorString = new StringBuilder();
        errorString.append("Details: ");
        if (errorDetails != null) {
            for (Map.Entry<String, Object> entry : errorDetails.entrySet()) {
                errorString.append(entry.getValue().toString());
            }
        }
        return errorString.toString();
    }
}

