/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.zendesk.config;

import org.mule.config.MuleManifest;
import org.mule.modules.zendesk.model.holders.ActionExpressionHolder;
import org.mule.modules.zendesk.model.holders.AutomationExpressionHolder;
import org.mule.modules.zendesk.model.holders.ConditionExpressionHolder;
import org.mule.modules.zendesk.model.holders.ConditionsExpressionHolder;
import org.mule.modules.zendesk.processors.UpdateAutomationMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class UpdateAutomationDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    private static Logger logger = LoggerFactory.getLogger(UpdateAutomationDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition(UpdateAutomationMessageProcessor.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            }
            catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error("Cannot launch the mule app, the @Processor [update-automation] within the connector [zendesk] is not supported in mule " + muleVersion);
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the @Processor [update-automation] within the connector [zendesk] is not supported in mule " + muleVersion, new Location(parserContext.getReaderContext().getResource()), null, noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue("updateAutomation");
        builder.setScope("prototype");
        this.parseConfigRef(element, builder);
        if (!this.parseObjectRefWithDefault(element, builder, "automation", "automation", "#[payload]")) {
            BeanDefinitionBuilder automationBuilder = BeanDefinitionBuilder.rootBeanDefinition(AutomationExpressionHolder.class.getName());
            Element automationChildElement = DomUtils.getChildElementByTagName(element, "automation");
            if (automationChildElement != null) {
                this.parseProperty(automationBuilder, automationChildElement, "id", "id");
                this.parseProperty(automationBuilder, automationChildElement, "url", "url");
                this.parseProperty(automationBuilder, automationChildElement, "createdAt", "createdAt");
                this.parseProperty(automationBuilder, automationChildElement, "updatedAt", "updatedAt");
                this.parseProperty(automationBuilder, automationChildElement, "title", "title");
                this.parseProperty(automationBuilder, automationChildElement, "active", "active");
                if (!this.parseObjectRef(automationChildElement, automationBuilder, "conditions", "conditions")) {
                    BeanDefinitionBuilder _conditionsBuilder = BeanDefinitionBuilder.rootBeanDefinition(ConditionsExpressionHolder.class.getName());
                    Element _conditionsChildElement = DomUtils.getChildElementByTagName(automationChildElement, "conditions");
                    if (_conditionsChildElement != null) {
                        this.parseListAndSetProperty(_conditionsChildElement, _conditionsBuilder, "all", "all", "all", (AbstractDevkitBasedDefinitionParser.ParseDelegate)new AbstractDevkitBasedDefinitionParser.ParseDelegate<BeanDefinition>(){

                            public BeanDefinition parse(Element element) {
                                BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ConditionExpressionHolder.class);
                                UpdateAutomationDefinitionParser.this.parseProperty(builder, element, "field", "field");
                                UpdateAutomationDefinitionParser.this.parseProperty(builder, element, "operator", "operator");
                                UpdateAutomationDefinitionParser.this.parseProperty(builder, element, "value", "value");
                                return builder.getBeanDefinition();
                            }
                        });
                        this.parseListAndSetProperty(_conditionsChildElement, _conditionsBuilder, "any", "any", "any", (AbstractDevkitBasedDefinitionParser.ParseDelegate)new AbstractDevkitBasedDefinitionParser.ParseDelegate<BeanDefinition>(){

                            public BeanDefinition parse(Element element) {
                                BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ConditionExpressionHolder.class);
                                UpdateAutomationDefinitionParser.this.parseProperty(builder, element, "field", "field");
                                UpdateAutomationDefinitionParser.this.parseProperty(builder, element, "operator", "operator");
                                UpdateAutomationDefinitionParser.this.parseProperty(builder, element, "value", "value");
                                return builder.getBeanDefinition();
                            }
                        });
                        automationBuilder.addPropertyValue("conditions", _conditionsBuilder.getBeanDefinition());
                    }
                }
                if (!this.parseObjectRef(automationChildElement, automationBuilder, "actions", "actions")) {
                    BeanDefinitionBuilder _actionsBuilder = BeanDefinitionBuilder.rootBeanDefinition(ActionExpressionHolder.class.getName());
                    Element _actionsChildElement = DomUtils.getChildElementByTagName(automationChildElement, "actions");
                    if (_actionsChildElement != null) {
                        this.parseProperty(_actionsBuilder, _actionsChildElement, "field", "field");
                        this.parseProperty(_actionsBuilder, _actionsChildElement, "value", "value");
                        automationBuilder.addPropertyValue("actions", _actionsBuilder.getBeanDefinition());
                    }
                }
                builder.addPropertyValue("automation", automationBuilder.getBeanDefinition());
            }
        }
        this.parseProperty(builder, element, "username", "username");
        this.parseProperty(builder, element, "password", "password");
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition(definition);
        this.attachProcessorDefinition(parserContext, definition);
        return definition;
    }
}

