/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.zendesk.config;

import org.mule.config.MuleManifest;
import org.mule.modules.zendesk.model.holders.ForumSubscriptionExpressionHolder;
import org.mule.modules.zendesk.processors.DeleteForumSubscriptionMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class DeleteForumSubscriptionDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    private static Logger logger = LoggerFactory.getLogger(DeleteForumSubscriptionDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition(DeleteForumSubscriptionMessageProcessor.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            }
            catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error("Cannot launch the mule app, the @Processor [delete-forum-subscription] within the connector [zendesk] is not supported in mule " + muleVersion);
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the @Processor [delete-forum-subscription] within the connector [zendesk] is not supported in mule " + muleVersion, new Location(parserContext.getReaderContext().getResource()), null, noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue("deleteForumSubscription");
        builder.setScope("prototype");
        this.parseConfigRef(element, builder);
        if (!this.parseObjectRefWithDefault(element, builder, "forum-subscription", "forumSubscription", "#[payload]")) {
            BeanDefinitionBuilder forumSubscriptionBuilder = BeanDefinitionBuilder.rootBeanDefinition(ForumSubscriptionExpressionHolder.class.getName());
            Element forumSubscriptionChildElement = DomUtils.getChildElementByTagName(element, "forum-subscription");
            if (forumSubscriptionChildElement != null) {
                this.parseProperty(forumSubscriptionBuilder, forumSubscriptionChildElement, "id", "id");
                this.parseProperty(forumSubscriptionBuilder, forumSubscriptionChildElement, "url", "url");
                this.parseProperty(forumSubscriptionBuilder, forumSubscriptionChildElement, "createdAt", "createdAt");
                this.parseProperty(forumSubscriptionBuilder, forumSubscriptionChildElement, "updatedAt", "updatedAt");
                this.parseProperty(forumSubscriptionBuilder, forumSubscriptionChildElement, "forumId", "forumId");
                this.parseProperty(forumSubscriptionBuilder, forumSubscriptionChildElement, "userId", "userId");
                builder.addPropertyValue("forumSubscription", forumSubscriptionBuilder.getBeanDefinition());
            }
        }
        this.parseProperty(builder, element, "username", "username");
        this.parseProperty(builder, element, "password", "password");
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition(definition);
        this.attachProcessorDefinition(parserContext, definition);
        return definition;
    }
}

