/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.zendesk.config;

import org.mule.config.MuleManifest;
import org.mule.modules.zendesk.model.holders.TopicSubscriptionExpressionHolder;
import org.mule.modules.zendesk.processors.CreateTopicSubscriptionMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CreateTopicSubscriptionDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    private static Logger logger = LoggerFactory.getLogger(CreateTopicSubscriptionDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition(CreateTopicSubscriptionMessageProcessor.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            }
            catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error("Cannot launch the mule app, the @Processor [create-topic-subscription] within the connector [zendesk] is not supported in mule " + muleVersion);
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the @Processor [create-topic-subscription] within the connector [zendesk] is not supported in mule " + muleVersion, new Location(parserContext.getReaderContext().getResource()), null, noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue("createTopicSubscription");
        builder.setScope("prototype");
        this.parseConfigRef(element, builder);
        if (!this.parseObjectRefWithDefault(element, builder, "topic-subscription", "topicSubscription", "#[payload]")) {
            BeanDefinitionBuilder topicSubscriptionBuilder = BeanDefinitionBuilder.rootBeanDefinition(TopicSubscriptionExpressionHolder.class.getName());
            Element topicSubscriptionChildElement = DomUtils.getChildElementByTagName(element, "topic-subscription");
            if (topicSubscriptionChildElement != null) {
                this.parseProperty(topicSubscriptionBuilder, topicSubscriptionChildElement, "id", "id");
                this.parseProperty(topicSubscriptionBuilder, topicSubscriptionChildElement, "url", "url");
                this.parseProperty(topicSubscriptionBuilder, topicSubscriptionChildElement, "createdAt", "createdAt");
                this.parseProperty(topicSubscriptionBuilder, topicSubscriptionChildElement, "updatedAt", "updatedAt");
                this.parseProperty(topicSubscriptionBuilder, topicSubscriptionChildElement, "topicId", "topicId");
                this.parseProperty(topicSubscriptionBuilder, topicSubscriptionChildElement, "userId", "userId");
                builder.addPropertyValue("topicSubscription", topicSubscriptionBuilder.getBeanDefinition());
            }
        }
        this.parseProperty(builder, element, "username", "username");
        this.parseProperty(builder, element, "password", "password");
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition(definition);
        this.attachProcessorDefinition(parserContext, definition);
        return definition;
    }
}

