/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.zendesk.config;

import org.mule.config.MuleManifest;
import org.mule.modules.zendesk.model.holders.SatisfactionRatingExpressionHolder;
import org.mule.modules.zendesk.processors.CreateSatisfactionRatingMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CreateSatisfactionRatingDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    private static Logger logger = LoggerFactory.getLogger(CreateSatisfactionRatingDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition(CreateSatisfactionRatingMessageProcessor.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            }
            catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error("Cannot launch the mule app, the @Processor [create-satisfaction-rating] within the connector [zendesk] is not supported in mule " + muleVersion);
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the @Processor [create-satisfaction-rating] within the connector [zendesk] is not supported in mule " + muleVersion, new Location(parserContext.getReaderContext().getResource()), null, noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue("createSatisfactionRating");
        builder.setScope("prototype");
        this.parseConfigRef(element, builder);
        if (!this.parseObjectRefWithDefault(element, builder, "satisfaction-rating", "satisfactionRating", "#[payload]")) {
            BeanDefinitionBuilder satisfactionRatingBuilder = BeanDefinitionBuilder.rootBeanDefinition(SatisfactionRatingExpressionHolder.class.getName());
            Element satisfactionRatingChildElement = DomUtils.getChildElementByTagName(element, "satisfaction-rating");
            if (satisfactionRatingChildElement != null) {
                this.parseProperty(satisfactionRatingBuilder, satisfactionRatingChildElement, "id", "id");
                this.parseProperty(satisfactionRatingBuilder, satisfactionRatingChildElement, "url", "url");
                this.parseProperty(satisfactionRatingBuilder, satisfactionRatingChildElement, "createdAt", "createdAt");
                this.parseProperty(satisfactionRatingBuilder, satisfactionRatingChildElement, "updatedAt", "updatedAt");
                this.parseProperty(satisfactionRatingBuilder, satisfactionRatingChildElement, "assigneeId", "assigneeId");
                this.parseProperty(satisfactionRatingBuilder, satisfactionRatingChildElement, "groupId", "groupId");
                this.parseProperty(satisfactionRatingBuilder, satisfactionRatingChildElement, "requesterId", "requesterId");
                this.parseProperty(satisfactionRatingBuilder, satisfactionRatingChildElement, "ticketId", "ticketId");
                this.parseProperty(satisfactionRatingBuilder, satisfactionRatingChildElement, "score", "score");
                this.parseProperty(satisfactionRatingBuilder, satisfactionRatingChildElement, "comment", "comment");
                builder.addPropertyValue("satisfactionRating", satisfactionRatingBuilder.getBeanDefinition());
            }
        }
        this.parseProperty(builder, element, "username", "username");
        this.parseProperty(builder, element, "password", "password");
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition(definition);
        this.attachProcessorDefinition(parserContext, definition);
        return definition;
    }
}

