/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.zendesk.config;

import org.mule.config.MuleManifest;
import org.mule.modules.zendesk.model.holders.ActionExpressionHolder;
import org.mule.modules.zendesk.model.holders.MacroExpressionHolder;
import org.mule.modules.zendesk.model.holders.RestrictionExpressionHolder;
import org.mule.modules.zendesk.processors.CreateMacroMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CreateMacroDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    private static Logger logger = LoggerFactory.getLogger(CreateMacroDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition(CreateMacroMessageProcessor.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            }
            catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error("Cannot launch the mule app, the @Processor [create-macro] within the connector [zendesk] is not supported in mule " + muleVersion);
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the @Processor [create-macro] within the connector [zendesk] is not supported in mule " + muleVersion, new Location(parserContext.getReaderContext().getResource()), null, noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue("createMacro");
        builder.setScope("prototype");
        this.parseConfigRef(element, builder);
        if (!this.parseObjectRefWithDefault(element, builder, "macro", "macro", "#[payload]")) {
            BeanDefinitionBuilder macroBuilder = BeanDefinitionBuilder.rootBeanDefinition(MacroExpressionHolder.class.getName());
            Element macroChildElement = DomUtils.getChildElementByTagName(element, "macro");
            if (macroChildElement != null) {
                this.parseProperty(macroBuilder, macroChildElement, "id", "id");
                this.parseProperty(macroBuilder, macroChildElement, "url", "url");
                this.parseProperty(macroBuilder, macroChildElement, "createdAt", "createdAt");
                this.parseProperty(macroBuilder, macroChildElement, "updatedAt", "updatedAt");
                this.parseProperty(macroBuilder, macroChildElement, "title", "title");
                this.parseProperty(macroBuilder, macroChildElement, "active", "active");
                if (!this.parseObjectRef(macroChildElement, macroBuilder, "restriction", "restriction")) {
                    BeanDefinitionBuilder _restrictionBuilder = BeanDefinitionBuilder.rootBeanDefinition(RestrictionExpressionHolder.class.getName());
                    Element _restrictionChildElement = DomUtils.getChildElementByTagName(macroChildElement, "restriction");
                    if (_restrictionChildElement != null) {
                        this.parseProperty(_restrictionBuilder, _restrictionChildElement, "id", "id");
                        this.parseProperty(_restrictionBuilder, _restrictionChildElement, "type", "type");
                        macroBuilder.addPropertyValue("restriction", _restrictionBuilder.getBeanDefinition());
                    }
                }
                if (!this.parseObjectRef(macroChildElement, macroBuilder, "actions", "actions")) {
                    BeanDefinitionBuilder _actionsBuilder = BeanDefinitionBuilder.rootBeanDefinition(ActionExpressionHolder.class.getName());
                    Element _actionsChildElement = DomUtils.getChildElementByTagName(macroChildElement, "actions");
                    if (_actionsChildElement != null) {
                        this.parseProperty(_actionsBuilder, _actionsChildElement, "field", "field");
                        this.parseProperty(_actionsBuilder, _actionsChildElement, "value", "value");
                        macroBuilder.addPropertyValue("actions", _actionsBuilder.getBeanDefinition());
                    }
                }
                builder.addPropertyValue("macro", macroBuilder.getBeanDefinition());
            }
        }
        this.parseProperty(builder, element, "username", "username");
        this.parseProperty(builder, element, "password", "password");
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition(definition);
        this.attachProcessorDefinition(parserContext, definition);
        return definition;
    }
}

