/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.zendesk;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.commons.jersey.JerseyUtil;
import org.mule.commons.jersey.provider.GsonProvider;
import org.mule.modules.utils.pagination.PaginatedCollection;
import org.mule.modules.zendesk.jersey.GsonFactory;
import org.mule.modules.zendesk.jersey.ZendeskException;
import org.mule.modules.zendesk.jersey.ZendeskResponseHandler;
import org.mule.modules.zendesk.model.ActivityStream;
import org.mule.modules.zendesk.model.Attachment;
import org.mule.modules.zendesk.model.Automation;
import org.mule.modules.zendesk.model.Category;
import org.mule.modules.zendesk.model.EntityType;
import org.mule.modules.zendesk.model.FileUpload;
import org.mule.modules.zendesk.model.Forum;
import org.mule.modules.zendesk.model.ForumSubscription;
import org.mule.modules.zendesk.model.Group;
import org.mule.modules.zendesk.model.GroupMembership;
import org.mule.modules.zendesk.model.JobStatus;
import org.mule.modules.zendesk.model.Locale;
import org.mule.modules.zendesk.model.Macro;
import org.mule.modules.zendesk.model.Organization;
import org.mule.modules.zendesk.model.OrganizationRelated;
import org.mule.modules.zendesk.model.Request;
import org.mule.modules.zendesk.model.SatisfactionRating;
import org.mule.modules.zendesk.model.SharingAgreement;
import org.mule.modules.zendesk.model.SuspendedTicket;
import org.mule.modules.zendesk.model.Ticket;
import org.mule.modules.zendesk.model.TicketAudit;
import org.mule.modules.zendesk.model.TicketComment;
import org.mule.modules.zendesk.model.TicketField;
import org.mule.modules.zendesk.model.TicketMetric;
import org.mule.modules.zendesk.model.Topic;
import org.mule.modules.zendesk.model.TopicComment;
import org.mule.modules.zendesk.model.TopicSubscription;
import org.mule.modules.zendesk.model.TopicVote;
import org.mule.modules.zendesk.model.Trigger;
import org.mule.modules.zendesk.model.User;
import org.mule.modules.zendesk.model.UserIdentity;
import org.mule.modules.zendesk.model.UserRelated;
import org.mule.modules.zendesk.model.View;
import org.mule.modules.zendesk.model.ViewExecute;
import org.mule.modules.zendesk.model.responses.ApplyMacroResponse;
import org.mule.modules.zendesk.model.responses.EntityResponse;
import org.mule.modules.zendesk.model.responses.SearchResponse;
import org.mule.util.StringUtils;

public class ZendeskConnector {
    private String apiUrl;
    private Client client;
    private JerseyUtil jerseyUtil;
    private WebResource apiResource;

    public void connect(String username, String password) throws ConnectionException {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        clientConfig.getSingletons().add(new GsonProvider(GsonFactory.get()));
        this.setClient(Client.create(clientConfig));
        this.getClient().addFilter(new HTTPBasicAuthFilter(username, password));
        this.initJerseyUtil();
        this.setApiResource(this.getClient().resource(this.getApiUrl()));
        try {
            if (this.getCurrentUser().getEmail().equals("invalid@example.com")) {
                throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, null, "Please check your credentials and try again.");
            }
        }
        catch (Exception e) {
            throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, null, "The service couldn't be validated. Please check your URL and credentials and try again");
        }
    }

    private void initJerseyUtil() {
        JerseyUtil.Builder builder = JerseyUtil.builder();
        builder.setResponseHandler(new ZendeskResponseHandler());
        this.setJerseyUtil(builder.build());
    }

    public void disconnect() {
        this.setClient(null);
    }

    public boolean isConnected() {
        return this.getClient() != null;
    }

    public String connectionId() {
        return "{ User: \"" + this.getCurrentUser().getEmail() + " \"}";
    }

    public User getCurrentUser() {
        return this.jerseyUtil.get(this.apiResource.path("users").path("me.json"), EntityResponse.class, 200, 201).getUser();
    }

    public Ticket createTicket(Ticket ticket) {
        return this.jerseyUtil.post(this.apiResource.path("tickets.json").entity(ticket), EntityResponse.class, 201).getTicket();
    }

    public Collection<Ticket> listTickets() {
        return this.createPaginationResults(EntityType.TICKET, this.jerseyUtil.get(this.apiResource.path("tickets.json"), EntityResponse.class, 200));
    }

    public Ticket getTicket(Long ticketId) {
        return this.jerseyUtil.get(this.apiResource.path("tickets").path(ticketId + ".json"), EntityResponse.class, 200).getTicket();
    }

    public Ticket updateTicket(Ticket ticket) {
        return this.jerseyUtil.put(this.apiResource.path("tickets").path(ticket.getId() + ".json").entity(ticket), EntityResponse.class, 200).getTicket();
    }

    public Ticket deleteTicket(Ticket ticket) {
        this.jerseyUtil.delete(this.apiResource.path("tickets").path(ticket.getId() + ".json").entity(ticket), String.class, 200);
        return ticket;
    }

    public Collection<TicketAudit> listTicketAudits(Long ticketId) {
        return this.createPaginationResults(EntityType.AUDIT, this.jerseyUtil.get(this.apiResource.path("tickets").path(ticketId.toString()).path("audits.json"), EntityResponse.class, 200));
    }

    public TicketAudit getTicketAudit(Long ticketId, Long auditId) {
        return this.jerseyUtil.get(this.apiResource.path("tickets").path(ticketId.toString()).path("audits").path(auditId + ".json"), EntityResponse.class, 200).getAudit();
    }

    public Collection<TicketField> listTicketFields() {
        return this.createPaginationResults(EntityType.TICKET_FIELD, this.jerseyUtil.get(this.apiResource.path("ticket_fields.json"), EntityResponse.class, 200));
    }

    public TicketField createTicketField(TicketField ticketField) {
        return this.jerseyUtil.post(this.apiResource.path("ticket_fields.json").entity(ticketField), EntityResponse.class, 201).getTicketField();
    }

    public TicketField updateTicketField(TicketField ticketField) {
        return this.jerseyUtil.put(this.apiResource.path("ticket_fields").path(ticketField.getId() + ".json").entity(ticketField), EntityResponse.class, 200).getTicketField();
    }

    public Ticket bulkImportTicket(Ticket ticket) {
        return this.jerseyUtil.put(this.apiResource.path("imports").path("tickets.json").entity(ticket), EntityResponse.class, 201).getTicket();
    }

    public Collection<TicketMetric> listTicketMetrics() {
        return this.createPaginationResults(EntityType.TICKET_METRIC, this.jerseyUtil.get(this.apiResource.path("ticket_metrics.json"), EntityResponse.class, 200));
    }

    public TicketMetric getTicketMetrics(Long ticketId) {
        return this.jerseyUtil.get(this.apiResource.path("tickets").path(ticketId.toString()).path("metrics.json"), EntityResponse.class, 200).getTicketMetric();
    }

    public Collection<View> listViews() {
        return this.createPaginationResults(EntityType.VIEW, this.jerseyUtil.get(this.apiResource.path("views.json"), EntityResponse.class, 200));
    }

    public Collection<View> listActiveViews() {
        return this.createPaginationResults(EntityType.VIEW, this.jerseyUtil.get(this.apiResource.path("views").path("active.json"), EntityResponse.class, 200));
    }

    public Collection<View> listCompactViews() {
        return this.createPaginationResults(EntityType.VIEW, this.jerseyUtil.get(this.apiResource.path("views").path("compact.json"), EntityResponse.class, 200));
    }

    public View getView(Long viewId) {
        return this.jerseyUtil.get(this.apiResource.path("views").path(viewId + ".json"), EntityResponse.class, 200).getView();
    }

    public View createView(View view) {
        return this.jerseyUtil.post(this.apiResource.path("views.json").entity(view), EntityResponse.class, 201).getView();
    }

    public View updateView(View view) {
        return this.jerseyUtil.put(this.apiResource.path("views").path(view.getId() + ".json").entity(view), EntityResponse.class, 200).getView();
    }

    public Collection<Ticket> getTicketsFromView(Long viewId) {
        return this.createPaginationResults(EntityType.TICKET, this.jerseyUtil.get(this.apiResource.path("views").path(viewId.toString()).path("tickets.json"), EntityResponse.class, 200));
    }

    public ViewExecute executeView(Long viewId) {
        return this.jerseyUtil.get(this.apiResource.path("views").path(viewId.toString()).path("execute.json"), ViewExecute.class, 200);
    }

    public ViewExecute getViewCounts(List<String> viewIds) {
        return this.jerseyUtil.get(this.apiResource.path("views").path("counts_many.json").queryParam("ids", StringUtils.join(viewIds, (String)",")), ViewExecute.class, 200);
    }

    public Collection<User> listUsers() {
        return this.createPaginationResults(EntityType.USER, this.jerseyUtil.get(this.apiResource.path("users.json"), EntityResponse.class, 200));
    }

    public Collection<User> listUsersByOrganization(Long organizationId) {
        return this.createPaginationResults(EntityType.USER, this.jerseyUtil.get(this.apiResource.path("organizations").path(organizationId.toString()).path("users.json"), EntityResponse.class, 200));
    }

    public User getUser(Long userId) {
        return this.jerseyUtil.get(this.apiResource.path("users").path(userId + ".json"), EntityResponse.class, 200).getUser();
    }

    public Collection<User> listUsersByGroup(Long groupId) {
        return this.createPaginationResults(EntityType.USER, this.jerseyUtil.get(this.apiResource.path("groups").path(groupId.toString()).path("users.json"), EntityResponse.class, 200));
    }

    public UserRelated getUserRelated(Long userId) {
        return this.jerseyUtil.get(this.apiResource.path("users").path(userId.toString()).path("related.json"), EntityResponse.class, 200).getUserRelated();
    }

    public User createUser(User user) {
        return this.jerseyUtil.post(this.apiResource.path("users.json").entity(user), EntityResponse.class, 201).getUser();
    }

    public User updateUser(User user) {
        return this.jerseyUtil.put(this.apiResource.path("users").path(user.getId() + ".json").entity(user), EntityResponse.class, 200).getUser();
    }

    public User deleteUser(User user) {
        return this.jerseyUtil.delete(this.apiResource.path("users").path(user.getId() + ".json"), EntityResponse.class, 200).getUser();
    }

    public Collection<Request> listRequests() {
        return this.createPaginationResults(EntityType.REQUEST, this.jerseyUtil.get(this.apiResource.path("requests.json"), EntityResponse.class, 200));
    }

    public Collection<Request> listRequestsByStatus(String status) {
        Validate.isTrue(Arrays.asList("ccd", "open", "solved").contains(status), "The status is not valid for the operation");
        return this.createPaginationResults(EntityType.REQUEST, this.jerseyUtil.get(this.apiResource.path("requests").path(status + ".json"), EntityResponse.class, 200));
    }

    public Collection<Request> listRequestsByUser(Long userId) {
        return this.createPaginationResults(EntityType.REQUEST, this.jerseyUtil.get(this.apiResource.path("users").path(userId.toString()).path("requests.json"), EntityResponse.class, 200));
    }

    public Request getRequest(Long requestId) {
        return this.jerseyUtil.get(this.apiResource.path("requests").path(requestId + ".json"), EntityResponse.class, 200).getRequest();
    }

    public Request createRequest(Request request) {
        return this.jerseyUtil.post(this.apiResource.path("requests.json").entity(request), EntityResponse.class, 201).getRequest();
    }

    public Request updateRequest(Request request) {
        return this.jerseyUtil.put(this.apiResource.path("requests").path(request.getId() + ".json").entity(request), EntityResponse.class, 200).getRequest();
    }

    public Collection<TicketComment> listRequestComments(Long requestId) {
        return this.createPaginationResults(EntityType.TICKET_COMMENT, this.jerseyUtil.get(this.apiResource.path("requests").path(requestId.toString()).path("comments.json"), EntityResponse.class, 200));
    }

    public TicketComment getRequestComment(Long requestId, Long commentId) {
        return this.jerseyUtil.get(this.apiResource.path("requests").path(requestId.toString()).path("comments").path(commentId + ".json"), EntityResponse.class, 200).getComment();
    }

    public Collection<UserIdentity> listUserIdentities(Long userId) {
        return this.createPaginationResults(EntityType.IDENTITY, this.jerseyUtil.get(this.apiResource.path("users").path(userId.toString()).path("identities.json"), EntityResponse.class, 200));
    }

    public UserIdentity getUserIdentity(Long userId, Long userIdentityId) {
        return this.jerseyUtil.get(this.apiResource.path("users").path(userId.toString()).path("identities").path(userIdentityId + ".json"), EntityResponse.class, 200).getIdentity();
    }

    public UserIdentity createUserIdentity(UserIdentity userIdentity) {
        Validate.notNull(userIdentity.getUserId(), "UserID in identity cannot be null");
        return this.jerseyUtil.post(this.apiResource.path("users").path(userIdentity.getUserId().toString()).path("identities.json").entity(userIdentity), EntityResponse.class, 201).getIdentity();
    }

    public UserIdentity verifyUserIdentity(UserIdentity userIdentity) {
        Validate.notNull(userIdentity.getUserId(), "UserID in identity cannot be null");
        return this.jerseyUtil.put(this.apiResource.path("users").path(userIdentity.getUserId().toString()).path("identities").path(userIdentity.getId().toString()).path("verify.json"), EntityResponse.class, 200).getIdentity();
    }

    public UserIdentity makeUserIdentityPrimary(UserIdentity userIdentity) {
        Validate.notNull(userIdentity.getUserId(), "UserID in identity cannot be null");
        return this.jerseyUtil.put(this.apiResource.path("users").path(userIdentity.getUserId().toString()).path("identities").path(userIdentity.getId().toString()).path("make_primary.json"), EntityResponse.class, 200).getIdentity();
    }

    public UserIdentity requestUserIdentityVerification(UserIdentity userIdentity) {
        Validate.notNull(userIdentity.getUserId(), "UserID in identity cannot be null");
        return this.jerseyUtil.put(this.apiResource.path("users").path(userIdentity.getUserId().toString()).path("identities").path(userIdentity.getId().toString()).path("request_verification.json"), EntityResponse.class, 200).getIdentity();
    }

    public UserIdentity deleteUserIdentity(UserIdentity userIdentity) {
        Validate.notNull(userIdentity.getUserId(), "UserID in identity cannot be null");
        return this.jerseyUtil.delete(this.apiResource.path("users").path(userIdentity.getUserId().toString()).path("identities").path(userIdentity.getId() + ".json"), EntityResponse.class, 200).getIdentity();
    }

    public Collection<Group> listGroups() {
        return this.createPaginationResults(EntityType.GROUP, this.jerseyUtil.get(this.apiResource.path("groups.json"), EntityResponse.class, 200));
    }

    public Collection<Group> listAssignableGroups() {
        return this.createPaginationResults(EntityType.GROUP, this.jerseyUtil.get(this.apiResource.path("groups.json").path("assignable.json"), EntityResponse.class, 200));
    }

    public Group getGroup(Long groupId) {
        return this.jerseyUtil.get(this.apiResource.path("groups").path(groupId + ".json"), EntityResponse.class, 200).getGroup();
    }

    public Group createGroup(Group group) {
        return this.jerseyUtil.post(this.apiResource.path("groups.json").entity(group), EntityResponse.class, 201).getGroup();
    }

    public Group updateGroup(Group group) {
        Validate.notNull(group.getId(), "GroupId cannot be null");
        return this.jerseyUtil.put(this.apiResource.path("groups").path(group.getId() + ".json").entity(group), EntityResponse.class, 200).getGroup();
    }

    public void deleteGroup(Group group) {
        Validate.notNull(group.getId(), "GroupId cannot be null");
        this.jerseyUtil.delete(this.apiResource.path("groups").path(group.getId() + ".json").entity(group), ClientResponse.class, 200);
    }

    public Collection<GroupMembership> listGroupMemberships() {
        return this.createPaginationResults(EntityType.GROUP_MEMBERSHIP, this.jerseyUtil.get(this.apiResource.path("group_memberships.json"), EntityResponse.class, 200));
    }

    public Collection<GroupMembership> listGroupMembershipsByUser(Long userId) {
        return this.createPaginationResults(EntityType.GROUP_MEMBERSHIP, this.jerseyUtil.get(this.apiResource.path("users").path(userId.toString()).path("group_memberships.json"), EntityResponse.class, 200));
    }

    public Collection<GroupMembership> listGroupMembershipsByGroup(Long groupId) {
        return this.createPaginationResults(EntityType.GROUP_MEMBERSHIP, this.jerseyUtil.get(this.apiResource.path("groups").path(groupId.toString()).path("memberships.json"), EntityResponse.class, 200));
    }

    public Collection<GroupMembership> listGroupAssignableMemberships() {
        return this.createPaginationResults(EntityType.GROUP_MEMBERSHIP, this.jerseyUtil.get(this.apiResource.path("group_memberships").path("assignable.json"), EntityResponse.class, 200));
    }

    public Collection<GroupMembership> listGroupAssignableMembershipsByGroup(Long groupId) {
        return this.createPaginationResults(EntityType.GROUP_MEMBERSHIP, this.jerseyUtil.get(this.apiResource.path("groups").path(groupId.toString()).path("memberships").path("assignable.json"), EntityResponse.class, 200));
    }

    public GroupMembership getGroupMembership(Long groupMembershipId) {
        return this.jerseyUtil.get(this.apiResource.path("group_memberships").path(groupMembershipId + ".json"), EntityResponse.class, 200).getGroupMembership();
    }

    public GroupMembership getGroupMembershipByUser(Long groupMembershipId, Long userId) {
        return this.jerseyUtil.get(this.apiResource.path("users").path(userId.toString()).path("group_memberships").path(groupMembershipId + ".json"), EntityResponse.class, 200).getGroupMembership();
    }

    public GroupMembership createGroupMembership(GroupMembership groupMembership) {
        return this.jerseyUtil.post(this.apiResource.path("group_memberships.json").entity(groupMembership), EntityResponse.class, 201).getGroupMembership();
    }

    public void deleteGroupMembership(GroupMembership groupMembership) {
        this.jerseyUtil.delete(this.apiResource.path("group_memberships").path(groupMembership.getId() + ".json").entity(groupMembership), ClientResponse.class, 200);
    }

    public Collection<GroupMembership> setGroupMembershipAsDefault(GroupMembership groupMembership) {
        return this.createPaginationResults(EntityType.GROUP_MEMBERSHIP, this.jerseyUtil.put(this.apiResource.path("users").path(groupMembership.getUserId().toString()).path("group_memberships").path(groupMembership.getId().toString()).path("make_default.json"), EntityResponse.class, 200));
    }

    public Collection<Organization> listOrganizations() {
        return this.createPaginationResults(EntityType.ORGANIZATION, this.jerseyUtil.put(this.apiResource.path("organizations.json"), EntityResponse.class, 200));
    }

    public OrganizationRelated getOrganizationRelated(Long organizationId) {
        return this.jerseyUtil.get(this.apiResource.path("organizations").path(organizationId.toString()).path("related.json"), EntityResponse.class, 200).getOrganizationRelated();
    }

    public Organization getOrganization(Long organizationId) {
        return this.jerseyUtil.get(this.apiResource.path("organizations").path(organizationId + ".json"), EntityResponse.class, 200).getOrganization();
    }

    public Organization createOrganization(Organization organization) {
        return this.jerseyUtil.post(this.apiResource.path("organizations.json").entity(organization), EntityResponse.class, 201).getOrganization();
    }

    public Organization updateOrganization(Organization organization) {
        return this.jerseyUtil.put(this.apiResource.path("organizations").path(organization.getId() + ".json").entity(organization), EntityResponse.class, 200).getOrganization();
    }

    public void deleteOrganization(Organization organization) {
        this.jerseyUtil.delete(this.apiResource.path("organizations").path(organization.getId() + ".json"), EntityResponse.class, 200);
    }

    public Collection<Organization> searchOrganization(String searchTerm) {
        return this.createPaginationResults(EntityType.ORGANIZATION, this.jerseyUtil.get(this.apiResource.path("organizations").path("search.json").queryParam("external_id", searchTerm), EntityResponse.class, 200));
    }

    public Collection<Forum> listForums() {
        return this.createPaginationResults(EntityType.FORUM, this.jerseyUtil.get(this.apiResource.path("forums.json"), EntityResponse.class, 200));
    }

    public Collection<Forum> listForumsByCategory(Long categoryId) {
        return this.createPaginationResults(EntityType.FORUM, this.jerseyUtil.get(this.apiResource.path("categories").path(categoryId.toString()).path("forums.json"), EntityResponse.class, 200));
    }

    public Forum getForum(Long forumId) {
        return this.jerseyUtil.get(this.apiResource.path("forums").path(forumId + ".json"), EntityResponse.class, 200).getForum();
    }

    public Forum createForum(Forum forum) {
        return this.jerseyUtil.post(this.apiResource.path("forums.json").entity(forum), EntityResponse.class, 201).getForum();
    }

    public Forum updateForum(Forum forum) {
        return this.jerseyUtil.put(this.apiResource.path("forums").path(forum.getId() + ".json").entity(forum), EntityResponse.class, 200).getForum();
    }

    public void deleteForum(Forum forum) {
        this.jerseyUtil.delete(this.apiResource.path("forums").path(forum.getId() + ".json"), EntityResponse.class, 200);
    }

    public Collection<ForumSubscription> listForumSubscriptions() {
        return this.createPaginationResults(EntityType.FORUM_SUBSCRIPTION, this.jerseyUtil.get(this.apiResource.path("forum_subscriptions.json"), EntityResponse.class, 200));
    }

    public Collection<ForumSubscription> listForumSubscriptionsByForum(Long forumId) {
        return this.createPaginationResults(EntityType.FORUM_SUBSCRIPTION, this.jerseyUtil.get(this.apiResource.path("forums").path(forumId.toString()).path("subscriptions.json"), EntityResponse.class, 200));
    }

    public ForumSubscription getForumSubscription(Long forumSubscriptionId) {
        return this.jerseyUtil.get(this.apiResource.path("forum_subscriptions").path(forumSubscriptionId + ".json"), EntityResponse.class, 200).getForumSubscription();
    }

    public ForumSubscription createForumSubscription(ForumSubscription forumSubscription) {
        return this.jerseyUtil.post(this.apiResource.path("forum_subscriptions.json").entity(forumSubscription), EntityResponse.class, 201).getForumSubscription();
    }

    public void deleteForumSubscription(ForumSubscription forumSubscription) {
        this.jerseyUtil.delete(this.apiResource.path("forum_subscriptions").path(forumSubscription.getId() + ".json"), EntityResponse.class, 200);
    }

    public Collection<Category> listCategories() {
        return this.createPaginationResults(EntityType.CATEGORY, this.jerseyUtil.get(this.apiResource.path("categories.json"), EntityResponse.class, 200));
    }

    public Category getCategory(Long categoryId) {
        return this.jerseyUtil.get(this.apiResource.path("categories").path(categoryId + ".json"), EntityResponse.class, 200).getCategory();
    }

    public Category createCategory(Category category) {
        return this.jerseyUtil.post(this.apiResource.path("categories.json").entity(category), EntityResponse.class, 201).getCategory();
    }

    public Category updateCategory(Category category) {
        return this.jerseyUtil.put(this.apiResource.path("categories").path(category.getId() + ".json").entity(category), EntityResponse.class, 200).getCategory();
    }

    public void deleteCategory(Category category) {
        this.jerseyUtil.delete(this.apiResource.path("categories").path(category.getId() + ".json"), EntityResponse.class, 200);
    }

    public Collection<Topic> listTopics() {
        return this.createPaginationResults(EntityType.TOPIC, this.jerseyUtil.get(this.apiResource.path("topics.json"), EntityResponse.class, 200));
    }

    public Collection<Topic> listTopicsByForum(Long forumId) {
        return this.createPaginationResults(EntityType.TOPIC, this.jerseyUtil.get(this.apiResource.path("forums").path(forumId.toString()).path("topics.json"), EntityResponse.class, 200));
    }

    public Collection<Topic> listTopicsByUser(Long userId) {
        return this.createPaginationResults(EntityType.TOPIC, this.jerseyUtil.get(this.apiResource.path("users").path(userId.toString()).path("topics.json"), EntityResponse.class, 200));
    }

    public Topic getTopic(Long topicId) {
        return this.jerseyUtil.get(this.apiResource.path("topics").path(topicId + ".json"), EntityResponse.class, 200).getTopic();
    }

    public Topic createTopic(Topic topic) {
        return this.jerseyUtil.post(this.apiResource.path("topics.json").entity(topic), EntityResponse.class, 201).getTopic();
    }

    public Topic updateTopic(Topic topic) {
        return this.jerseyUtil.put(this.apiResource.path("topics").path(topic.getId() + ".json").entity(topic), EntityResponse.class, 200).getTopic();
    }

    public Topic importTopic(Topic topic) {
        return this.jerseyUtil.post(this.apiResource.path("import").path("topics.json").entity(topic), EntityResponse.class, 201).getTopic();
    }

    public void deleteTopic(Topic topic) {
        this.jerseyUtil.delete(this.apiResource.path("topics").path(topic.getId() + ".json"), EntityResponse.class, 200);
    }

    public Collection<TopicComment> listTopicComments(Long topicId) {
        return this.createPaginationResults(EntityType.TOPIC_COMMENT, this.jerseyUtil.get(this.apiResource.path("topics").path(topicId.toString()).path("comments.json"), EntityResponse.class, 200));
    }

    public Collection<TopicComment> listTopicCommentsByUser(Long userId) {
        return this.createPaginationResults(EntityType.TOPIC_COMMENT, this.jerseyUtil.get(this.apiResource.path("users").path(userId.toString()).path("topic_comments.json"), EntityResponse.class, 200));
    }

    public TopicComment getTopicComment(Long topicId, Long topicCommentId) {
        return this.jerseyUtil.get(this.apiResource.path("topics").path(topicId.toString()).path("comments").path(topicCommentId + ".json"), EntityResponse.class, 200).getTopicComment();
    }

    public TopicComment createTopicComment(TopicComment topicComment) {
        return this.jerseyUtil.post(this.apiResource.path("topics").path(topicComment.getTopicId().toString()).path("comments.json").entity(topicComment), EntityResponse.class, 201).getTopicComment();
    }

    public TopicComment importTopicComment(TopicComment topicComment) {
        return this.jerseyUtil.post(this.apiResource.path("import").path("topics").path(topicComment.getTopicId().toString()).path("comments.json").entity(topicComment), EntityResponse.class, 201).getTopicComment();
    }

    public TopicComment updateTopicComment(TopicComment topicComment) {
        return this.jerseyUtil.put(this.apiResource.path("topics").path(topicComment.getTopicId().toString()).path("comments").path(topicComment.getId() + ".json").entity(topicComment), EntityResponse.class, 200).getTopicComment();
    }

    public void deleteTopicComment(TopicComment topicComment) {
        this.jerseyUtil.delete(this.apiResource.path("topics").path(topicComment.getTopicId().toString()).path("comments").path(topicComment.getId() + ".json"), EntityResponse.class, 200);
    }

    public Collection<TopicSubscription> listTopicSubscriptions() {
        return this.createPaginationResults(EntityType.TOPIC_SUBSCRIPTION, this.jerseyUtil.get(this.apiResource.path("topic_subscriptions.json"), EntityResponse.class, 200));
    }

    public Collection<TopicSubscription> listTopicSubscriptionsByTopic(Long topicId) {
        return this.createPaginationResults(EntityType.TOPIC_SUBSCRIPTION, this.jerseyUtil.get(this.apiResource.path("topics").path(topicId.toString()).path("subscriptions.json"), EntityResponse.class, 200));
    }

    public TopicSubscription getTopicSubscription(Long topicSubscriptionId) {
        return this.jerseyUtil.get(this.apiResource.path("topic_subscriptions").path(topicSubscriptionId + ".json"), EntityResponse.class, 200).getTopicSubscription();
    }

    public TopicSubscription createTopicSubscription(TopicSubscription topicSubscription) {
        return this.jerseyUtil.post(this.apiResource.path("topic_subscriptions.json").entity(topicSubscription), EntityResponse.class, 201).getTopicSubscription();
    }

    public void deleteTopicSubscription(TopicSubscription topicSubscription) {
        this.jerseyUtil.delete(this.apiResource.path("topic_subscriptions").path(topicSubscription.getId() + ".json"), EntityResponse.class, 200);
    }

    public Collection<TopicVote> listTopicVotes(Long topicId) {
        return this.createPaginationResults(EntityType.TOPIC_VOTE, this.jerseyUtil.get(this.apiResource.path("topics").path(topicId.toString()).path("votes.json"), EntityResponse.class, 200));
    }

    public Collection<TopicVote> listTopicVotesByUser(Long userId) {
        return this.createPaginationResults(EntityType.TOPIC_VOTE, this.jerseyUtil.get(this.apiResource.path("users").path(userId.toString()).path("topic_votes.json"), EntityResponse.class, 200));
    }

    public TopicComment checkForVote(Long topicId) {
        return this.jerseyUtil.get(this.apiResource.path("topics").path(topicId.toString()).path("vote.json"), EntityResponse.class, 200).getTopicComment();
    }

    public TopicVote createTopicVote(TopicVote topicVote) {
        return this.jerseyUtil.post(this.apiResource.path("topics").path(topicVote.getTopicId().toString()).path("vote.json").entity(topicVote), EntityResponse.class, 201).getTopicVote();
    }

    public void deleteTopicVote(TopicVote topicVote) {
        this.jerseyUtil.delete(this.apiResource.path("topics").path(topicVote.getTopicId().toString()).path("vote.json"), EntityResponse.class, 200);
    }

    public Collection<ActivityStream> listActivities() {
        return this.createPaginationResults(EntityType.ACTIVITY_STREAM, this.jerseyUtil.get(this.apiResource.path("activities.json"), EntityResponse.class, 200));
    }

    public ActivityStream getActivity(Long activityId) {
        return this.jerseyUtil.get(this.apiResource.path("activities").path(activityId + ".json"), EntityResponse.class, 200).getActivity();
    }

    public FileUpload uploadAttachment(InputStream content, String mediaType, String filename, String token) {
        return this.jerseyUtil.post((WebResource.Builder)this.apiResource.path("uploads.json").queryParam("filename", filename).type(mediaType).entity(content), EntityResponse.class, 201).getUpload();
    }

    public void deleteUpload(String token) {
        this.jerseyUtil.delete(this.apiResource.path("uploads").path(token + ".json"), EntityResponse.class, 200);
    }

    public Attachment getAttachment(Long attachmentId) {
        return this.jerseyUtil.get(this.apiResource.path("attachments").path(attachmentId + ".json"), EntityResponse.class, 200).getAttachment();
    }

    public void deleteAttachment(Long attachmentId) {
        this.jerseyUtil.delete(this.apiResource.path("attachments").path(attachmentId + ".json"), EntityResponse.class, 200);
    }

    public Collection<Automation> listAutomations() {
        return this.createPaginationResults(EntityType.AUTOMATION, this.jerseyUtil.get(this.apiResource.path("automations.json"), EntityResponse.class, 200));
    }

    public Automation getAutomation(Long automationId) {
        return this.jerseyUtil.get(this.apiResource.path("automations").path(automationId + ".json"), EntityResponse.class, 200).getAutomation();
    }

    public Collection<Automation> listActiveAutomations() {
        return this.createPaginationResults(EntityType.AUTOMATION, this.jerseyUtil.get(this.apiResource.path("automations").path("active.json"), EntityResponse.class, 200));
    }

    public Automation createAutomation(Automation automation) {
        return this.jerseyUtil.post(this.apiResource.path("automations.json").entity(automation), EntityResponse.class, 201).getAutomation();
    }

    public Automation updateAutomation(Automation automation) {
        return this.jerseyUtil.put(this.apiResource.path("automations").path(automation.getId() + ".json").entity(automation), EntityResponse.class, 200).getAutomation();
    }

    public JobStatus showJobStatus(Long jobStatusId) {
        return this.jerseyUtil.get(this.apiResource.path("job_statuses").path(jobStatusId + ".json"), EntityResponse.class, 200).getJobStatus();
    }

    public Collection<Locale> listLocales() {
        return this.createPaginationResults(EntityType.LOCALE, this.jerseyUtil.get(this.apiResource.path("locales.json"), EntityResponse.class, 200));
    }

    public Locale getLocale(Integer localeId) {
        return this.jerseyUtil.get(this.apiResource.path("locales").path(localeId + ".json"), EntityResponse.class, 200).getLocale();
    }

    public Locale getCurrentLocale() {
        return this.jerseyUtil.get(this.apiResource.path("locales").path("current.json"), EntityResponse.class, 200).getLocale();
    }

    public Collection<Macro> listMacros() {
        return this.createPaginationResults(EntityType.MACRO, this.jerseyUtil.get(this.apiResource.path("macros.json"), EntityResponse.class, 200));
    }

    public Collection<Macro> listActiveMacros() {
        return this.createPaginationResults(EntityType.MACRO, this.jerseyUtil.get(this.apiResource.path("macros").path("active.json"), EntityResponse.class, 200));
    }

    public Macro getMacro(Long macroId) {
        return this.jerseyUtil.get(this.apiResource.path("macros").path(macroId + ".json"), EntityResponse.class, 200).getMacro();
    }

    public Macro createMacro(Macro macro) {
        return this.jerseyUtil.post(this.apiResource.path("macros.json").entity(macro), EntityResponse.class, 201).getMacro();
    }

    public Macro updateMacro(Macro macro) {
        return this.jerseyUtil.put(this.apiResource.path("macros").path(macro.getId() + ".json").entity(macro), EntityResponse.class, 200).getMacro();
    }

    public void deleteMacro(Macro macro) {
        this.jerseyUtil.delete(this.apiResource.path("macros").path(macro.getId() + ".json").entity(macro), EntityResponse.class, 200);
    }

    public void applyMacro(Long macroId) {
        this.jerseyUtil.get(this.apiResource.path("macros").path(macroId.toString()).path("apply.json"), ApplyMacroResponse.class, 200);
    }

    public void applyMacroToTicket(Long macroId, Long ticketId) {
        this.jerseyUtil.get(this.apiResource.path("tickets").path(ticketId.toString()).path("macros").path(macroId.toString()).path("apply.json"), ApplyMacroResponse.class, 200);
    }

    public Collection<SatisfactionRating> listSatisfactionRatings() {
        return this.createPaginationResults(EntityType.SATISFACTION_RATING, this.jerseyUtil.get(this.apiResource.path("satisfaction_ratings.json"), EntityResponse.class, 200));
    }

    public Collection<SatisfactionRating> listReceivedSatisfactionRatings() {
        return this.createPaginationResults(EntityType.SATISFACTION_RATING, this.jerseyUtil.get(this.apiResource.path("satisfaction_ratings").path("received.json"), EntityResponse.class, 200));
    }

    public SatisfactionRating getSatisfactionRating(Long satisfactionRatingId) {
        return this.jerseyUtil.get(this.apiResource.path("satisfaction_ratings").path(satisfactionRatingId + ".json"), EntityResponse.class, 200).getSatisfactionRating();
    }

    public SatisfactionRating createSatisfactionRating(SatisfactionRating satisfactionRating) {
        return this.jerseyUtil.post(this.apiResource.path("tickets").path(satisfactionRating.getTicketId().toString()).path("satisfaction_rating.json").entity(satisfactionRating), EntityResponse.class, 201).getSatisfactionRating();
    }

    public Collection<SharingAgreement> listSharingAgreements() {
        return this.createPaginationResults(EntityType.SHARING_AGREEMENT, this.jerseyUtil.get(this.apiResource.path("sharing_agreements.json"), EntityResponse.class, 200));
    }

    public Collection<SuspendedTicket> listSuspendedTickets() {
        return this.createPaginationResults(EntityType.SUSPENDED_TICKET, this.jerseyUtil.get(this.apiResource.path("suspended_tickets.json"), EntityResponse.class, 200));
    }

    public SuspendedTicket getSuspendedTicket(Long suspendedTicketId) {
        return this.jerseyUtil.get(this.apiResource.path("suspended_tickets").path(suspendedTicketId + ".json"), EntityResponse.class, 200).getSuspendedTicket();
    }

    public void recoverSuspendedTicket(Long suspendedTicketId) {
        this.jerseyUtil.put(this.apiResource.path("suspended_tickets").path(suspendedTicketId.toString()).path("recover.json"), EntityResponse.class, 200);
    }

    public void deleteSuspendedTicket(Long suspendedTicketId) {
        this.jerseyUtil.delete(this.apiResource.path("suspended_tickets").path(suspendedTicketId + ".json"), EntityResponse.class, 200);
    }

    public Collection<Trigger> listTriggers() {
        return this.createPaginationResults(EntityType.TRIGGER, this.jerseyUtil.get(this.apiResource.path("triggers.json"), EntityResponse.class, 200));
    }

    public Trigger getTrigger(Long triggerId) {
        return this.jerseyUtil.get(this.apiResource.path("triggers").path(triggerId + ".json"), EntityResponse.class, 200).getTrigger();
    }

    public Collection<Trigger> listActiveTriggers() {
        return this.createPaginationResults(EntityType.TRIGGER, this.jerseyUtil.get(this.apiResource.path("triggers").path("active.json"), EntityResponse.class, 200));
    }

    public Trigger createTrigger(Trigger trigger) {
        return this.jerseyUtil.post(this.apiResource.path("triggers.json").entity(trigger), EntityResponse.class, 201).getTrigger();
    }

    public Trigger updateTrigger(Trigger trigger) {
        return this.jerseyUtil.put(this.apiResource.path("triggers").path(trigger.getId() + ".json").entity(trigger), EntityResponse.class, 200).getTrigger();
    }

    public Iterable search(EntityType type, String query, String sortBy, String sortOrder) {
        WebResource searchResource = this.apiResource.path("search.json").queryParam("query", query);
        if (sortBy != null) {
            searchResource.queryParam("sort_by", sortBy);
        }
        if (sortOrder != null) {
            searchResource.queryParam("sort_order", sortOrder);
        }
        return this.createPaginationResults(EntityType.SEARCH_RESULTS, this.jerseyUtil.get(searchResource, SearchResponse.class, 200));
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public JerseyUtil getJerseyUtil() {
        return this.jerseyUtil;
    }

    public void setJerseyUtil(JerseyUtil jerseyUtil) {
        this.jerseyUtil = jerseyUtil;
    }

    public WebResource getApiResource() {
        return this.apiResource;
    }

    public void setApiResource(WebResource apiResource) {
        this.apiResource = apiResource;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    private <T> Collection<T> createPaginationResults(final EntityType type, final EntityResponse paginatedResponse) {
        return new PaginatedCollection<T, EntityResponse>(){
            private EntityResponse first;

            @Override
            protected synchronized EntityResponse firstPage() {
                if (this.first == null) {
                    this.first = paginatedResponse;
                }
                return this.first;
            }

            @Override
            protected boolean hasNextPage(EntityResponse currentPage) {
                return currentPage.getNextPage() != null;
            }

            @Override
            protected EntityResponse nextPage(EntityResponse page) {
                return ZendeskConnector.this.jerseyUtil.get(ZendeskConnector.this.apiResource.path(page.getNextPage()), EntityResponse.class, 200);
            }

            @Override
            protected Iterator<T> pageIterator(EntityResponse page) {
                try {
                    return ((List)page.getClass().getMethod("get" + type.getNameForLists(), new Class[0]).invoke((Object)page, new Object[0])).iterator();
                }
                catch (Exception e) {
                    throw new ZendeskException(e);
                }
            }

            @Override
            public boolean isEmpty() {
                return this.size() == 0;
            }

            @Override
            public int size() {
                return this.first.getCount();
            }
        };
    }
}

