/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.transformer.jaxb;

import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.w3c.dom.Node;

public class JAXBUnmarshallerTransformer
extends AbstractTransformer {
    protected JAXBContext jaxbContext;

    public JAXBUnmarshallerTransformer() {
        this.registerSourceType(DataTypeFactory.STRING);
        this.registerSourceType(DataTypeFactory.create(Writer.class));
        this.registerSourceType(DataTypeFactory.create(File.class));
        this.registerSourceType(DataTypeFactory.create(URL.class));
        this.registerSourceType(DataTypeFactory.create(Node.class));
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
        this.registerSourceType(DataTypeFactory.create(Source.class));
        this.registerSourceType(DataTypeFactory.create(XMLStreamReader.class));
        this.registerSourceType(DataTypeFactory.create(XMLEventReader.class));
    }

    public JAXBUnmarshallerTransformer(JAXBContext jaxbContext, DataType<?> returnType) {
        this();
        this.jaxbContext = jaxbContext;
        this.setReturnDataType(returnType);
    }

    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.jaxbContext == null) {
            if (Object.class.equals((Object)this.getReturnDataType().getType())) {
                throw new InitialisationException(CoreMessages.objectIsNull((String)"jaxbContext"), (Initialisable)this);
            }
            try {
                this.jaxbContext = JAXBContext.newInstance(this.getReturnDataType().getType());
            }
            catch (JAXBException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    protected Object doTransform(Object src, String outputEncoding) throws TransformerException {
        try {
            Unmarshaller u = this.jaxbContext.createUnmarshaller();
            JAXBElement result = null;
            if (src instanceof String) {
                result = u.unmarshal(new StringReader((String)src));
            } else if (src instanceof File) {
                result = u.unmarshal((File)src);
            } else if (src instanceof URL) {
                result = u.unmarshal((URL)src);
            } else if (src instanceof InputStream) {
                result = u.unmarshal((InputStream)src);
            } else if (src instanceof Node) {
                result = u.unmarshal((Node)src, this.getReturnDataType().getType());
            } else if (src instanceof Source) {
                result = u.unmarshal((Source)src, this.getReturnDataType().getType());
            } else if (src instanceof XMLStreamReader) {
                result = u.unmarshal((XMLStreamReader)src, this.getReturnDataType().getType());
            } else if (src instanceof XMLEventReader) {
                result = u.unmarshal((XMLEventReader)src, this.getReturnDataType().getType());
            }
            if (result != null && result instanceof JAXBElement) {
                result = ((JAXBElement)result).getValue();
            }
            return result;
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }

    public JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }

    public void setJaxbContext(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }
}

