/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.transformer;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.RegistrationException;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.xml.util.NamespaceManager;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XPathExtractor
extends AbstractTransformer
implements MuleContextAware {
    private volatile XPath xpath = XPathFactory.newInstance().newXPath();
    private volatile Map<String, String> prefixToNamespaceMap = null;
    private volatile String expression;
    private volatile ResultType resultType = ResultType.STRING;
    private NamespaceManager namespaceManager;

    public XPathExtractor() {
        this.registerSourceType(DataTypeFactory.create(Node.class));
        this.registerSourceType(DataTypeFactory.create(InputSource.class));
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        try {
            this.namespaceManager = (NamespaceManager)this.muleContext.getRegistry().lookupObject(NamespaceManager.class);
        }
        catch (RegistrationException e) {
            throw new ExpressionRuntimeException(CoreMessages.failedToLoad((String)"NamespaceManager"), (Throwable)e);
        }
    }

    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.expression == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)"An expression must be supplied to the StandardXPathExtractor"), (Initialisable)this);
        }
        if (this.namespaceManager != null) {
            if (this.prefixToNamespaceMap == null) {
                this.prefixToNamespaceMap = new HashMap<String, String>(this.namespaceManager.getNamespaces());
            } else {
                this.prefixToNamespaceMap.putAll(this.namespaceManager.getNamespaces());
            }
        }
        this.getXpath().setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                return (String)XPathExtractor.this.prefixToNamespaceMap.get(prefix);
            }

            @Override
            public String getPrefix(String namespaceURI) {
                for (Map.Entry entry : XPathExtractor.this.prefixToNamespaceMap.entrySet()) {
                    if (!namespaceURI.equals(entry.getValue())) continue;
                    return (String)entry.getKey();
                }
                return null;
            }

            @Override
            public Iterator<?> getPrefixes(String namespaceURI) {
                String prefix = this.getPrefix(namespaceURI);
                if (prefix == null) {
                    return Collections.emptyList().iterator();
                }
                return Arrays.asList(prefix).iterator();
            }
        });
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        QName resultType;
        switch (this.getResultType()) {
            case BOOLEAN: {
                resultType = XPathConstants.BOOLEAN;
                break;
            }
            case NODE: {
                resultType = XPathConstants.NODE;
                break;
            }
            case NODESET: {
                resultType = XPathConstants.NODESET;
                break;
            }
            case NUMBER: {
                resultType = XPathConstants.NUMBER;
                break;
            }
            default: {
                resultType = XPathConstants.STRING;
            }
        }
        try {
            if (src instanceof InputSource) {
                return this.xpath.evaluate(this.expression, (InputSource)src, resultType);
            }
            return this.xpath.evaluate(this.expression, src, resultType);
        }
        catch (XPathExpressionException e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public void setResultType(ResultType resultType) {
        this.resultType = resultType;
    }

    public XPath getXpath() {
        return this.xpath;
    }

    public void setXpath(XPath xPath) {
        this.xpath = xPath;
    }

    public Map<String, String> getNamespaces() {
        return this.prefixToNamespaceMap;
    }

    public void setNamespaces(Map<String, String> prefixToNamespaceMap) {
        this.prefixToNamespaceMap = prefixToNamespaceMap;
    }

    public static enum ResultType {
        NODESET,
        NODE,
        STRING,
        BOOLEAN,
        NUMBER;

    }
}

