/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.util;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.jxpath.JXPathInvalidAccessException;
import org.apache.commons.jxpath.JXPathTypeConversionException;
import org.apache.commons.jxpath.NodeSet;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.util.TypeConverter;
import org.apache.commons.jxpath.util.TypeUtils;

public class BasicTypeConverter
implements TypeConverter {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Set;

    public boolean canConvert(Object object, Class toType) {
        Class<?> fromType;
        if (object == null) {
            return true;
        }
        Class useType = TypeUtils.wrapPrimitive(toType);
        if (useType.isAssignableFrom(fromType = object.getClass())) {
            return true;
        }
        if (useType == (class$java$lang$String == null ? (class$java$lang$String = BasicTypeConverter.class$("java.lang.String")) : class$java$lang$String)) {
            return true;
        }
        if (object instanceof Boolean && ((class$java$lang$Number == null ? (class$java$lang$Number = BasicTypeConverter.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(useType) || "java.util.concurrent.atomic.AtomicBoolean".equals(useType.getName()))) {
            return true;
        }
        if (object instanceof Number && ((class$java$lang$Number == null ? (class$java$lang$Number = BasicTypeConverter.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(useType) || useType == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = BasicTypeConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean))) {
            return true;
        }
        if (object instanceof String && (useType == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = BasicTypeConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean) || useType == (class$java$lang$Character == null ? (class$java$lang$Character = BasicTypeConverter.class$("java.lang.Character")) : class$java$lang$Character) || useType == (class$java$lang$Byte == null ? (class$java$lang$Byte = BasicTypeConverter.class$("java.lang.Byte")) : class$java$lang$Byte) || useType == (class$java$lang$Short == null ? (class$java$lang$Short = BasicTypeConverter.class$("java.lang.Short")) : class$java$lang$Short) || useType == (class$java$lang$Integer == null ? (class$java$lang$Integer = BasicTypeConverter.class$("java.lang.Integer")) : class$java$lang$Integer) || useType == (class$java$lang$Long == null ? (class$java$lang$Long = BasicTypeConverter.class$("java.lang.Long")) : class$java$lang$Long) || useType == (class$java$lang$Float == null ? (class$java$lang$Float = BasicTypeConverter.class$("java.lang.Float")) : class$java$lang$Float) || useType == (class$java$lang$Double == null ? (class$java$lang$Double = BasicTypeConverter.class$("java.lang.Double")) : class$java$lang$Double))) {
            return true;
        }
        if (fromType.isArray()) {
            if (useType.isArray()) {
                Class<?> cType = useType.getComponentType();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    Object value = Array.get(object, i);
                    if (this.canConvert(value, cType)) continue;
                    return false;
                }
                return true;
            }
            if ((class$java$util$Collection == null ? (class$java$util$Collection = BasicTypeConverter.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(useType)) {
                return this.canCreateCollection(useType);
            }
            if (Array.getLength(object) > 0) {
                Object value = Array.get(object, 0);
                return this.canConvert(value, useType);
            }
            return this.canConvert("", useType);
        }
        if (object instanceof Collection) {
            if (useType.isArray()) {
                Class<?> cType = useType.getComponentType();
                Iterator it = ((Collection)object).iterator();
                while (it.hasNext()) {
                    Object value = it.next();
                    if (this.canConvert(value, cType)) continue;
                    return false;
                }
                return true;
            }
            if ((class$java$util$Collection == null ? (class$java$util$Collection = BasicTypeConverter.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(useType)) {
                return this.canCreateCollection(useType);
            }
            if (((Collection)object).size() > 0) {
                Object value;
                if (object instanceof List) {
                    value = ((List)object).get(0);
                } else {
                    Iterator it = ((Collection)object).iterator();
                    value = it.next();
                }
                return this.canConvert(value, useType);
            }
            return this.canConvert("", useType);
        }
        if (object instanceof NodeSet) {
            return this.canConvert(((NodeSet)object).getValues(), useType);
        }
        if (object instanceof Pointer) {
            return this.canConvert(((Pointer)object).getValue(), useType);
        }
        return ConvertUtils.lookup(useType) != null;
    }

    public Object convert(Object object, Class toType) {
        Object value;
        Class<?> fromType;
        if (object == null) {
            return toType.isPrimitive() ? this.convertNullToPrimitive(toType) : null;
        }
        if (toType == (class$java$lang$Object == null ? (class$java$lang$Object = BasicTypeConverter.class$("java.lang.Object")) : class$java$lang$Object)) {
            if (object instanceof NodeSet) {
                return this.convert(((NodeSet)object).getValues(), toType);
            }
            if (object instanceof Pointer) {
                return this.convert(((Pointer)object).getValue(), toType);
            }
            return object;
        }
        Class useType = TypeUtils.wrapPrimitive(toType);
        if (useType.isAssignableFrom(fromType = object.getClass())) {
            return object;
        }
        if (fromType.isArray()) {
            int length = Array.getLength(object);
            if (useType.isArray()) {
                Class<?> cType = useType.getComponentType();
                Object array = Array.newInstance(cType, length);
                for (int i = 0; i < length; ++i) {
                    Object value2 = Array.get(object, i);
                    Array.set(array, i, this.convert(value2, cType));
                }
                return array;
            }
            if ((class$java$util$Collection == null ? (class$java$util$Collection = BasicTypeConverter.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(useType)) {
                Collection collection = this.allocateCollection(useType);
                for (int i = 0; i < length; ++i) {
                    collection.add(Array.get(object, i));
                }
                return this.unmodifiableCollection(collection);
            }
            if (length > 0) {
                Object value3 = Array.get(object, 0);
                return this.convert(value3, useType);
            }
            return this.convert("", useType);
        }
        if (object instanceof Collection) {
            int length = ((Collection)object).size();
            if (useType.isArray()) {
                Class<?> cType = useType.getComponentType();
                Object array = Array.newInstance(cType, length);
                Iterator it = ((Collection)object).iterator();
                for (int i = 0; i < length; ++i) {
                    Object value4 = it.next();
                    Array.set(array, i, this.convert(value4, cType));
                }
                return array;
            }
            if ((class$java$util$Collection == null ? (class$java$util$Collection = BasicTypeConverter.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(useType)) {
                Collection collection = this.allocateCollection(useType);
                collection.addAll((Collection)object);
                return this.unmodifiableCollection(collection);
            }
            if (length > 0) {
                Object value5;
                if (object instanceof List) {
                    value5 = ((List)object).get(0);
                } else {
                    Iterator it = ((Collection)object).iterator();
                    value5 = it.next();
                }
                return this.convert(value5, useType);
            }
            return this.convert("", useType);
        }
        if (object instanceof NodeSet) {
            return this.convert(((NodeSet)object).getValues(), useType);
        }
        if (object instanceof Pointer) {
            return this.convert(((Pointer)object).getValue(), useType);
        }
        if (useType == (class$java$lang$String == null ? (class$java$lang$String = BasicTypeConverter.class$("java.lang.String")) : class$java$lang$String)) {
            return object.toString();
        }
        if (object instanceof Boolean) {
            if ((class$java$lang$Number == null ? (class$java$lang$Number = BasicTypeConverter.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(useType)) {
                return this.allocateNumber(useType, (Boolean)object != false ? 1.0 : 0.0);
            }
            if ("java.util.concurrent.atomic.AtomicBoolean".equals(useType.getName())) {
                try {
                    return useType.getConstructor(Boolean.TYPE).newInstance(object);
                }
                catch (Exception e) {
                    throw new JXPathTypeConversionException(useType.getName(), e);
                }
            }
        }
        if (object instanceof Number) {
            double value6 = ((Number)object).doubleValue();
            if (useType == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = BasicTypeConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                return value6 == 0.0 ? Boolean.FALSE : Boolean.TRUE;
            }
            if ((class$java$lang$Number == null ? (class$java$lang$Number = BasicTypeConverter.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(useType)) {
                return this.allocateNumber(useType, value6);
            }
        }
        if (object instanceof String && (value = this.convertStringToPrimitive(object, useType)) != null) {
            return value;
        }
        Converter converter = ConvertUtils.lookup(useType);
        if (converter != null) {
            return converter.convert(useType, object);
        }
        throw new JXPathTypeConversionException("Cannot convert " + object.getClass() + " to " + useType);
    }

    protected Object convertNullToPrimitive(Class toType) {
        if (toType == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (toType == Character.TYPE) {
            return new Character('\u0000');
        }
        if (toType == Byte.TYPE) {
            return new Byte(0);
        }
        if (toType == Short.TYPE) {
            return new Short(0);
        }
        if (toType == Integer.TYPE) {
            return new Integer(0);
        }
        if (toType == Long.TYPE) {
            return new Long(0L);
        }
        if (toType == Float.TYPE) {
            return new Float(0.0f);
        }
        if (toType == Double.TYPE) {
            return new Double(0.0);
        }
        return null;
    }

    protected Object convertStringToPrimitive(Object object, Class toType) {
        if ((toType = TypeUtils.wrapPrimitive(toType)) == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = BasicTypeConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return Boolean.valueOf((String)object);
        }
        if (toType == (class$java$lang$Character == null ? (class$java$lang$Character = BasicTypeConverter.class$("java.lang.Character")) : class$java$lang$Character)) {
            return new Character(((String)object).charAt(0));
        }
        if (toType == (class$java$lang$Byte == null ? (class$java$lang$Byte = BasicTypeConverter.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new Byte((String)object);
        }
        if (toType == (class$java$lang$Short == null ? (class$java$lang$Short = BasicTypeConverter.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short((String)object);
        }
        if (toType == (class$java$lang$Integer == null ? (class$java$lang$Integer = BasicTypeConverter.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer((String)object);
        }
        if (toType == (class$java$lang$Long == null ? (class$java$lang$Long = BasicTypeConverter.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long((String)object);
        }
        if (toType == (class$java$lang$Float == null ? (class$java$lang$Float = BasicTypeConverter.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float((String)object);
        }
        if (toType == (class$java$lang$Double == null ? (class$java$lang$Double = BasicTypeConverter.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double((String)object);
        }
        return null;
    }

    protected Number allocateNumber(Class type, double value) {
        if ((type = TypeUtils.wrapPrimitive(type)) == (class$java$lang$Byte == null ? (class$java$lang$Byte = BasicTypeConverter.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new Byte((byte)value);
        }
        if (type == (class$java$lang$Short == null ? (class$java$lang$Short = BasicTypeConverter.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short((short)value);
        }
        if (type == (class$java$lang$Integer == null ? (class$java$lang$Integer = BasicTypeConverter.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer((int)value);
        }
        if (type == (class$java$lang$Long == null ? (class$java$lang$Long = BasicTypeConverter.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long((long)value);
        }
        if (type == (class$java$lang$Float == null ? (class$java$lang$Float = BasicTypeConverter.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float((float)value);
        }
        if (type == (class$java$lang$Double == null ? (class$java$lang$Double = BasicTypeConverter.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(value);
        }
        if (type == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = BasicTypeConverter.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return BigInteger.valueOf((long)value);
        }
        if (type == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = BasicTypeConverter.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return new BigDecimal(value);
        }
        String classname = type.getName();
        Class<Number> initialValueType = null;
        if ("java.util.concurrent.atomic.AtomicInteger".equals(classname)) {
            initialValueType = Integer.TYPE;
        }
        if ("java.util.concurrent.atomic.AtomicLong".equals(classname)) {
            initialValueType = Long.TYPE;
        }
        if (initialValueType != null) {
            try {
                return (Number)type.getConstructor(initialValueType).newInstance(this.allocateNumber(initialValueType, value));
            }
            catch (Exception e) {
                throw new JXPathTypeConversionException(classname, e);
            }
        }
        return null;
    }

    protected boolean canCreateCollection(Class type) {
        if (!type.isInterface() && (type.getModifiers() & 0x400) == 0) {
            try {
                type.getConstructor(new Class[0]);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return type == (class$java$util$List == null ? (class$java$util$List = BasicTypeConverter.class$("java.util.List")) : class$java$util$List) || type == (class$java$util$Collection == null ? (class$java$util$Collection = BasicTypeConverter.class$("java.util.Collection")) : class$java$util$Collection) || type == (class$java$util$Set == null ? (class$java$util$Set = BasicTypeConverter.class$("java.util.Set")) : class$java$util$Set);
    }

    protected Collection allocateCollection(Class type) {
        if (!type.isInterface() && (type.getModifiers() & 0x400) == 0) {
            try {
                return (Collection)type.newInstance();
            }
            catch (Exception ex) {
                throw new JXPathInvalidAccessException("Cannot create collection of type: " + type, ex);
            }
        }
        if (type == (class$java$util$List == null ? (class$java$util$List = BasicTypeConverter.class$("java.util.List")) : class$java$util$List) || type == (class$java$util$Collection == null ? (class$java$util$Collection = BasicTypeConverter.class$("java.util.Collection")) : class$java$util$Collection)) {
            return new ArrayList();
        }
        if (type == (class$java$util$Set == null ? (class$java$util$Set = BasicTypeConverter.class$("java.util.Set")) : class$java$util$Set)) {
            return new HashSet();
        }
        throw new JXPathInvalidAccessException("Cannot create collection of type: " + type);
    }

    protected Collection unmodifiableCollection(Collection collection) {
        if (collection instanceof List) {
            return Collections.unmodifiableList((List)collection);
        }
        if (collection instanceof SortedSet) {
            return Collections.unmodifiableSortedSet((SortedSet)collection);
        }
        if (collection instanceof Set) {
            return Collections.unmodifiableSet((Set)collection);
        }
        return Collections.unmodifiableCollection(collection);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class ValuePointer
    implements Pointer {
        private static final long serialVersionUID = -4817239482392206188L;
        private Object bean;

        public ValuePointer(Object object) {
            this.bean = object;
        }

        public Object getValue() {
            return this.bean;
        }

        public Object getNode() {
            return this.bean;
        }

        public Object getRootNode() {
            return this.bean;
        }

        public void setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            return this;
        }

        public int compareTo(Object object) {
            return 0;
        }

        public String asPath() {
            if (this.bean == null) {
                return "null()";
            }
            if (this.bean instanceof Number) {
                String string = this.bean.toString();
                if (string.endsWith(".0")) {
                    string = string.substring(0, string.length() - 2);
                }
                return string;
            }
            if (this.bean instanceof Boolean) {
                return (Boolean)this.bean != false ? "true()" : "false()";
            }
            if (this.bean instanceof String) {
                return "'" + this.bean + "'";
            }
            return "{object of type " + this.bean.getClass().getName() + "}";
        }
    }

    static final class ValueNodeSet
    implements NodeSet {
        private List values;
        private List pointers;

        public ValueNodeSet(List values) {
            this.values = values;
        }

        public List getValues() {
            return Collections.unmodifiableList(this.values);
        }

        public List getNodes() {
            return Collections.unmodifiableList(this.values);
        }

        public List getPointers() {
            if (this.pointers == null) {
                this.pointers = new ArrayList();
                for (int i = 0; i < this.values.size(); ++i) {
                    this.pointers.add(new ValuePointer(this.values.get(i)));
                }
                this.pointers = Collections.unmodifiableList(this.pointers);
            }
            return this.pointers;
        }
    }
}

