/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.util;

import java.io.Serializable;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.defs.Thunk;
import net.sf.staccatocommons.lang.value.RelevantState;
import net.sf.staccatocommons.restrictions.check.NonNull;

public class Prioritized<P extends Comparable<P>, T>
implements Comparable<Prioritized<P, T>>,
Thunk<T>,
Serializable {
    private static final long serialVersionUID = 7131041003021112454L;
    private static final RelevantState<Prioritized> STATE = new RelevantState<Prioritized>(1){

        @Override
        protected void collectState(Prioritized object, RelevantState.StateCollector s) {
            s.add(object.priority);
        }
    };
    private final P priority;
    private final T value;

    public Prioritized(@NonNull P priority, T value) {
        Ensure.isNotNull("var0", priority);
        this.value = value;
        this.priority = priority;
    }

    @Override
    public T value() {
        return this.value;
    }

    @NonNull
    public P getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(Prioritized<P, T> other) {
        return STATE.compareTo(this, other);
    }

    public boolean equals(Object obj) {
        return STATE.equals(this, obj);
    }

    public int hashCode() {
        return STATE.hashCode(this);
    }

    public String toString() {
        return String.format("Prioritized(%s,%s)", this.priority, this.value);
    }

    @NonNull
    public static <T, P extends Comparable<P>> Prioritized<P, T> from(P priority, T value) {
        return new Prioritized<P, T>(priority, value);
    }
}

