/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang.tuple;

import net.sf.staccatocommons.defs.tuple.Tuple4;
import net.sf.staccatocommons.lang.tuple.AbstractTuple;
import net.sf.staccatocommons.lang.value.RelevantState;
import net.sf.staccatocommons.restrictions.check.NonNull;

public final class Quadruple<A, B, C, D>
extends AbstractTuple
implements Tuple4<A, B, C, D> {
    private static final long serialVersionUID = -1072243152313731077L;
    private static final RelevantState<Tuple4> VAL = new AbstractTuple.TupleState<Tuple4>(4){

        @Override
        protected void collectState(Tuple4 o, RelevantState.StateCollector b) {
            b.add(o.first()).add(o.second()).add(o.third()).add(o.fourth());
        }
    };
    private final A first;
    private final B second;
    private final C third;
    private final D fourth;

    public Quadruple(A first, B second, C third, D fourth) {
        this.first = first;
        this.second = second;
        this.third = third;
        this.fourth = fourth;
    }

    @Override
    public A first() {
        return this.first;
    }

    @Override
    public B second() {
        return this.second;
    }

    @Override
    public C third() {
        return this.third;
    }

    @Override
    public D fourth() {
        return this.fourth;
    }

    @Override
    public A _0() {
        return this.first();
    }

    @Override
    public B _1() {
        return this.second();
    }

    @Override
    public C _2() {
        return this.third();
    }

    @Override
    public D _3() {
        return this.fourth();
    }

    public String toString() {
        return VAL.toString(this);
    }

    @Override
    @NonNull
    public Object[] toArray() {
        return new Object[]{this.first, this.second, this.third, this.fourth};
    }

    @Override
    public int compareTo(Tuple4<A, B, C, D> other) {
        return VAL.compareTo(this, other);
    }

    public int hashCode() {
        return VAL.hashCode(this);
    }

    public boolean equals(Object obj) {
        return VAL.equals(this, obj);
    }
}

