/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.defs.Applicable;
import net.sf.staccatocommons.defs.Evaluable;
import net.sf.staccatocommons.lang.builder.Builder;
import net.sf.staccatocommons.lang.builder.BuilderAlreadyUsedException;
import net.sf.staccatocommons.lang.function.AbstractFunction;
import net.sf.staccatocommons.lang.function.Functions;
import net.sf.staccatocommons.restrictions.Constant;
import net.sf.staccatocommons.restrictions.check.NonNull;

public class CollectionBuilder<A, B extends Collection<A>>
implements Builder<B> {
    private B list;
    private Applicable<B, B> wrapperFunction;
    private static final Applicable TO_UNMODIFIABLE_SET = CollectionBuilder.toUnmodifiableSetInitializer();
    private static final Applicable TO_UNMODIFIABLE_SORTED_SET = CollectionBuilder.toUnmodifiableSortedSetInitializer();
    private static final Applicable TO_UNMODIFIABLE_LIST = CollectionBuilder.toUnmodifiableListInitializer();
    private static final Applicable TO_UNMODIFIABLE_COLLECTION = CollectionBuilder.toUnmodifiableCollectionInitializer();

    public CollectionBuilder(@NonNull B list, Applicable<B, B> wrapperFunction) {
        Ensure.isNotNull("var0", list);
        this.list = list;
        this.wrapperFunction = wrapperFunction;
    }

    @NonNull
    public CollectionBuilder<A, B> with(A element) {
        this.list.add(element);
        return this;
    }

    @NonNull
    public CollectionBuilder<A, B> withIf(A element, @NonNull Evaluable<? super A> evaluable) {
        Ensure.isNotNull("var1", evaluable);
        if (evaluable.eval(element)) {
            this.with(element);
        }
        return this;
    }

    @NonNull
    public CollectionBuilder<A, B> withWrapper(@NonNull Applicable<B, B> wrapperFunction) {
        Ensure.isNotNull("var0", wrapperFunction);
        this.wrapperFunction = wrapperFunction;
        return this;
    }

    @NonNull
    public CollectionBuilder<A, B> unwrap() {
        return this.withWrapper(Functions.identity());
    }

    @Override
    @NonNull
    public B build() throws BuilderAlreadyUsedException {
        if (this.list == null) {
            throw new BuilderAlreadyUsedException();
        }
        B list = this.list;
        this.list = null;
        return (B)((Collection)this.wrapperFunction.apply(list));
    }

    @NonNull
    public static <A> CollectionBuilder<A, Collection<A>> from(@NonNull Collection<A> collection) {
        Ensure.isNotNull("var0", collection);
        return CollectionBuilder.from(collection, CollectionBuilder.<A>toUnmodifiableCollection());
    }

    @NonNull
    public static <A> CollectionBuilder<A, SortedSet<A>> sortedSetWith(A element) {
        return CollectionBuilder.from(new TreeSet(), CollectionBuilder.<A>toUnmodifiableSortedSet()).with(element);
    }

    @NonNull
    public static <A> CollectionBuilder<A, Set<A>> setWith(A element) {
        return CollectionBuilder.from(new HashSet(), CollectionBuilder.<A>toUnmodifiableSet()).with(element);
    }

    @NonNull
    public static <A> CollectionBuilder<A, List<A>> listWith(A element) {
        return CollectionBuilder.from(new LinkedList(), CollectionBuilder.<A>toUnmodifiableList()).with(element);
    }

    @NonNull
    static <A, B extends Collection<A>> CollectionBuilder<A, B> from(@NonNull B collection, @NonNull Applicable<B, B> immutator) {
        return new CollectionBuilder<A, B>(collection, immutator);
    }

    @Constant
    public static <A> Applicable<Set<A>, Set<A>> toUnmodifiableSet() {
        return TO_UNMODIFIABLE_SET;
    }

    @Constant
    public static <A> Applicable<SortedSet<A>, SortedSet<A>> toUnmodifiableSortedSet() {
        return TO_UNMODIFIABLE_SORTED_SET;
    }

    @Constant
    public static <A> Applicable<List<A>, List<A>> toUnmodifiableList() {
        return TO_UNMODIFIABLE_LIST;
    }

    @Constant
    public static <A> Applicable<Collection<A>, Collection<A>> toUnmodifiableCollection() {
        return TO_UNMODIFIABLE_COLLECTION;
    }

    private static Applicable toUnmodifiableSetInitializer() {
        return new AbstractFunction<Set<A>, Set<A>>(){

            @Override
            public Set<A> apply(Set<A> arg) {
                return Collections.unmodifiableSet(arg);
            }
        };
    }

    private static Applicable toUnmodifiableSortedSetInitializer() {
        return new AbstractFunction<SortedSet<A>, SortedSet<A>>(){

            @Override
            public SortedSet<A> apply(SortedSet<A> arg) {
                return Collections.unmodifiableSortedSet(arg);
            }
        };
    }

    private static Applicable toUnmodifiableListInitializer() {
        return new AbstractFunction<List<A>, List<A>>(){

            @Override
            public List<A> apply(List<A> arg) {
                return Collections.unmodifiableList(arg);
            }
        };
    }

    private static Applicable toUnmodifiableCollectionInitializer() {
        return new AbstractFunction<Collection<A>, Collection<A>>(){

            @Override
            public Collection<A> apply(Collection<A> arg) {
                return Collections.unmodifiableCollection(arg);
            }
        };
    }
}

