/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.collections.stream.internal.algorithms;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.staccatocommons.collections.stream.AbstractStream;
import net.sf.staccatocommons.collections.stream.Stream;
import net.sf.staccatocommons.collections.stream.internal.algorithms.SingleLinkedDelayedQueue;
import net.sf.staccatocommons.defs.Thunk;
import net.sf.staccatocommons.iterators.EmptyThriterator;
import net.sf.staccatocommons.iterators.thriter.AdvanceThriterator;
import net.sf.staccatocommons.iterators.thriter.Thriterator;

public class MemorizedStream<A>
extends AbstractStream<A> {
    private SingleLinkedDelayedQueue<A> previous = new SingleLinkedDelayedQueue();
    private Thriterator<A> remaining;

    public MemorizedStream(Thriterator<A> source) {
        this.remaining = source;
    }

    @Override
    public boolean isEmpty() {
        return this.previous.isEmpty() && !this.remaining.hasNext();
    }

    @Override
    public Stream<A> memorize() {
        return this;
    }

    @Override
    public Thriterator<A> iterator() {
        if (this.remaining.isEmpty()) {
            if (this.previous.isEmpty()) {
                return EmptyThriterator.empty();
            }
            return this.previous.iterator();
        }
        Iterator previousIter = this.previous.iterator();
        return new AdvanceThriterator<A>((Thriterator)previousIter){
            private Thunk<A> current;
            private Thriterator<A> iter;
            private boolean remainingIterationStarted;
            {
                this.iter = thriterator;
                this.remainingIterationStarted = false;
            }

            @Override
            public boolean hasNext() {
                if (this.remainingIterationStarted) {
                    return this.iter.hasNext();
                }
                return MemorizedStream.this.remaining.hasNext();
            }

            @Override
            public void advanceNext() throws NoSuchElementException {
                if (!this.remainingIterationStarted && !this.iter.hasNext()) {
                    this.iter = this.newRemaningIterator();
                    this.remainingIterationStarted = true;
                }
                this.iter.advanceNext();
            }

            @Override
            public A current() {
                return this.iter.current();
            }

            @Override
            public Thunk<A> delayedCurrent() {
                return this.iter.delayedCurrent();
            }

            public Thriterator<A> newRemaningIterator() {
                return new AdvanceThriterator<A>(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public boolean hasNext() {
                        return MemorizedStream.access$1(1.access$2(this.this$1)).hasNext();
                    }

                    public void advanceNext() throws NoSuchElementException {
                        MemorizedStream.access$1(1.access$2(this.this$1)).advanceNext();
                        1.access$0(this.this$1, MemorizedStream.access$1(1.access$2(this.this$1)).delayedCurrent());
                        MemorizedStream.access$2(1.access$2(this.this$1)).add(1.access$1(this.this$1));
                    }

                    public A current() {
                        return this.delayedCurrent().value();
                    }

                    public Thunk<A> delayedCurrent() {
                        return 1.access$1(this.this$1);
                    }
                };
            }

            static /* synthetic */ void access$0(1 var0, Thunk thunk) {
                var0.current = thunk;
            }

            static /* synthetic */ Thunk access$1(1 var0) {
                return var0.current;
            }

            static /* synthetic */ MemorizedStream access$2(1 var0) {
                return var0.MemorizedStream.this;
            }
        };
    }

    static /* synthetic */ SingleLinkedDelayedQueue access$2(MemorizedStream memorizedStream) {
        return memorizedStream.previous;
    }
}

