/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.collections.stream.internal.algorithms;

import net.sf.staccatocommons.collections.internal.iterator.MapIterator;
import net.sf.staccatocommons.collections.stream.AbstractStream;
import net.sf.staccatocommons.collections.stream.Stream;
import net.sf.staccatocommons.defs.function.Function;
import net.sf.staccatocommons.iterators.thriter.Thriter;
import net.sf.staccatocommons.iterators.thriter.Thriterator;
import net.sf.staccatocommons.restrictions.check.NonNull;

public final class MapStream<A, B>
extends AbstractStream<B> {
    private final Stream<A> stream;
    private final Function<? super A, ? extends B> function;

    public MapStream(@NonNull Stream<A> stream, @NonNull Function<? super A, ? extends B> function) {
        this.stream = stream;
        this.function = function;
    }

    @Override
    public Thriterator<B> iterator() {
        return new MapIterator<A, B>(this.function, (Thriter)this.stream.iterator());
    }

    @Override
    public B get(int n) {
        return (B)this.function.apply(this.stream.get(n));
    }

    @Override
    public int size() {
        return this.stream.size();
    }

    @Override
    public boolean isEmpty() {
        return this.stream.isEmpty();
    }

    @Override
    public <C> Stream<C> map(Function<? super B, ? extends C> function) {
        return new MapStream<A, C>(this.stream, function.of(this.function));
    }
}

