/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.collections.stream.internal.algorithms;

import java.util.NoSuchElementException;
import net.sf.staccatocommons.collections.stream.AbstractStream;
import net.sf.staccatocommons.collections.stream.Stream;
import net.sf.staccatocommons.defs.Thunk;
import net.sf.staccatocommons.iterators.thriter.AdvanceThriterator;
import net.sf.staccatocommons.iterators.thriter.Thriter;
import net.sf.staccatocommons.iterators.thriter.Thriterator;
import net.sf.staccatocommons.iterators.thriter.Thriterators;
import net.sf.staccatocommons.restrictions.check.NonNull;

public final class AppendIterableStream<A>
extends AbstractStream<A> {
    private final Stream<A> stream;
    private final Iterable<A> other;

    public AppendIterableStream(@NonNull Stream<A> stream, @NonNull Iterable<A> other) {
        this.stream = stream;
        this.other = other;
    }

    @Override
    public Thriterator<A> iterator() {
        return new AdvanceThriterator<A>(){
            private Thriter<A> iter;
            private boolean second;
            {
                this.iter = AppendIterableStream.this.stream.iterator();
                this.second = false;
            }

            @Override
            public boolean hasNext() {
                if (this.iter.hasNext()) {
                    return true;
                }
                if (this.second) {
                    return false;
                }
                this.iter = Thriterators.from(AppendIterableStream.this.other.iterator());
                this.second = true;
                return this.iter.hasNext();
            }

            @Override
            public void advanceNext() throws NoSuchElementException {
                this.iter.advanceNext();
            }

            @Override
            public A current() throws NoSuchElementException {
                return this.iter.current();
            }

            @Override
            public Thunk<A> delayedCurrent() {
                return this.iter.delayedCurrent();
            }
        };
    }
}

