/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.collections.stream;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.check.Validate;
import net.sf.staccatocommons.collections.internal.iterator.DropIterator;
import net.sf.staccatocommons.collections.internal.iterator.FilterIndexIterator;
import net.sf.staccatocommons.collections.internal.iterator.FilterIterator;
import net.sf.staccatocommons.collections.internal.iterator.TakeWhileIterator;
import net.sf.staccatocommons.collections.iterable.Iterables;
import net.sf.staccatocommons.collections.iterable.internal.IterablesInternal;
import net.sf.staccatocommons.collections.stream.AbstractDelayedDeconsApplicable;
import net.sf.staccatocommons.collections.stream.AbstractStream;
import net.sf.staccatocommons.collections.stream.Stream;
import net.sf.staccatocommons.collections.stream.Streams;
import net.sf.staccatocommons.collections.stream.Transformable;
import net.sf.staccatocommons.collections.stream.internal.ListStream;
import net.sf.staccatocommons.collections.stream.internal.algorithms.AppendIterableStream;
import net.sf.staccatocommons.collections.stream.internal.algorithms.AppendStream;
import net.sf.staccatocommons.collections.stream.internal.algorithms.DeconsTransformStream;
import net.sf.staccatocommons.collections.stream.internal.algorithms.DropWhileStream;
import net.sf.staccatocommons.collections.stream.internal.algorithms.FlatMapStream;
import net.sf.staccatocommons.collections.stream.internal.algorithms.MapStream;
import net.sf.staccatocommons.collections.stream.internal.algorithms.MemorizedStream;
import net.sf.staccatocommons.collections.stream.internal.algorithms.PrependStream;
import net.sf.staccatocommons.collections.stream.internal.algorithms.SortedStream;
import net.sf.staccatocommons.collections.stream.internal.algorithms.TakeStream;
import net.sf.staccatocommons.collections.stream.internal.algorithms.TransformStream;
import net.sf.staccatocommons.collections.stream.internal.algorithms.ZipStream;
import net.sf.staccatocommons.collections.stream.internal.algorithms.delayed.DelayedAppendStream;
import net.sf.staccatocommons.collections.stream.internal.algorithms.delayed.DelayedDeconsTransformStream;
import net.sf.staccatocommons.collections.stream.internal.algorithms.delayed.DelayedPrependStream;
import net.sf.staccatocommons.defs.Applicable;
import net.sf.staccatocommons.defs.Applicable2;
import net.sf.staccatocommons.defs.Evaluable;
import net.sf.staccatocommons.defs.Evaluable2;
import net.sf.staccatocommons.defs.Executable;
import net.sf.staccatocommons.defs.Thunk;
import net.sf.staccatocommons.defs.function.Function;
import net.sf.staccatocommons.defs.function.Function2;
import net.sf.staccatocommons.defs.predicate.Predicate2;
import net.sf.staccatocommons.defs.reduction.Accumulator;
import net.sf.staccatocommons.defs.reduction.Reduction;
import net.sf.staccatocommons.defs.tuple.Tuple2;
import net.sf.staccatocommons.defs.type.NumberType;
import net.sf.staccatocommons.iterators.thriter.Thriter;
import net.sf.staccatocommons.iterators.thriter.Thriterator;
import net.sf.staccatocommons.lang.Compare;
import net.sf.staccatocommons.lang.Option;
import net.sf.staccatocommons.lang.function.AbstractFunction;
import net.sf.staccatocommons.lang.function.AbstractFunction2;
import net.sf.staccatocommons.lang.function.Functions;
import net.sf.staccatocommons.lang.internal.ToString;
import net.sf.staccatocommons.lang.predicate.AbstractPredicate2;
import net.sf.staccatocommons.lang.predicate.Equiv;
import net.sf.staccatocommons.lang.predicate.Predicates;
import net.sf.staccatocommons.lang.tuple.Tuples;
import net.sf.staccatocommons.restrictions.Constant;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.restrictions.check.NotNegative;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractStream<A>
implements Stream<A> {
    protected static final Validate<NoSuchElementException> VALIDATE_ELEMENT;
    private static final Predicate2 EQUAL_OR_EQUIV;
    private static final Function TO_ITERABLE;

    static {
        EQUAL_OR_EQUIV = AbstractStream.equalOrEquivInitializer();
        TO_ITERABLE = AbstractStream.toIterableInitializer();
        VALIDATE_ELEMENT = Validate.throwing(NoSuchElementException.class);
    }

    @Override
    public int size() {
        int size = 0;
        Thriter iter = this.iterator();
        while (iter.hasNext()) {
            iter.advanceNext();
            ++size;
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this.iterator().isEmpty();
    }

    @Override
    public void forEach(Executable<? super A> block) {
        for (Object element : this) {
            block.exec(element);
        }
    }

    @Override
    public Stream<A> each(Executable<? super A> block) {
        return this.map(Functions.impure(block));
    }

    @Override
    public boolean contains(A element) {
        return IterablesInternal.containsInternal(this, element);
    }

    @Override
    public Stream<A> filter(Evaluable<? super A> predicate) {
        return Streams.from(new FilterIterator<A>(this.iterator(), predicate));
    }

    @Override
    public Stream<A> skip(A element) {
        return this.filter(Predicates.equal(element).not());
    }

    @Override
    public Stream<A> takeWhile(Evaluable<? super A> predicate) {
        return Streams.from(new TakeWhileIterator<A>(this.iterator(), predicate));
    }

    @Override
    public Stream<A> take(@NotNegative int amountOfElements) {
        Ensure.that().isNotNegative("var0", amountOfElements);
        return new TakeStream(this.iterator(), amountOfElements);
    }

    @Override
    public Stream<A> dropWhile(Evaluable<? super A> predicate) {
        return new DropWhileStream<A>(this, predicate);
    }

    @Override
    public Stream<A> drop(@NotNegative int amountOfElements) {
        Ensure.that().isNotNegative("var0", amountOfElements);
        return Streams.from(new DropIterator(amountOfElements, this.iterator()));
    }

    @Override
    public A reduce(Applicable2<? super A, ? super A, ? extends A> function) {
        try {
            return Iterables.reduce(this, function);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return (A)VALIDATE_ELEMENT.fail("Can not reduce an empty stream", new Object[0]);
        }
    }

    @Override
    public <B> B reduce(Reduction<? super A, B> reduction) throws NoSuchElementException {
        return Iterables.reduce(this, reduction);
    }

    @Override
    public <O> O fold(O initial, Applicable2<? super O, ? super A, ? extends O> function) {
        return Iterables.fold(this, initial, function);
    }

    @Override
    public A any() {
        return Iterables.any(this);
    }

    @Override
    public Option<A> anyOrNone() {
        return Iterables.anyOrNone(this);
    }

    @Override
    public A anyOrNull() {
        return this.anyOrNone().valueOrNull();
    }

    @Override
    public A anyOrElse(Thunk<A> thunk) {
        return this.anyOrNone().valueOrElse(thunk);
    }

    @Override
    public A anyOrElse(A value) {
        return this.anyOrNone().valueOrElse(value);
    }

    @Override
    public A find(Evaluable<? super A> predicate) {
        return Iterables.find(this, predicate);
    }

    @Override
    public Option<A> findOrNone(Evaluable<? super A> predicate) {
        return Iterables.findOrNone(this, predicate);
    }

    @Override
    public A findOrNull(Evaluable<? super A> predicate) {
        return this.findOrNone(predicate).valueOrNull();
    }

    @Override
    public A findOrElse(Evaluable<? super A> predicate, Thunk<? extends A> thunk) {
        return this.findOrNone(predicate).valueOrElse(thunk);
    }

    @Override
    public A findOrElse(Evaluable<? super A> predicate, A element) {
        return this.findOrNone(predicate).valueOrElse(element);
    }

    @Override
    public boolean all(Evaluable<? super A> predicate) {
        return Iterables.all(this, predicate);
    }

    @Override
    public boolean allEquiv() {
        return Iterables.allEqual(this);
    }

    @Override
    public boolean allEquivBy(Evaluable2<? super A, ? super A> equivTest) {
        return Iterables.allEquivBy(this, equivTest);
    }

    @Override
    public boolean any(Evaluable<? super A> predicate) {
        return Iterables.any(this, predicate);
    }

    @Override
    public <B> Stream<Tuple2<A, B>> clone(Applicable<? super A, ? extends B> function) {
        return this.map(Tuples.clone(function));
    }

    @Override
    public <B, C> Stream<Tuple2<B, C>> branch(Applicable<? super A, ? extends B> function0, Applicable<? super A, ? extends C> function1) {
        return this.map(Tuples.branch(function0, function1));
    }

    @Override
    public <B> Stream<B> map(Function<? super A, ? extends B> function) {
        return new MapStream<A, B>(this, function);
    }

    @Override
    public <B> Stream<B> map(Applicable<? super A, ? extends B> function) {
        return this.map(Functions.from(function));
    }

    @Override
    public <B> Stream<B> flatMap(Function<? super A, ? extends Iterable<? extends B>> function) {
        return new FlatMapStream(this, function);
    }

    @Override
    public <B> Stream<B> flatMapArray(@NonNull Function<? super A, ? extends B[]> function) {
        Ensure.isNotNull("var0", function);
        return this.flatMap(AbstractStream.toIterable().of(function));
    }

    @Override
    public Stream<A> append(Iterable<A> other) {
        return new AppendIterableStream<A>(this, other);
    }

    @Override
    public Stream<A> appendUndefined() {
        return this.append((A)Streams.undefined());
    }

    @Override
    public A first() {
        return this.get(0);
    }

    @Override
    public A second() {
        return this.get(1);
    }

    @Override
    public A third() {
        return this.get(2);
    }

    @Override
    public A last() {
        Thriterator iter = this.iterator();
        VALIDATE_ELEMENT.that(iter.hasNext(), "Empty streams have no elements", new Object[0]);
        while (iter.hasNext()) {
            iter.advanceNext();
        }
        return iter.current();
    }

    @Override
    public A get(int n) {
        Thriterator iter = this.iterator();
        int i = 0;
        while (i <= n) {
            try {
                iter.advanceNext();
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IndexOutOfBoundsException("At " + n);
            }
            ++i;
        }
        return iter.current();
    }

    @Override
    public final Stream<A> filterIndex(Evaluable<Integer> predicate) {
        return Streams.from(new FilterIndexIterator(this.iterator(), predicate));
    }

    @Override
    public final Stream<A> skipIndex(int index) {
        return this.filterIndex((Evaluable<Integer>)Predicates.equal(index).not());
    }

    @Override
    public int indexOf(A element) {
        return Iterables.indexOf(this, element);
    }

    @Override
    public final int positionOf(A element) {
        int index = this.indexOf(element);
        if (index == -1) {
            throw new NoSuchElementException(element.toString());
        }
        return index;
    }

    @Override
    public boolean isBefore(A previous, A next) {
        return Iterables.isBefore(this, previous, next);
    }

    @Override
    public Set<A> toSet() {
        return Iterables.toSet(this);
    }

    @Override
    public List<A> toList() {
        return Iterables.toList(this);
    }

    @Override
    public Stream<A> force() {
        return new ListStream<A>(this.toList()){

            @Override
            public List<A> toList() {
                return Collections.unmodifiableList(this.getList());
            }
        };
    }

    @Override
    public Stream<A> memorize() {
        return new MemorizedStream(this.iterator());
    }

    @Override
    public A[] toArray(Class<? super A> clazz) {
        return this.toArray(clazz, this.toList());
    }

    protected A[] toArray(Class<? super A> clazz, Collection<A> readOnlyColView) {
        return readOnlyColView.toArray((Object[])Array.newInstance(clazz, readOnlyColView.size()));
    }

    @Override
    public String joinStrings(@NonNull String separator) {
        Ensure.isNotNull("var0", separator);
        return StringUtils.join((Iterator)this.iterator(), separator);
    }

    @Override
    public Tuple2<List<A>, List<A>> partition(Evaluable<? super A> predicate) {
        return Iterables.partition(this, predicate);
    }

    @Override
    public final Tuple2<Stream<A>, Stream<A>> streamPartition(Evaluable<? super A> predicate) {
        Tuple2<List<A>, List<A>> partition = this.partition(predicate);
        return Tuples._(Streams.from((List)partition._0()), Streams.from((List)partition._1()));
    }

    @Override
    public final boolean equiv(A ... elements) {
        return this.equiv((Iterable)Arrays.asList(elements));
    }

    @Override
    public boolean equiv(Iterable<? extends A> other) {
        return this.equivBy((Evaluable2)AbstractStream.equalOrEquiv(), other);
    }

    @Constant
    private static <A> Predicate2<A, A> equalOrEquiv() {
        return EQUAL_OR_EQUIV;
    }

    @Override
    public boolean equivBy(Evaluable2<? super A, ? super A> equalty, Iterable<? extends A> other) {
        return Iterables.equivBy(this, other, equalty);
    }

    @Override
    public final boolean equivBy(Evaluable2<? super A, ? super A> equalityTest, A ... elements) {
        return this.equivBy(equalityTest, (Iterable)Arrays.asList(elements));
    }

    @Override
    public final <B> boolean equivOn(Applicable<? super A, ? extends B> function, Iterable<? extends A> iterable) {
        return this.equivBy((Evaluable2)Equiv.on(function), iterable);
    }

    @Override
    public final <B> boolean equivOn(Applicable<? super A, ? extends B> function, A ... elements) {
        return this.equivOn(function, (Iterable)Arrays.asList(elements));
    }

    @Override
    public <B> Stream<B> transform(Applicable<Stream<A>, ? extends Stream<B>> function) {
        return new TransformStream(this, function);
    }

    @Override
    public Stream<A> intersperse(final A sep) {
        return this.transform(new AbstractDelayedDeconsApplicable<A, A>(){

            @Override
            public Stream<A> apply(Thunk<A> head, Stream<A> tail) {
                if (tail.isEmpty()) {
                    return Streams.cons(head);
                }
                return Streams.cons(head, Streams.cons(sep, tail.intersperse(sep)));
            }
        });
    }

    @Override
    public Stream<A> incorporate(final Function<? super A, ? extends A> function) {
        return this.flatMap(new AbstractFunction<A, Iterable<? extends A>>(){

            @Override
            public Iterable<? extends A> apply(A arg) {
                return Streams.cons(new Object[]{arg, function.apply(arg)});
            }
        });
    }

    @Override
    public Stream<A> incorporate(A element) {
        return this.incorporate((A)Functions.constant(element));
    }

    @Override
    public Stream<A> append(A element) {
        return new AppendStream<A>(this, element);
    }

    @Override
    public Stream<A> append(Thunk<A> element) {
        return new DelayedAppendStream<A>(this, element);
    }

    @Override
    public Stream<A> prepend(A element) {
        return new PrependStream<A>(element, this);
    }

    @Override
    public Stream<A> prepend(Thunk<A> element) {
        return new DelayedPrependStream<A>(element, this);
    }

    @Override
    public <B> Stream<B> transform(Transformable.DeconsApplicable<A, B> function) {
        return new DeconsTransformStream<B, A>(this, function);
    }

    @Override
    public <B> Stream<B> transform(Transformable.DelayedDeconsApplicable<A, B> function) {
        return new DelayedDeconsTransformStream<A, B>(this, function);
    }

    @Override
    public <B> Stream<Tuple2<A, B>> zip(Iterable<B> iterable) {
        return this.zip(iterable, Tuples.toTuple2());
    }

    @Override
    public Tuple2<A, Stream<A>> decons() {
        Iterator iter = this.iterator();
        VALIDATE_ELEMENT.that(iter.hasNext(), "Empty streams can not be deconstructed", new Object[0]);
        return Tuples._(iter.next(), Streams.from(iter));
    }

    @Override
    public Tuple2<Thunk<A>, Stream<A>> delayedDecons() {
        Thriterator iter = this.iterator();
        VALIDATE_ELEMENT.that(iter.hasNext(), "Empty streams can not be deconstructed", new Object[0]);
        return Tuples._(iter.delayedNext(), Streams.from(iter));
    }

    @Override
    public Stream<A> tail() {
        VALIDATE_ELEMENT.that(!this.isEmpty(), "Empty streams have not tail", new Object[0]);
        return this.drop(1);
    }

    @Override
    public A head() {
        try {
            return this.first();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return (A)VALIDATE_ELEMENT.fail("Empty streams have no head", new Object[0]);
        }
    }

    @Override
    public <B, C> Stream<C> zip(@NonNull Iterable<B> iterable, @NonNull Function2<A, B, C> function) {
        Ensure.isNotNull("var1", function);
        Ensure.isNotNull("var0", iterable);
        return new ZipStream<C, A, B>(this, iterable, function);
    }

    @Override
    public A sum(NumberType<A> numberType) {
        return Iterables.sum(this, numberType);
    }

    @Override
    public A product(NumberType<A> numberType) {
        return Iterables.product(this, numberType);
    }

    @Override
    public A average(final NumberType<A> numberType) {
        class Ref {
            A val;
            final /* synthetic */ AbstractStream this$0;

            Ref(AbstractStream abstractStream, NumberType numberType) {
                this.this$0 = abstractStream;
                this.val = numberType.zero();
            }
        }
        final Ref size = new Ref(this, numberType);
        return numberType.divide(this.fold((O)numberType.zero(), new AbstractFunction2<A, A, A>(){
            {
            }

            @Override
            public A apply(A arg0, A arg1) {
                size.val = numberType.increment(size.val);
                return numberType.add(arg0, arg1);
            }
        }), size.val);
    }

    @Override
    public A maximum() {
        return this.maximumBy(this.natural());
    }

    @Override
    public A minimum() {
        return this.minimumBy(this.natural());
    }

    @Override
    public A maximumBy(Comparator<? super A> comparator) {
        return this.reduce((Applicable2)Compare.max(comparator));
    }

    @Override
    public A minimumBy(Comparator<? super A> comparator) {
        return this.reduce((Applicable2)Compare.min(comparator));
    }

    @Override
    public final <B extends Comparable<B>> A maximumOn(Applicable<? super A, B> function) throws NoSuchElementException {
        return this.maximumBy(Compare.on(function));
    }

    @Override
    public final <B extends Comparable<B>> A minimumOn(Applicable<? super A, B> function) throws NoSuchElementException {
        return this.minimumBy(Compare.on(function));
    }

    @Override
    public Stream<A> sort() {
        return this.sortBy(this.natural());
    }

    @Override
    public Stream<A> sortBy(Comparator<A> comparator) {
        return new SortedStream<A>(this, comparator);
    }

    @Override
    public final <B extends Comparable<B>> Stream<A> sortOn(Applicable<? super A, B> function) {
        return this.sortBy(Compare.on(function));
    }

    private Comparator<A> natural() {
        return Compare.natural();
    }

    @Override
    public Stream<A> reverse() {
        if (this.isEmpty()) {
            return Streams.empty();
        }
        LinkedList reversedList = new LinkedList();
        for (Object element : this) {
            reversedList.addFirst(element);
        }
        return Streams.from(reversedList);
    }

    @Override
    public <K, V> Map<K, V> groupOn(Applicable<? super A, K> groupFunction, Reduction<A, V> reduction) {
        LinkedHashMap map = new LinkedHashMap();
        for (Object t : this) {
            K key = groupFunction.apply(t);
            Accumulator accum = (Accumulator)map.get(key);
            if (accum == null) {
                accum = reduction.newAccumulator();
                map.put(key, accum);
            }
            accum.accumulate(t);
        }
        for (Map.Entry entry : map.entrySet()) {
            entry.setValue(((Accumulator)entry.getValue()).value());
        }
        return map;
    }

    @Override
    public Stream<Tuple2<A, A>> cross() {
        return this.cross(this);
    }

    @Override
    public <B> Stream<Tuple2<A, B>> cross(@NonNull Iterable<B> other) {
        Ensure.isNotNull("var0", other);
        return this.cross(Streams.from(other));
    }

    @Override
    public <B> Stream<Tuple2<A, B>> cross(final @NonNull Stream<B> other) {
        Ensure.isNotNull("var0", other);
        return this.transform(new AbstractFunction<Stream<A>, Stream<Tuple2<A, B>>>(){

            @Override
            public Stream<Tuple2<A, B>> apply(Stream<A> stram) {
                return AbstractStream.this.flatMap(new AbstractFunction<A, Stream<Tuple2<A, B>>>(this, other){
                    final /* synthetic */ 6 this$1;
                    private final /* synthetic */ Stream val$other;
                    {
                        this.this$1 = var1_1;
                        this.val$other = stream;
                    }

                    public Stream<Tuple2<A, B>> apply(A x) {
                        return this.val$other.flatMap(new AbstractFunction<B, Stream<Tuple2<A, B>>>(this, x){
                            final /* synthetic */ 7 this$2;
                            private final /* synthetic */ Object val$x;
                            {
                                this.this$2 = var1_1;
                                this.val$x = object;
                            }

                            public Stream<Tuple2<A, B>> apply(B y) {
                                return Streams.cons(Tuples._(this.val$x, y));
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    public Stream<Stream<A>> crossStreams(@NonNull Stream<Stream<A>> other) {
        Ensure.isNotNull("var0", other);
        Ensure.that().isNotEmpty("other", other);
        return AbstractStream.fcross(other.prepend(this));
    }

    private static <A> Stream<Stream<A>> fcross(Stream<Stream<A>> other) {
        return other.transform(new AbstractFunction<Stream<Stream<A>>, Stream<Stream<A>>>(){

            @Override
            public Stream<Stream<A>> apply(Stream<Stream<A>> xss_) {
                Stream xss = xss_.memorize();
                if (xss.size() == 2) {
                    return ((Stream)xss.first()).flatMap(new AbstractFunction<A, Stream<Stream<A>>>(this, xss){
                        final /* synthetic */ 9 this$1;
                        private final /* synthetic */ Stream val$xss;
                        {
                            this.this$1 = var1_1;
                            this.val$xss = stream;
                        }

                        public Stream<Stream<A>> apply(A x) {
                            return ((Stream)this.val$xss.second()).flatMap(new AbstractFunction<A, Stream<Stream<A>>>(this, x){
                                final /* synthetic */ 10 this$2;
                                private final /* synthetic */ Object val$x;
                                {
                                    this.this$2 = var1_1;
                                    this.val$x = object;
                                }

                                public Stream<Stream<A>> apply(A y) {
                                    return Streams.cons(Streams.cons(new Object[]{this.val$x, y}));
                                }
                            });
                        }
                    });
                }
                return ((Stream)xss.head()).flatMap(new AbstractFunction<A, Stream<Stream<A>>>(this, xss){
                    final /* synthetic */ 9 this$1;
                    private final /* synthetic */ Stream val$xss;
                    {
                        this.this$1 = var1_1;
                        this.val$xss = stream;
                    }

                    public Stream<Stream<A>> apply(A x) {
                        return AbstractStream.access$3(this.val$xss.tail()).flatMap(new AbstractFunction<Stream<A>, Stream<Stream<A>>>(this, x){
                            final /* synthetic */ 12 this$2;
                            private final /* synthetic */ Object val$x;
                            {
                                this.this$2 = var1_1;
                                this.val$x = object;
                            }

                            public Stream<Stream<A>> apply(Stream<A> ys) {
                                return Streams.cons(Streams.cons(this.val$x, ys));
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    public final void print(Appendable o) throws IOException {
        o.append('[');
        Tuple2<A, Stream<A>> ht = this.decons();
        this.printElement(o, ht._0());
        for (Object element : (Stream)ht._1()) {
            o.append(", ");
            this.printElement(o, element);
        }
        o.append(']');
    }

    private void printElement(Appendable o, A element) throws IOException {
        if (element instanceof Stream) {
            ((Stream)element).print(o);
        } else {
            o.append(String.valueOf(element));
        }
    }

    @Override
    public final void print() {
        try {
            this.println(System.out);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public final void println(Appendable o) throws IOException {
        this.print(o);
        o.append('\n');
    }

    @Override
    public final void println() {
        try {
            this.println(System.out);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public final String printString() {
        try {
            StringBuilder sb = new StringBuilder();
            this.print(sb);
            return sb.toString();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Constant
    private static <A> Function<A[], Iterable<A>> toIterable() {
        return TO_ITERABLE;
    }

    public final String toString() {
        return ToString.toString(this);
    }

    static /* synthetic */ Stream access$3(Stream stream) {
        return AbstractStream.fcross(stream);
    }

    private static Predicate2 equalOrEquivInitializer() {
        return Equiv.equalNullSafe().or(new AbstractPredicate2<A, A>(){

            @Override
            public boolean eval(A arg0, A arg1) {
                return arg0 instanceof Stream && arg1 instanceof Stream && ((Stream)arg0).equiv((Stream)arg1);
            }
        });
    }

    private static Function toIterableInitializer() {
        return new AbstractFunction<A[], Iterable<A>>(){

            @Override
            public Iterable<A> apply(A[] arg) {
                return Arrays.asList(arg);
            }
        };
    }
}

