/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.collections;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.collections.iterable.Iterables;
import net.sf.staccatocommons.defs.Applicable;
import net.sf.staccatocommons.defs.tuple.Tuple2;
import net.sf.staccatocommons.lang.MapBuilder;
import net.sf.staccatocommons.lang.Option;
import net.sf.staccatocommons.restrictions.check.NonNull;

public class Maps {
    @NonNull
    public static <V> Option<V> get(@NonNull Map<?, V> map, Object key) {
        Ensure.isNotNull("var0", map);
        V value = map.get(key);
        if (value != null) {
            return Option.some(value);
        }
        if (map.containsKey(key)) {
            return Option.someNull();
        }
        return Option.none();
    }

    @NonNull
    public static <V> V getExistent(@NonNull Map<?, V> map, Object key) {
        Ensure.isNotNull("var0", map);
        V value = map.get(key);
        if (value != null) {
            return value;
        }
        if (map.containsKey(key)) {
            return null;
        }
        throw new NoSuchElementException("No entry found for key " + key);
    }

    @NonNull
    public static <K> Option<K> anyKey(@NonNull Map<K, ?> map) {
        Ensure.isNotNull("var0", map);
        if (map.isEmpty()) {
            return Option.none();
        }
        return Option.some(Iterables.any((Iterable)map.keySet()));
    }

    public static <K> K anyKeyOrNull(@NonNull Map<K, ?> map) {
        Ensure.isNotNull("var0", map);
        if (map.isEmpty()) {
            return null;
        }
        return (K)Iterables.any((Iterable)map.keySet());
    }

    @NonNull
    public static <V> Option<V> anyValue(@NonNull Map<?, V> map) {
        Ensure.isNotNull("var0", map);
        if (map.isEmpty()) {
            return Option.none();
        }
        return Option.some(Iterables.any((Iterable)map.values()));
    }

    public static <V> V anyValueOrNull(@NonNull Map<?, V> map) {
        Ensure.isNotNull("var0", map);
        if (map.isEmpty()) {
            return null;
        }
        return (V)Iterables.any((Iterable)map.values());
    }

    public static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static <K, V1, V2> Map<K, V2> mapKeys(Map<K, V1> map, Applicable<V1, V2> function) {
        LinkedHashMap<K, V2> result = new LinkedHashMap<K, V2>();
        for (Map.Entry<K, V1> e : map.entrySet()) {
            result.put(e.getKey(), function.apply(e.getValue()));
        }
        return Collections.unmodifiableMap(result);
    }

    public static <K, V1, V2> Map<K, V2> delayedMapKeys(final Map<K, V1> map, final Applicable<? super V1, ? extends V2> function) {
        return Collections.unmodifiableMap(new LinkedHashMap<K, V2>(){

            @Override
            public V2 get(Object key) {
                return function.apply(map.get(key));
            }
        });
    }

    public static <K, V> Map<K, V> from(Iterable<Tuple2<K, V>> entries) {
        MapBuilder<K, V, Map<K, V>> b = MapBuilder.from(new LinkedHashMap());
        for (Tuple2<K, V> p : entries) {
            b.with(p);
        }
        return b.build();
    }

    public static <K, V> Map<K, V> from(Tuple2<K, V> ... entries) {
        return Maps.from((Iterable)Arrays.asList(entries));
    }
}

