/*
 * Decompiled with CFR 0.152.
 */
package com.zauberlabs.commons.mom.converter;

import com.zauberlabs.commons.mom.converter.TypeConverter;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.restrictions.Constant;
import net.sf.staccatocommons.restrictions.check.NonNull;

public final class IdentityTypeConverter
implements TypeConverter {
    private static final TypeConverter CONVERTER = IdentityTypeConverter.converterInitializer();

    @Override
    public boolean canConvert(@NonNull Class<?> sourceType, @NonNull Class<?> destinationType) {
        Ensure.isNotNull("var1", destinationType);
        Ensure.isNotNull("var0", sourceType);
        return destinationType.isAssignableFrom(sourceType);
    }

    @Override
    public <A> A convert(Object value, Class<A> destinationType) {
        Ensure.that(value == null || this.canConvert(value.getClass(), destinationType), "%s is not of type %s", value, destinationType);
        return (A)value;
    }

    @Constant
    public static TypeConverter converter() {
        return CONVERTER;
    }

    private static TypeConverter converterInitializer() {
        return new IdentityTypeConverter();
    }
}

