/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.wadl;

import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.server.wadl.WadlApplicationContext;
import com.sun.jersey.server.wadl.WadlBuilder;
import com.sun.jersey.server.wadl.WadlGenerator;
import com.sun.research.ws.wadl.Application;
import java.util.Set;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

public class WadlApplicationContextImpl
implements WadlApplicationContext {
    private final Set<AbstractResource> rootResources;
    private final WadlGenerator wadlGenerator;
    private JAXBContext jaxbContext;

    public WadlApplicationContextImpl(Set<AbstractResource> rootResources, WadlGenerator wadlGenerator) {
        this.rootResources = rootResources;
        this.wadlGenerator = wadlGenerator;
        try {
            this.jaxbContext = JAXBContext.newInstance(wadlGenerator.getRequiredJaxbContextPath());
        }
        catch (JAXBException ex) {
            this.jaxbContext = null;
        }
    }

    @Override
    public Application getApplication() {
        return this.getWadlBuilder().generate(this.rootResources);
    }

    @Override
    public Application getApplication(UriInfo ui) {
        Application a = this.getWadlBuilder().generate(this.rootResources);
        a.getResources().setBase(ui.getBaseUri().toString());
        return a;
    }

    @Override
    public JAXBContext getJAXBContext() {
        return this.jaxbContext;
    }

    @Override
    public String getJAXBContextPath() {
        return this.wadlGenerator.getRequiredJaxbContextPath();
    }

    @Override
    public WadlBuilder getWadlBuilder() {
        return new WadlBuilder(this.wadlGenerator);
    }
}

