
package org.mule.modules.zendesk.model.transformers;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.MessageTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.modules.zendesk.model.UserIdentity;
import org.mule.modules.zendesk.model.holders.EntityExpressionHolder;
import org.mule.modules.zendesk.model.holders.UserIdentityExpressionHolder;
import org.mule.transformer.types.DataTypeFactory;

@Generated(value = "Mule DevKit Version 3.5.3", date = "2015-12-11T04:07:29-03:00", comments = "Build UNNAMED.2049.ec39f2b")
public class UserIdentityExpressionHolderTransformer
    extends ExpressionEvaluatorSupport
    implements DiscoverableTransformer, MessageTransformer
{

    private int weighting = DiscoverableTransformer.DEFAULT_PRIORITY_WEIGHTING;
    private ImmutableEndpoint endpoint;
    private MuleContext muleContext;
    private String name;

    public int getPriorityWeighting() {
        return weighting;
    }

    public void setPriorityWeighting(int weighting) {
        this.weighting = weighting;
    }

    public boolean isSourceTypeSupported(Class<?> aClass) {
        return (aClass == UserIdentityExpressionHolder.class);
    }

    public boolean isSourceDataTypeSupported(DataType<?> dataType) {
        return (dataType.getType() == UserIdentityExpressionHolder.class);
    }

    public List<Class<?>> getSourceTypes() {
        return Arrays.asList(new Class<?> [] {UserIdentityExpressionHolder.class });
    }

    public List<DataType<?>> getSourceDataTypes() {
        return Arrays.asList(new DataType<?> [] {DataTypeFactory.create(UserIdentityExpressionHolder.class)});
    }

    public boolean isAcceptNull() {
        return false;
    }

    public boolean isIgnoreBadInput() {
        return false;
    }

    public Object transform(Object src)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public Object transform(Object src, String encoding)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public void setReturnClass(Class<?> theClass) {
        throw new UnsupportedOperationException();
    }

    public Class<?> getReturnClass() {
        return UserIdentity.class;
    }

    public void setReturnDataType(DataType<?> type) {
        throw new UnsupportedOperationException();
    }

    public DataType<?> getReturnDataType() {
        return DataTypeFactory.create(UserIdentity.class);
    }

    public void setEndpoint(ImmutableEndpoint ep) {
        endpoint = ep;
    }

    public ImmutableEndpoint getEndpoint() {
        return endpoint;
    }

    public void dispose() {
    }

    public void initialise()
        throws InitialisationException
    {
    }

    public void setMuleContext(MuleContext context) {
        muleContext = context;
    }

    public void setName(String newName) {
        name = newName;
    }

    public String getName() {
        return name;
    }

    public Object transform(Object src, MuleEvent event)
        throws TransformerMessagingException
    {
        return transform(src, null, event);
    }

    public Object transform(Object src, String encoding, MuleEvent event)
        throws TransformerMessagingException
    {
        if (src == null) {
            return null;
        }
        UserIdentityExpressionHolder holder = ((UserIdentityExpressionHolder) src);
        UserIdentity result = new UserIdentity();
        try {
            final Long _transformedUserId = ((Long) evaluateAndTransform(this.muleContext, event, UserIdentityExpressionHolder.class.getDeclaredField("_userIdType").getGenericType(), null, holder.getUserId()));
            result.setUserId(_transformedUserId);
            final String _transformedType = ((String) evaluateAndTransform(this.muleContext, event, UserIdentityExpressionHolder.class.getDeclaredField("_typeType").getGenericType(), null, holder.getType()));
            result.setType(_transformedType);
            final String _transformedValue = ((String) evaluateAndTransform(this.muleContext, event, UserIdentityExpressionHolder.class.getDeclaredField("_valueType").getGenericType(), null, holder.getValue()));
            result.setValue(_transformedValue);
            final Boolean _transformedVerified = ((Boolean) evaluateAndTransform(this.muleContext, event, UserIdentityExpressionHolder.class.getDeclaredField("_verifiedType").getGenericType(), null, holder.getVerified()));
            result.setVerified(_transformedVerified);
            final Boolean _transformedPrimary = ((Boolean) evaluateAndTransform(this.muleContext, event, UserIdentityExpressionHolder.class.getDeclaredField("_primaryType").getGenericType(), null, holder.getPrimary()));
            result.setPrimary(_transformedPrimary);
            final Long _transformedId = ((Long) evaluateAndTransform(this.muleContext, event, EntityExpressionHolder.class.getDeclaredField("_idType").getGenericType(), null, holder.getId()));
            result.setId(_transformedId);
            final String _transformedUrl = ((String) evaluateAndTransform(this.muleContext, event, EntityExpressionHolder.class.getDeclaredField("_urlType").getGenericType(), null, holder.getUrl()));
            result.setUrl(_transformedUrl);
            final Date _transformedCreatedAt = ((Date) evaluateAndTransform(this.muleContext, event, EntityExpressionHolder.class.getDeclaredField("_createdAtType").getGenericType(), null, holder.getCreatedAt()));
            result.setCreatedAt(_transformedCreatedAt);
            final Date _transformedUpdatedAt = ((Date) evaluateAndTransform(this.muleContext, event, EntityExpressionHolder.class.getDeclaredField("_updatedAtType").getGenericType(), null, holder.getUpdatedAt()));
            result.setUpdatedAt(_transformedUpdatedAt);
        } catch (NoSuchFieldException e) {
            throw new TransformerMessagingException(CoreMessages.createStaticMessage("internal error"), event, this, e);
        } catch (TransformerException e) {
            throw new TransformerMessagingException(e.getI18nMessage(), event, this, e);
        }
        return result;
    }

    public MuleEvent process(MuleEvent event) {
        return null;
    }

    public String getMimeType() {
        return null;
    }

    public String getEncoding() {
        return null;
    }

    public MuleContext getMuleContext() {
        return muleContext;
    }

}
