
package org.mule.modules.zendesk.model.transformers;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.MessageTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.modules.zendesk.model.Topic;
import org.mule.modules.zendesk.model.holders.EntityExpressionHolder;
import org.mule.modules.zendesk.model.holders.TopicExpressionHolder;
import org.mule.transformer.types.DataTypeFactory;

@Generated(value = "Mule DevKit Version 3.5.3", date = "2015-12-11T04:07:29-03:00", comments = "Build UNNAMED.2049.ec39f2b")
public class TopicExpressionHolderTransformer
    extends ExpressionEvaluatorSupport
    implements DiscoverableTransformer, MessageTransformer
{

    private int weighting = DiscoverableTransformer.DEFAULT_PRIORITY_WEIGHTING;
    private ImmutableEndpoint endpoint;
    private MuleContext muleContext;
    private String name;

    public int getPriorityWeighting() {
        return weighting;
    }

    public void setPriorityWeighting(int weighting) {
        this.weighting = weighting;
    }

    public boolean isSourceTypeSupported(Class<?> aClass) {
        return (aClass == TopicExpressionHolder.class);
    }

    public boolean isSourceDataTypeSupported(DataType<?> dataType) {
        return (dataType.getType() == TopicExpressionHolder.class);
    }

    public List<Class<?>> getSourceTypes() {
        return Arrays.asList(new Class<?> [] {TopicExpressionHolder.class });
    }

    public List<DataType<?>> getSourceDataTypes() {
        return Arrays.asList(new DataType<?> [] {DataTypeFactory.create(TopicExpressionHolder.class)});
    }

    public boolean isAcceptNull() {
        return false;
    }

    public boolean isIgnoreBadInput() {
        return false;
    }

    public Object transform(Object src)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public Object transform(Object src, String encoding)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public void setReturnClass(Class<?> theClass) {
        throw new UnsupportedOperationException();
    }

    public Class<?> getReturnClass() {
        return Topic.class;
    }

    public void setReturnDataType(DataType<?> type) {
        throw new UnsupportedOperationException();
    }

    public DataType<?> getReturnDataType() {
        return DataTypeFactory.create(Topic.class);
    }

    public void setEndpoint(ImmutableEndpoint ep) {
        endpoint = ep;
    }

    public ImmutableEndpoint getEndpoint() {
        return endpoint;
    }

    public void dispose() {
    }

    public void initialise()
        throws InitialisationException
    {
    }

    public void setMuleContext(MuleContext context) {
        muleContext = context;
    }

    public void setName(String newName) {
        name = newName;
    }

    public String getName() {
        return name;
    }

    public Object transform(Object src, MuleEvent event)
        throws TransformerMessagingException
    {
        return transform(src, null, event);
    }

    public Object transform(Object src, String encoding, MuleEvent event)
        throws TransformerMessagingException
    {
        if (src == null) {
            return null;
        }
        TopicExpressionHolder holder = ((TopicExpressionHolder) src);
        Topic result = new Topic();
        try {
            final String _transformedTitle = ((String) evaluateAndTransform(this.muleContext, event, TopicExpressionHolder.class.getDeclaredField("_titleType").getGenericType(), null, holder.getTitle()));
            result.setTitle(_transformedTitle);
            final String _transformedBody = ((String) evaluateAndTransform(this.muleContext, event, TopicExpressionHolder.class.getDeclaredField("_bodyType").getGenericType(), null, holder.getBody()));
            result.setBody(_transformedBody);
            final String _transformedTopicType = ((String) evaluateAndTransform(this.muleContext, event, TopicExpressionHolder.class.getDeclaredField("_topicTypeType").getGenericType(), null, holder.getTopicType()));
            result.setTopicType(_transformedTopicType);
            final Long _transformedSubmitterId = ((Long) evaluateAndTransform(this.muleContext, event, TopicExpressionHolder.class.getDeclaredField("_submitterIdType").getGenericType(), null, holder.getSubmitterId()));
            result.setSubmitterId(_transformedSubmitterId);
            final Long _transformedUpdaterId = ((Long) evaluateAndTransform(this.muleContext, event, TopicExpressionHolder.class.getDeclaredField("_updaterIdType").getGenericType(), null, holder.getUpdaterId()));
            result.setUpdaterId(_transformedUpdaterId);
            final Long _transformedForumId = ((Long) evaluateAndTransform(this.muleContext, event, TopicExpressionHolder.class.getDeclaredField("_forumIdType").getGenericType(), null, holder.getForumId()));
            result.setForumId(_transformedForumId);
            final Boolean _transformedLocked = ((Boolean) evaluateAndTransform(this.muleContext, event, TopicExpressionHolder.class.getDeclaredField("_lockedType").getGenericType(), null, holder.getLocked()));
            result.setLocked(_transformedLocked);
            final Boolean _transformedPinned = ((Boolean) evaluateAndTransform(this.muleContext, event, TopicExpressionHolder.class.getDeclaredField("_pinnedType").getGenericType(), null, holder.getPinned()));
            result.setPinned(_transformedPinned);
            final Boolean _transformedHighlighted = ((Boolean) evaluateAndTransform(this.muleContext, event, TopicExpressionHolder.class.getDeclaredField("_highlightedType").getGenericType(), null, holder.getHighlighted()));
            result.setHighlighted(_transformedHighlighted);
            final Boolean _transformedAnswered = ((Boolean) evaluateAndTransform(this.muleContext, event, TopicExpressionHolder.class.getDeclaredField("_answeredType").getGenericType(), null, holder.getAnswered()));
            result.setAnswered(_transformedAnswered);
            final Integer _transformedCommentsCount = ((Integer) evaluateAndTransform(this.muleContext, event, TopicExpressionHolder.class.getDeclaredField("_commentsCountType").getGenericType(), null, holder.getCommentsCount()));
            result.setCommentsCount(_transformedCommentsCount);
            final Integer _transformedPosition = ((Integer) evaluateAndTransform(this.muleContext, event, TopicExpressionHolder.class.getDeclaredField("_positionType").getGenericType(), null, holder.getPosition()));
            result.setPosition(_transformedPosition);
            final List<String> _transformedTags = ((List<String> ) evaluateAndTransform(this.muleContext, event, TopicExpressionHolder.class.getDeclaredField("_tagsType").getGenericType(), null, holder.getTags()));
            result.setTags(_transformedTags);
            final Long _transformedId = ((Long) evaluateAndTransform(this.muleContext, event, EntityExpressionHolder.class.getDeclaredField("_idType").getGenericType(), null, holder.getId()));
            result.setId(_transformedId);
            final String _transformedUrl = ((String) evaluateAndTransform(this.muleContext, event, EntityExpressionHolder.class.getDeclaredField("_urlType").getGenericType(), null, holder.getUrl()));
            result.setUrl(_transformedUrl);
            final Date _transformedCreatedAt = ((Date) evaluateAndTransform(this.muleContext, event, EntityExpressionHolder.class.getDeclaredField("_createdAtType").getGenericType(), null, holder.getCreatedAt()));
            result.setCreatedAt(_transformedCreatedAt);
            final Date _transformedUpdatedAt = ((Date) evaluateAndTransform(this.muleContext, event, EntityExpressionHolder.class.getDeclaredField("_updatedAtType").getGenericType(), null, holder.getUpdatedAt()));
            result.setUpdatedAt(_transformedUpdatedAt);
        } catch (NoSuchFieldException e) {
            throw new TransformerMessagingException(CoreMessages.createStaticMessage("internal error"), event, this, e);
        } catch (TransformerException e) {
            throw new TransformerMessagingException(e.getI18nMessage(), event, this, e);
        }
        return result;
    }

    public MuleEvent process(MuleEvent event) {
        return null;
    }

    public String getMimeType() {
        return null;
    }

    public String getEncoding() {
        return null;
    }

    public MuleContext getMuleContext() {
        return muleContext;
    }

}
