/**
 * (c) 2003-2015 MuleSoft, Inc. The software in this package is
 * published under the terms of the CPAL v1.0 license, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */

package org.mule.modules.zendesk.model;

import java.util.Date;

/**
 * Ticket metrics class
 *
 * @author Mulesoft, Inc
 */
public class TicketMetric extends Entity {

    private Long ticketId;
    private Integer groupStations;
    private Integer assigneeStations;
    private Integer reopens;
    private Integer replies;
    private Date assigneeUpdatedAt;
    private Date requesterUpdatedAt;
    private Date statusUpdatedAt;
    private Date initiallyAssignedAt;
    private Date assignedAt;
    private Date solvedAt;
    private Date latestCommentAddedAt;
    private TimeSpent firstResolutionTimeInMinutes;
    private TimeSpent replyTimeInMinutes;
    private TimeSpent fullResolutionTimeInMinutes;
    private TimeSpent agentWaitTimeInMinutes;
    private TimeSpent requesterWaitTimeInMinutes;

    public Long getTicketId() {
        return ticketId;
    }

    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }

    public Integer getGroupStations() {
        return groupStations;
    }

    public void setGroupStations(Integer groupStations) {
        this.groupStations = groupStations;
    }

    public Integer getAssigneeStations() {
        return assigneeStations;
    }

    public void setAssigneeStations(Integer assigneeStations) {
        this.assigneeStations = assigneeStations;
    }

    public Integer getReopens() {
        return reopens;
    }

    public void setReopens(Integer reopens) {
        this.reopens = reopens;
    }

    public Integer getReplies() {
        return replies;
    }

    public void setReplies(Integer replies) {
        this.replies = replies;
    }

    public Date getAssigneeUpdatedAt() {
        return assigneeUpdatedAt;
    }

    public void setAssigneeUpdatedAt(Date assigneeUpdatedAt) {
        this.assigneeUpdatedAt = assigneeUpdatedAt;
    }

    public Date getRequesterUpdatedAt() {
        return requesterUpdatedAt;
    }

    public void setRequesterUpdatedAt(Date requesterUpdatedAt) {
        this.requesterUpdatedAt = requesterUpdatedAt;
    }

    public Date getStatusUpdatedAt() {
        return statusUpdatedAt;
    }

    public void setStatusUpdatedAt(Date statusUpdatedAt) {
        this.statusUpdatedAt = statusUpdatedAt;
    }

    public Date getInitiallyAssignedAt() {
        return initiallyAssignedAt;
    }

    public void setInitiallyAssignedAt(Date initiallyAssignedAt) {
        this.initiallyAssignedAt = initiallyAssignedAt;
    }

    public Date getAssignedAt() {
        return assignedAt;
    }

    public void setAssignedAt(Date assignedAt) {
        this.assignedAt = assignedAt;
    }

    public Date getSolvedAt() {
        return solvedAt;
    }

    public void setSolvedAt(Date solvedAt) {
        this.solvedAt = solvedAt;
    }

    public Date getLatestCommentAddedAt() {
        return latestCommentAddedAt;
    }

    public void setLatestCommentAddedAt(Date latestCommentAddedAt) {
        this.latestCommentAddedAt = latestCommentAddedAt;
    }

    public TimeSpent getFirstResolutionTimeInMinutes() {
        return firstResolutionTimeInMinutes;
    }

    public void setFirstResolutionTimeInMinutes(TimeSpent firstResolutionTimeInMinutes) {
        this.firstResolutionTimeInMinutes = firstResolutionTimeInMinutes;
    }

    public TimeSpent getReplyTimeInMinutes() {
        return replyTimeInMinutes;
    }

    public void setReplyTimeInMinutes(TimeSpent replyTimeInMinutes) {
        this.replyTimeInMinutes = replyTimeInMinutes;
    }

    public TimeSpent getFullResolutionTimeInMinutes() {
        return fullResolutionTimeInMinutes;
    }

    public void setFullResolutionTimeInMinutes(TimeSpent fullResolutionTimeInMinutes) {
        this.fullResolutionTimeInMinutes = fullResolutionTimeInMinutes;
    }

    public TimeSpent getAgentWaitTimeInMinutes() {
        return agentWaitTimeInMinutes;
    }

    public void setAgentWaitTimeInMinutes(TimeSpent agentWaitTimeInMinutes) {
        this.agentWaitTimeInMinutes = agentWaitTimeInMinutes;
    }

    public TimeSpent getRequesterWaitTimeInMinutes() {
        return requesterWaitTimeInMinutes;
    }

    public void setRequesterWaitTimeInMinutes(TimeSpent requesterWaitTimeInMinutes) {
        this.requesterWaitTimeInMinutes = requesterWaitTimeInMinutes;
    }
}
