
package org.mule.modules.zendesk.config;

import javax.annotation.Generated;
import org.mule.config.MuleManifest;
import org.mule.modules.zendesk.model.holders.TopicExpressionHolder;
import org.mule.modules.zendesk.processors.UpdateTopicMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser.ParseDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

@Generated(value = "Mule DevKit Version 3.5.3", date = "2015-12-11T04:07:29-03:00", comments = "Build UNNAMED.2049.ec39f2b")
public class UpdateTopicDefinitionParser
    extends AbstractDevkitBasedDefinitionParser
{

    private static Logger logger = LoggerFactory.getLogger(UpdateTopicDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition(UpdateTopicMessageProcessor.class.getName());
        } catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            } catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error(("Cannot launch the mule app, the @Processor [update-topic] within the connector [zendesk] is not supported in mule "+ muleVersion));
            throw new BeanDefinitionParsingException(new Problem(("Cannot launch the mule app, the @Processor [update-topic] within the connector [zendesk] is not supported in mule "+ muleVersion), new Location(parserContext.getReaderContext().getResource()), null, noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue("updateTopic");
        builder.setScope(BeanDefinition.SCOPE_PROTOTYPE);
        parseConfigRef(element, builder);
        if (!parseObjectRefWithDefault(element, builder, "topic", "topic", "#[payload]")) {
            BeanDefinitionBuilder topicBuilder = BeanDefinitionBuilder.rootBeanDefinition(TopicExpressionHolder.class.getName());
            Element topicChildElement = DomUtils.getChildElementByTagName(element, "topic");
            if (topicChildElement!= null) {
                parseProperty(topicBuilder, topicChildElement, "id", "id");
                parseProperty(topicBuilder, topicChildElement, "url", "url");
                parseProperty(topicBuilder, topicChildElement, "createdAt", "createdAt");
                parseProperty(topicBuilder, topicChildElement, "updatedAt", "updatedAt");
                parseProperty(topicBuilder, topicChildElement, "title", "title");
                parseProperty(topicBuilder, topicChildElement, "body", "body");
                parseProperty(topicBuilder, topicChildElement, "topicType", "topicType");
                parseProperty(topicBuilder, topicChildElement, "submitterId", "submitterId");
                parseProperty(topicBuilder, topicChildElement, "updaterId", "updaterId");
                parseProperty(topicBuilder, topicChildElement, "forumId", "forumId");
                parseProperty(topicBuilder, topicChildElement, "locked", "locked");
                parseProperty(topicBuilder, topicChildElement, "pinned", "pinned");
                parseProperty(topicBuilder, topicChildElement, "highlighted", "highlighted");
                parseProperty(topicBuilder, topicChildElement, "answered", "answered");
                parseProperty(topicBuilder, topicChildElement, "commentsCount", "commentsCount");
                parseProperty(topicBuilder, topicChildElement, "position", "position");
                parseListAndSetProperty(topicChildElement, topicBuilder, "tags", "tags", "tag", new ParseDelegate<String>() {


                    public String parse(Element element) {
                        return element.getTextContent();
                    }

                }
                );
                builder.addPropertyValue("topic", topicBuilder.getBeanDefinition());
            }
        }
        parseProperty(builder, element, "username", "username");
        parseProperty(builder, element, "password", "password");
        BeanDefinition definition = builder.getBeanDefinition();
        setNoRecurseOnDefinition(definition);
        attachProcessorDefinition(parserContext, definition);
        return definition;
    }

}
