
package org.mule.modules.zendesk.config;

import javax.annotation.Generated;
import org.mule.config.MuleManifest;
import org.mule.modules.zendesk.model.holders.OrganizationExpressionHolder;
import org.mule.modules.zendesk.processors.UpdateOrganizationMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser.ParseDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

@Generated(value = "Mule DevKit Version 3.5.3", date = "2015-12-11T04:07:29-03:00", comments = "Build UNNAMED.2049.ec39f2b")
public class UpdateOrganizationDefinitionParser
    extends AbstractDevkitBasedDefinitionParser
{

    private static Logger logger = LoggerFactory.getLogger(UpdateOrganizationDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition(UpdateOrganizationMessageProcessor.class.getName());
        } catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            } catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error(("Cannot launch the mule app, the @Processor [update-organization] within the connector [zendesk] is not supported in mule "+ muleVersion));
            throw new BeanDefinitionParsingException(new Problem(("Cannot launch the mule app, the @Processor [update-organization] within the connector [zendesk] is not supported in mule "+ muleVersion), new Location(parserContext.getReaderContext().getResource()), null, noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue("updateOrganization");
        builder.setScope(BeanDefinition.SCOPE_PROTOTYPE);
        parseConfigRef(element, builder);
        if (!parseObjectRefWithDefault(element, builder, "organization", "organization", "#[payload]")) {
            BeanDefinitionBuilder organizationBuilder = BeanDefinitionBuilder.rootBeanDefinition(OrganizationExpressionHolder.class.getName());
            Element organizationChildElement = DomUtils.getChildElementByTagName(element, "organization");
            if (organizationChildElement!= null) {
                parseProperty(organizationBuilder, organizationChildElement, "id", "id");
                parseProperty(organizationBuilder, organizationChildElement, "url", "url");
                parseProperty(organizationBuilder, organizationChildElement, "createdAt", "createdAt");
                parseProperty(organizationBuilder, organizationChildElement, "updatedAt", "updatedAt");
                parseProperty(organizationBuilder, organizationChildElement, "externalId", "externalId");
                parseProperty(organizationBuilder, organizationChildElement, "name", "name");
                parseListAndSetProperty(organizationChildElement, organizationBuilder, "domainNames", "domain-names", "domain-name", new ParseDelegate<String>() {


                    public String parse(Element element) {
                        return element.getTextContent();
                    }

                }
                );
                parseProperty(organizationBuilder, organizationChildElement, "details", "details");
                parseProperty(organizationBuilder, organizationChildElement, "notes", "notes");
                parseProperty(organizationBuilder, organizationChildElement, "groupId", "groupId");
                parseProperty(organizationBuilder, organizationChildElement, "sharedTickets", "sharedTickets");
                parseProperty(organizationBuilder, organizationChildElement, "sharedComments", "sharedComments");
                parseListAndSetProperty(organizationChildElement, organizationBuilder, "tags", "tags", "tag", new ParseDelegate<String>() {


                    public String parse(Element element) {
                        return element.getTextContent();
                    }

                }
                );
                builder.addPropertyValue("organization", organizationBuilder.getBeanDefinition());
            }
        }
        parseProperty(builder, element, "username", "username");
        parseProperty(builder, element, "password", "password");
        BeanDefinition definition = builder.getBeanDefinition();
        setNoRecurseOnDefinition(definition);
        attachProcessorDefinition(parserContext, definition);
        return definition;
    }

}
