
package org.mule.modules.zendesk.config;

import javax.annotation.Generated;
import org.mule.config.MuleManifest;
import org.mule.modules.zendesk.model.holders.TopicSubscriptionExpressionHolder;
import org.mule.modules.zendesk.processors.CreateTopicSubscriptionMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

@Generated(value = "Mule DevKit Version 3.5.3", date = "2015-12-11T04:07:29-03:00", comments = "Build UNNAMED.2049.ec39f2b")
public class CreateTopicSubscriptionDefinitionParser
    extends AbstractDevkitBasedDefinitionParser
{

    private static Logger logger = LoggerFactory.getLogger(CreateTopicSubscriptionDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition(CreateTopicSubscriptionMessageProcessor.class.getName());
        } catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            } catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error(("Cannot launch the mule app, the @Processor [create-topic-subscription] within the connector [zendesk] is not supported in mule "+ muleVersion));
            throw new BeanDefinitionParsingException(new Problem(("Cannot launch the mule app, the @Processor [create-topic-subscription] within the connector [zendesk] is not supported in mule "+ muleVersion), new Location(parserContext.getReaderContext().getResource()), null, noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue("createTopicSubscription");
        builder.setScope(BeanDefinition.SCOPE_PROTOTYPE);
        parseConfigRef(element, builder);
        if (!parseObjectRefWithDefault(element, builder, "topic-subscription", "topicSubscription", "#[payload]")) {
            BeanDefinitionBuilder topicSubscriptionBuilder = BeanDefinitionBuilder.rootBeanDefinition(TopicSubscriptionExpressionHolder.class.getName());
            Element topicSubscriptionChildElement = DomUtils.getChildElementByTagName(element, "topic-subscription");
            if (topicSubscriptionChildElement!= null) {
                parseProperty(topicSubscriptionBuilder, topicSubscriptionChildElement, "id", "id");
                parseProperty(topicSubscriptionBuilder, topicSubscriptionChildElement, "url", "url");
                parseProperty(topicSubscriptionBuilder, topicSubscriptionChildElement, "createdAt", "createdAt");
                parseProperty(topicSubscriptionBuilder, topicSubscriptionChildElement, "updatedAt", "updatedAt");
                parseProperty(topicSubscriptionBuilder, topicSubscriptionChildElement, "topicId", "topicId");
                parseProperty(topicSubscriptionBuilder, topicSubscriptionChildElement, "userId", "userId");
                builder.addPropertyValue("topicSubscription", topicSubscriptionBuilder.getBeanDefinition());
            }
        }
        parseProperty(builder, element, "username", "username");
        parseProperty(builder, element, "password", "password");
        BeanDefinition definition = builder.getBeanDefinition();
        setNoRecurseOnDefinition(definition);
        attachProcessorDefinition(parserContext, definition);
        return definition;
    }

}
