
package org.mule.modules.zendesk.config;

import javax.annotation.Generated;
import org.mule.config.MuleManifest;
import org.mule.modules.zendesk.model.holders.CustomFieldExpressionHolder;
import org.mule.modules.zendesk.model.holders.RequestExpressionHolder;
import org.mule.modules.zendesk.model.holders.ViaExpressionHolder;
import org.mule.modules.zendesk.processors.CreateRequestMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser.ParseDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

@Generated(value = "Mule DevKit Version 3.5.3", date = "2015-12-11T04:07:29-03:00", comments = "Build UNNAMED.2049.ec39f2b")
public class CreateRequestDefinitionParser
    extends AbstractDevkitBasedDefinitionParser
{

    private static Logger logger = LoggerFactory.getLogger(CreateRequestDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition(CreateRequestMessageProcessor.class.getName());
        } catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            } catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error(("Cannot launch the mule app, the @Processor [create-request] within the connector [zendesk] is not supported in mule "+ muleVersion));
            throw new BeanDefinitionParsingException(new Problem(("Cannot launch the mule app, the @Processor [create-request] within the connector [zendesk] is not supported in mule "+ muleVersion), new Location(parserContext.getReaderContext().getResource()), null, noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue("createRequest");
        builder.setScope(BeanDefinition.SCOPE_PROTOTYPE);
        parseConfigRef(element, builder);
        if (!parseObjectRefWithDefault(element, builder, "request", "request", "#[payload]")) {
            BeanDefinitionBuilder requestBuilder = BeanDefinitionBuilder.rootBeanDefinition(RequestExpressionHolder.class.getName());
            Element requestChildElement = DomUtils.getChildElementByTagName(element, "request");
            if (requestChildElement!= null) {
                parseProperty(requestBuilder, requestChildElement, "id", "id");
                parseProperty(requestBuilder, requestChildElement, "url", "url");
                parseProperty(requestBuilder, requestChildElement, "createdAt", "createdAt");
                parseProperty(requestBuilder, requestChildElement, "updatedAt", "updatedAt");
                parseProperty(requestBuilder, requestChildElement, "subject", "subject");
                parseProperty(requestBuilder, requestChildElement, "description", "description");
                parseProperty(requestBuilder, requestChildElement, "status", "status");
                parseListAndSetProperty(requestChildElement, requestBuilder, "customFields", "custom-fields", "custom-field", new ParseDelegate<BeanDefinition>() {


                    public BeanDefinition parse(Element element) {
                        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(CustomFieldExpressionHolder.class);
                        parseProperty(builder, element, "id", "id");
                        parseProperty(builder, element, "value", "value");
                        parseProperty(builder, element, "url", "url");
                        parseProperty(builder, element, "title", "title");
                        return builder.getBeanDefinition();
                    }

                }
                );
                parseProperty(requestBuilder, requestChildElement, "organizationId", "organizationId");
                parseProperty(requestBuilder, requestChildElement, "requesterid", "requesterid");
                if (!parseObjectRef(requestChildElement, requestBuilder, "via", "via")) {
                    BeanDefinitionBuilder _viaBuilder = BeanDefinitionBuilder.rootBeanDefinition(ViaExpressionHolder.class.getName());
                    Element _viaChildElement = DomUtils.getChildElementByTagName(requestChildElement, "via");
                    if (_viaChildElement!= null) {
                        parseProperty(_viaBuilder, _viaChildElement, "channel", "channel");
                        if (hasAttribute(_viaChildElement, "source-ref")) {
                            if (_viaChildElement.getAttribute("source-ref").startsWith("#")) {
                                _viaBuilder.addPropertyValue("source", _viaChildElement.getAttribute("source-ref"));
                            } else {
                                _viaBuilder.addPropertyValue("source", (("#[registry:"+ _viaChildElement.getAttribute("source-ref"))+"]"));
                            }
                        }
                        requestBuilder.addPropertyValue("via", _viaBuilder.getBeanDefinition());
                    }
                }
                builder.addPropertyValue("request", requestBuilder.getBeanDefinition());
            }
        }
        parseProperty(builder, element, "username", "username");
        parseProperty(builder, element, "password", "password");
        BeanDefinition definition = builder.getBeanDefinition();
        setNoRecurseOnDefinition(definition);
        attachProcessorDefinition(parserContext, definition);
        return definition;
    }

}
