/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.zendesk.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.common.DefaultResult;
import org.mule.common.DefaultTestResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.Testable;
import org.mule.config.PoolingProfile;
import org.mule.modules.zendesk.adapters.ZendeskConnectorConnectionIdentifierAdapter;
import org.mule.modules.zendesk.basic.Capabilities;
import org.mule.modules.zendesk.basic.Capability;
import org.mule.modules.zendesk.basic.MetadataAware;
import org.mule.modules.zendesk.connection.ConnectionManager;
import org.mule.modules.zendesk.connectivity.ManagedConnectionProcessTemplate;
import org.mule.modules.zendesk.connectivity.ZendeskConnectorConnectionFactory;
import org.mule.modules.zendesk.connectivity.ZendeskConnectorConnectionKey;
import org.mule.modules.zendesk.process.ProcessAdapter;
import org.mule.modules.zendesk.process.ProcessTemplate;

public class ZendeskConnectorConnectionManager
implements MuleContextAware,
Initialisable,
Testable,
Capabilities,
MetadataAware,
ConnectionManager<ZendeskConnectorConnectionKey, ZendeskConnectorConnectionIdentifierAdapter>,
ProcessAdapter<ZendeskConnectorConnectionIdentifierAdapter> {
    private String username;
    private String password;
    private String apiUrl;
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    private GenericKeyedObjectPool connectionPool;
    protected PoolingProfile connectionPoolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private static final String MODULE_NAME = "Zendesk";
    private static final String MODULE_VERSION = "1.1";
    private static final String DEVKIT_VERSION = "3.4.0";
    private static final String DEVKIT_BUILD = "3.4.0.1555.8df15c1";

    public void setApiUrl(String value) {
        this.apiUrl = value;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setFlowConstruct(FlowConstruct value) {
        this.flowConstruct = value;
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    @Override
    public void setConnectionPoolingProfile(PoolingProfile value) {
        this.connectionPoolingProfile = value;
    }

    @Override
    public PoolingProfile getConnectionPoolingProfile() {
        return this.connectionPoolingProfile;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void setUsername(String value) {
        this.username = value;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void initialise() {
        GenericKeyedObjectPool.Config config = new GenericKeyedObjectPool.Config();
        if (this.connectionPoolingProfile != null) {
            config.maxIdle = this.connectionPoolingProfile.getMaxIdle();
            config.maxActive = this.connectionPoolingProfile.getMaxActive();
            config.maxWait = this.connectionPoolingProfile.getMaxWait();
            config.whenExhaustedAction = (byte)this.connectionPoolingProfile.getExhaustedAction();
            config.timeBetweenEvictionRunsMillis = this.connectionPoolingProfile.getEvictionCheckIntervalMillis();
            config.minEvictableIdleTimeMillis = this.connectionPoolingProfile.getMinEvictionMillis();
        }
        this.connectionPool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new ZendeskConnectorConnectionFactory(this), config);
        if (this.retryPolicyTemplate == null) {
            this.retryPolicyTemplate = (RetryPolicyTemplate)this.muleContext.getRegistry().lookupObject("_defaultRetryPolicyTemplate");
        }
    }

    @Override
    public ZendeskConnectorConnectionIdentifierAdapter acquireConnection(ZendeskConnectorConnectionKey key) throws Exception {
        return (ZendeskConnectorConnectionIdentifierAdapter)this.connectionPool.borrowObject((Object)key);
    }

    @Override
    public void releaseConnection(ZendeskConnectorConnectionKey key, ZendeskConnectorConnectionIdentifierAdapter connection) throws Exception {
        this.connectionPool.returnObject((Object)key, (Object)connection);
    }

    @Override
    public void destroyConnection(ZendeskConnectorConnectionKey key, ZendeskConnectorConnectionIdentifierAdapter connection) throws Exception {
        this.connectionPool.invalidateObject((Object)key, (Object)connection);
    }

    @Override
    public boolean isCapableOf(Capability capability) {
        if (capability == Capability.LIFECYCLE_CAPABLE) {
            return true;
        }
        return capability == Capability.CONNECTION_MANAGEMENT_CAPABLE;
    }

    @Override
    public <P> ProcessTemplate<P, ZendeskConnectorConnectionIdentifierAdapter> getProcessTemplate() {
        return new ManagedConnectionProcessTemplate(this, this.muleContext);
    }

    @Override
    public ZendeskConnectorConnectionKey getDefaultConnectionKey() {
        return new ZendeskConnectorConnectionKey(this.getUsername(), this.getPassword());
    }

    @Override
    public String getModuleName() {
        return MODULE_NAME;
    }

    @Override
    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    @Override
    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    @Override
    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult test() {
        DefaultTestResult result;
        ZendeskConnectorConnectionIdentifierAdapter connection = null;
        ZendeskConnectorConnectionKey key = this.getDefaultConnectionKey();
        try {
            connection = this.acquireConnection(key);
            result = new DefaultTestResult(Result.Status.SUCCESS);
        }
        catch (Exception e) {
            try {
                this.destroyConnection(key, connection);
            }
            catch (Exception ie) {
                // empty catch block
            }
            result = (DefaultTestResult)this.buildFailureTestResult(e);
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(key, connection);
                }
                catch (Exception ie) {}
            }
        }
        return result;
    }

    public DefaultResult buildFailureTestResult(Exception exception) {
        ConnectionExceptionCode code;
        DefaultTestResult result = exception instanceof ConnectionException ? ((code = ((ConnectionException)exception).getCode()) == ConnectionExceptionCode.UNKNOWN_HOST ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNKNOWN_HOST, (Throwable)exception) : (code == ConnectionExceptionCode.CANNOT_REACH ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.RESOURCE_UNAVAILABLE, (Throwable)exception) : (code == ConnectionExceptionCode.INCORRECT_CREDENTIALS ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.INVALID_CREDENTIALS, (Throwable)exception) : (code == ConnectionExceptionCode.CREDENTIALS_EXPIRED ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.INVALID_CREDENTIALS, (Throwable)exception) : (code == ConnectionExceptionCode.UNKNOWN ? new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, (Throwable)exception) : new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, (Throwable)exception)))))) : new DefaultTestResult(Result.Status.FAILURE, exception.getMessage(), FailureType.UNSPECIFIED, (Throwable)exception);
        return result;
    }
}

