/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.zendesk.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.modules.zendesk.adapters.ZendeskConnectorConnectionIdentifierAdapter;
import org.mule.modules.zendesk.connectivity.ZendeskConnectorConnectionKey;
import org.mule.modules.zendesk.connectivity.ZendeskConnectorConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZendeskConnectorConnectionFactory
implements KeyedPoolableObjectFactory {
    private static Logger logger = LoggerFactory.getLogger(ZendeskConnectorConnectionFactory.class);
    private ZendeskConnectorConnectionManager connectionManager;

    public ZendeskConnectorConnectionFactory(ZendeskConnectorConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Object makeObject(Object key) throws Exception {
        if (!(key instanceof ZendeskConnectorConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.modules.zendesk.connectivity.ZendeskConnectorConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        ZendeskConnectorConnectionIdentifierAdapter connector = new ZendeskConnectorConnectionIdentifierAdapter();
        connector.setApiUrl(this.connectionManager.getApiUrl());
        if (connector instanceof Initialisable) {
            connector.initialise();
        }
        if (connector instanceof MuleContextAware) {
            ((MuleContextAware)connector).setMuleContext(this.connectionManager.getMuleContext());
        }
        if (connector instanceof Startable) {
            connector.start();
        }
        if (!connector.isConnected()) {
            connector.connect(((ZendeskConnectorConnectionKey)key).getUsername(), ((ZendeskConnectorConnectionKey)key).getPassword());
        }
        return connector;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (!(key instanceof ZendeskConnectorConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("org.mule.modules.zendesk.connectivity.ZendeskConnectorConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        if (!(obj instanceof ZendeskConnectorConnectionIdentifierAdapter)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.modules.zendesk.adapters.ZendeskConnectorConnectionIdentifierAdapter")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            ((ZendeskConnectorConnectionIdentifierAdapter)obj).disconnect();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if ((ZendeskConnectorConnectionIdentifierAdapter)obj instanceof Stoppable) {
                ((Stoppable)obj).stop();
            }
            if ((ZendeskConnectorConnectionIdentifierAdapter)obj instanceof Disposable) {
                ((Disposable)obj).dispose();
            }
        }
    }

    public boolean validateObject(Object key, Object obj) {
        if (!(obj instanceof ZendeskConnectorConnectionIdentifierAdapter)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("org.mule.modules.zendesk.adapters.ZendeskConnectorConnectionIdentifierAdapter")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            return ((ZendeskConnectorConnectionIdentifierAdapter)obj).isConnected();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void activateObject(Object key, Object obj) throws Exception {
        if (!(key instanceof ZendeskConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof ZendeskConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        if (!((ZendeskConnectorConnectionIdentifierAdapter)obj).isConnected()) {
            ((ZendeskConnectorConnectionIdentifierAdapter)obj).connect(((ZendeskConnectorConnectionKey)key).getUsername(), ((ZendeskConnectorConnectionKey)key).getPassword());
        }
    }

    public void passivateObject(Object key, Object obj) throws Exception {
    }
}

