
package org.mule.modules.zendesk.model.transformers;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.MessageTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.modules.zendesk.model.Attachment;
import org.mule.modules.zendesk.model.User;
import org.mule.modules.zendesk.model.holders.UserExpressionHolder;
import org.mule.modules.zendesk.processors.AbstractExpressionEvaluator;
import org.mule.transformer.types.DataTypeFactory;

@Generated(value = "Mule DevKit Version 3.4.0", date = "2013-05-07T07:56:20-03:00", comments = "Build 3.4.0.1555.8df15c1")
public class UserExpressionHolderTransformer
    extends AbstractExpressionEvaluator
    implements DiscoverableTransformer, MessageTransformer
{

    private int weighting = DiscoverableTransformer.DEFAULT_PRIORITY_WEIGHTING;
    private ImmutableEndpoint endpoint;
    private MuleContext muleContext;
    private String name;

    public int getPriorityWeighting() {
        return weighting;
    }

    public void setPriorityWeighting(int weighting) {
        this.weighting = weighting;
    }

    public boolean isSourceTypeSupported(Class<?> aClass) {
        return (aClass == UserExpressionHolder.class);
    }

    public boolean isSourceDataTypeSupported(DataType<?> dataType) {
        return (dataType.getType() == UserExpressionHolder.class);
    }

    public List<Class<?>> getSourceTypes() {
        return Arrays.asList(new Class<?> [] {UserExpressionHolder.class });
    }

    public List<DataType<?>> getSourceDataTypes() {
        return Arrays.asList(new DataType<?> [] {DataTypeFactory.create(UserExpressionHolder.class)});
    }

    public boolean isAcceptNull() {
        return false;
    }

    public boolean isIgnoreBadInput() {
        return false;
    }

    public Object transform(Object src)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public Object transform(Object src, String encoding)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public void setReturnClass(Class<?> theClass) {
        throw new UnsupportedOperationException();
    }

    public Class<?> getReturnClass() {
        return User.class;
    }

    public void setReturnDataType(DataType<?> type) {
        throw new UnsupportedOperationException();
    }

    public DataType<?> getReturnDataType() {
        return DataTypeFactory.create(User.class);
    }

    public void setEndpoint(ImmutableEndpoint ep) {
        endpoint = ep;
    }

    public ImmutableEndpoint getEndpoint() {
        return endpoint;
    }

    public void dispose() {
    }

    public void initialise()
        throws InitialisationException
    {
    }

    public void setMuleContext(MuleContext context) {
        muleContext = context;
    }

    public void setName(String newName) {
        name = newName;
    }

    public String getName() {
        return name;
    }

    public Object transform(Object src, MuleEvent event)
        throws TransformerMessagingException
    {
        return transform(src, null, event);
    }

    public Object transform(Object src, String encoding, MuleEvent event)
        throws TransformerMessagingException
    {
        if (src == null) {
            return null;
        }
        UserExpressionHolder holder = ((UserExpressionHolder) src);
        User result = new User();
        try {
            final String _transformedName = ((String) evaluateAndTransform(this.muleContext, event, UserExpressionHolder.class.getDeclaredField("_nameType").getGenericType(), null, holder.getName()));
            result.setName(_transformedName);
            final String _transformedExternalId = ((String) evaluateAndTransform(this.muleContext, event, UserExpressionHolder.class.getDeclaredField("_externalIdType").getGenericType(), null, holder.getExternalId()));
            result.setExternalId(_transformedExternalId);
            final String _transformedAlias = ((String) evaluateAndTransform(this.muleContext, event, UserExpressionHolder.class.getDeclaredField("_aliasType").getGenericType(), null, holder.getAlias()));
            result.setAlias(_transformedAlias);
            final Boolean _transformedActive = ((Boolean) evaluateAndTransform(this.muleContext, event, UserExpressionHolder.class.getDeclaredField("_activeType").getGenericType(), null, holder.getActive()));
            result.setActive(_transformedActive);
            final Boolean _transformedVerified = ((Boolean) evaluateAndTransform(this.muleContext, event, UserExpressionHolder.class.getDeclaredField("_verifiedType").getGenericType(), null, holder.getVerified()));
            result.setVerified(_transformedVerified);
            final Boolean _transformedShared = ((Boolean) evaluateAndTransform(this.muleContext, event, UserExpressionHolder.class.getDeclaredField("_sharedType").getGenericType(), null, holder.getShared()));
            result.setShared(_transformedShared);
            final Long _transformedLocaleId = ((Long) evaluateAndTransform(this.muleContext, event, UserExpressionHolder.class.getDeclaredField("_localeIdType").getGenericType(), null, holder.getLocaleId()));
            result.setLocaleId(_transformedLocaleId);
            final String _transformedTimeZone = ((String) evaluateAndTransform(this.muleContext, event, UserExpressionHolder.class.getDeclaredField("_timeZoneType").getGenericType(), null, holder.getTimeZone()));
            result.setTimeZone(_transformedTimeZone);
            final Date _transformedLastLoginAt = ((Date) evaluateAndTransform(this.muleContext, event, UserExpressionHolder.class.getDeclaredField("_lastLoginAtType").getGenericType(), null, holder.getLastLoginAt()));
            result.setLastLoginAt(_transformedLastLoginAt);
            final String _transformedEmail = ((String) evaluateAndTransform(this.muleContext, event, UserExpressionHolder.class.getDeclaredField("_emailType").getGenericType(), null, holder.getEmail()));
            result.setEmail(_transformedEmail);
            final String _transformedPhone = ((String) evaluateAndTransform(this.muleContext, event, UserExpressionHolder.class.getDeclaredField("_phoneType").getGenericType(), null, holder.getPhone()));
            result.setPhone(_transformedPhone);
            final String _transformedSignature = ((String) evaluateAndTransform(this.muleContext, event, UserExpressionHolder.class.getDeclaredField("_signatureType").getGenericType(), null, holder.getSignature()));
            result.setSignature(_transformedSignature);
            final String _transformedDetails = ((String) evaluateAndTransform(this.muleContext, event, UserExpressionHolder.class.getDeclaredField("_detailsType").getGenericType(), null, holder.getDetails()));
            result.setDetails(_transformedDetails);
            final String _transformedNotes = ((String) evaluateAndTransform(this.muleContext, event, UserExpressionHolder.class.getDeclaredField("_notesType").getGenericType(), null, holder.getNotes()));
            result.setNotes(_transformedNotes);
            final Long _transformedOrganizationId = ((Long) evaluateAndTransform(this.muleContext, event, UserExpressionHolder.class.getDeclaredField("_organizationIdType").getGenericType(), null, holder.getOrganizationId()));
            result.setOrganizationId(_transformedOrganizationId);
            final String _transformedRole = ((String) evaluateAndTransform(this.muleContext, event, UserExpressionHolder.class.getDeclaredField("_roleType").getGenericType(), null, holder.getRole()));
            result.setRole(_transformedRole);
            final Long _transformedCustomRoleId = ((Long) evaluateAndTransform(this.muleContext, event, UserExpressionHolder.class.getDeclaredField("_customRoleIdType").getGenericType(), null, holder.getCustomRoleId()));
            result.setCustomRoleId(_transformedCustomRoleId);
            final Boolean _transformedModerator = ((Boolean) evaluateAndTransform(this.muleContext, event, UserExpressionHolder.class.getDeclaredField("_moderatorType").getGenericType(), null, holder.getModerator()));
            result.setModerator(_transformedModerator);
            final String _transformedTicketRestriction = ((String) evaluateAndTransform(this.muleContext, event, UserExpressionHolder.class.getDeclaredField("_ticketRestrictionType").getGenericType(), null, holder.getTicketRestriction()));
            result.setTicketRestriction(_transformedTicketRestriction);
            final Boolean _transformedOnlyPrivateComments = ((Boolean) evaluateAndTransform(this.muleContext, event, UserExpressionHolder.class.getDeclaredField("_onlyPrivateCommentsType").getGenericType(), null, holder.getOnlyPrivateComments()));
            result.setOnlyPrivateComments(_transformedOnlyPrivateComments);
            final List<String> _transformedTags = ((List<String> ) evaluateAndTransform(this.muleContext, event, UserExpressionHolder.class.getDeclaredField("_tagsType").getGenericType(), null, holder.getTags()));
            result.setTags(_transformedTags);
            final Boolean _transformedSuspended = ((Boolean) evaluateAndTransform(this.muleContext, event, UserExpressionHolder.class.getDeclaredField("_suspendedType").getGenericType(), null, holder.getSuspended()));
            result.setSuspended(_transformedSuspended);
            final Attachment _transformedPhoto = ((Attachment) evaluateAndTransform(this.muleContext, event, UserExpressionHolder.class.getDeclaredField("_photoType").getGenericType(), null, holder.getPhoto()));
            result.setPhoto(_transformedPhoto);
            final String _transformedRemotePhotoUrl = ((String) evaluateAndTransform(this.muleContext, event, UserExpressionHolder.class.getDeclaredField("_remotePhotoUrlType").getGenericType(), null, holder.getRemotePhotoUrl()));
            result.setRemotePhotoUrl(_transformedRemotePhotoUrl);
            final String _transformedPassword = ((String) evaluateAndTransform(this.muleContext, event, UserExpressionHolder.class.getDeclaredField("_passwordType").getGenericType(), null, holder.getPassword()));
            result.setPassword(_transformedPassword);
            final String _transformedPreviousPassword = ((String) evaluateAndTransform(this.muleContext, event, UserExpressionHolder.class.getDeclaredField("_previousPasswordType").getGenericType(), null, holder.getPreviousPassword()));
            result.setPreviousPassword(_transformedPreviousPassword);
        } catch (NoSuchFieldException e) {
            throw new TransformerMessagingException(CoreMessages.createStaticMessage("internal error"), event, this, e);
        } catch (TransformerException e) {
            throw new TransformerMessagingException(e.getI18nMessage(), event, this, e);
        }
        return result;
    }

    public MuleEvent process(MuleEvent event) {
        return null;
    }

    public String getMimeType() {
        return null;
    }

    public String getEncoding() {
        return null;
    }

    public MuleContext getMuleContext() {
        return muleContext;
    }

}
