/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.zendesk.model;

import com.google.gson.annotations.SerializedName;

import java.util.List;

/**
 * Ticket comment class
 *
 * @author Mulesoft, Inc
 */
public class TicketComment extends Entity {

    private String type;
    private String body;
    private String htmlBody;
    @SerializedName("public")
    private Boolean publicComment;
    private Boolean trusted;
    private Long authorId;
    private List<Attachment> attachment;

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getHtmlBody() {
        return htmlBody;
    }

    public void setHtmlBody(String htmlBody) {
        this.htmlBody = htmlBody;
    }

    public Boolean getPublicComment() {
        return publicComment;
    }

    public void setPublicComment(Boolean publicComment) {
        this.publicComment = publicComment;
    }

    public Boolean getTrusted() {
        return trusted;
    }

    public void setTrusted(Boolean trusted) {
        this.trusted = trusted;
    }

    public Long getAuthorId() {
        return authorId;
    }

    public void setAuthorId(Long authorId) {
        this.authorId = authorId;
    }

    public List<Attachment> getAttachment() {
        return attachment;
    }

    public void setAttachment(List<Attachment> attachment) {
        this.attachment = attachment;
    }
}
