/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.zendesk.model;

import org.apache.commons.collections.iterators.EntrySetMapIterator;
import org.apache.commons.lang.StringUtils;
import org.mule.modules.zendesk.model.responses.SearchResponse;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 */
public enum EntityType {

    TICKET(Ticket.class, "ticket", "tickets"),
    USER(User.class, "user", "users"),
    AUDIT(TicketAudit.class, "audit", "audits"),
    TICKET_FIELD(TicketField.class, "ticket_field", "ticketFields"),
    TICKET_METRIC(TicketMetric.class,"ticket_metric", "ticketMetrics"),
    VIEW(View.class, "view", "views"),
    USER_RELATED(UserRelated.class, "user_related", ""),
    ORGANIZATION_RELATED(OrganizationRelated.class, "organization_related", ""),
    REQUEST(Request.class, "request", "requests"),
    TICKET_COMMENT(TicketComment.class, "comment", "comments"),
    IDENTITY(UserIdentity.class, "identity", "identities"),
    GROUP(Group.class, "group", "groups"),
    GROUP_MEMBERSHIP(GroupMembership.class, "group_membership", "groupMemberships"),
    ORGANIZATION(Organization.class, "organization", "organizations"),
    FORUM(Forum.class, "forum", "forums"),
    FORUM_SUBSCRIPTION(ForumSubscription.class, "forum_subscription", "forumSubscriptions"),
    CATEGORY(Category.class, "category", "categories"),
    TOPIC(Topic.class, "topic", "topics"),
    TOPIC_SUBSCRIPTION(TopicSubscription.class, "topic_subscription", "topicSubscriptions"),
    TOPIC_VOTE(TopicVote.class, "topic_vote", "topicVotes"),
    TOPIC_COMMENT(TopicComment.class, "topic_comment", "topicComments"),
    ACTIVITY_STREAM(ActivityStream.class, "activity", "activities"),
    ATTACHMENT(Attachment.class, "attachment", "attachments"),
    FILE_UPLOAD(FileUpload.class, "upload", ""),
    AUTOMATION(Automation.class, "automation", "automations"),
    JOB_STATUS(JobStatus.class, "job_status", ""),
    LOCALE(Locale.class, "locale", "locales"),
    MACRO(Macro.class, "macro", "macros"),
    SATISFACTION_RATING(SatisfactionRating.class,"satisfaction_rating", "satisfactionRatings"),
    SHARING_AGREEMENT(SharingAgreement.class,"sharing_agreement", "sharing_agreements"),
    SUSPENDED_TICKET(SuspendedTicket.class, "suspended_ticket", "suspendedTickets"),
    TRIGGER(Trigger.class, "trigger", "triggers"),
    SEARCH_RESULTS(SearchResponse.class, "result", "results"),
    VIEW_COUNT(ViewCount.class, "view_count", "view_counts");

    private Class<?> type;
    private String plural;
    private String nameToSerialize;
    private static Map<Class<?>, String> mapLookup;


    private EntityType(Class<?> clazz, String nameToSerialize, String plural)
    {
        this.type = clazz;
        this.plural = plural;
        this.nameToSerialize = nameToSerialize;
    }

    public Class<?> getType()
    {
        return type;
    }

    public String getSimpleName()
    {
        return type.getSimpleName();
    }

    public String getNameForLists()
    {
        return StringUtils.capitalize(plural);
    }

    public static Class getClassOf(String serializeName) {
        if (mapLookup == null) {
            initializeMapping();
        }
        if (mapLookup.containsValue(serializeName)) {
            for(Map.Entry<Class<?>, String> entrySet : mapLookup.entrySet()) {
                if(entrySet.getValue().equals(serializeName)) return entrySet.getKey();
            }
        }
        return null;
    }

    public static String getNameToSerialize(Class clazz) {
        if (mapLookup == null) {
            initializeMapping();
        }
        if (mapLookup.containsKey(clazz)) {
            return mapLookup.get(clazz);
        }
        return null;
    }

    private static void initializeMapping() {
        mapLookup = new HashMap<Class<?>, String>();
        for (EntityType type : EntityType.values()) {
            mapLookup.put(type.type, type.nameToSerialize);
        }
    }
}
