/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.zendesk.jersey;

import com.sun.jersey.api.client.ClientResponse;
import org.mule.commons.jersey.ResponseHandler;
import org.mule.modules.zendesk.model.responses.ErrorResponse;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

/**
 * @author Mulesoft, Inc
 */
public class ZendeskResponseHandler implements ResponseHandler {
    @Override
    public <T> T onSuccess(ClientResponse response, Class<T> entityType) {
        return response.getEntity(entityType);
    }

    @Override
    public <T> T onFailure(ClientResponse response, int status, int[] expectedStatus) {
        ErrorResponse errorResponse = response.getEntity(ErrorResponse.class);
        throw new ZendeskException(String.format("Error trying to call Zendesk services. Status [%s]. Response: [%s]. Error: [%s] ; %s",
                status, response.toString(), errorResponse.getDescription(), showErrorDetails(errorResponse.getDetails())));
    }

    @Override
    public <T> T onNoContent(ClientResponse response) {
        return null;
    }

    private String showErrorDetails(Map<String, Object> errorDetails) {
        StringBuilder errorString = new StringBuilder();
        errorString.append("Details: ");

        if (errorDetails != null) {
            Iterator it = errorDetails.entrySet().iterator();
            while(it.hasNext()) {
                Map.Entry entry = (Map.Entry) it.next();
                errorString.append(entry.getValue().toString());
            }
        }

        return errorString.toString();
    }
}
