/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.zendesk.jersey;

import com.google.gson.*;
import org.mule.modules.zendesk.model.Entity;
import org.mule.modules.zendesk.model.EntityType;
import org.mule.modules.zendesk.model.responses.SearchResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;

/**
 * @author Mulesoft, Inc
 */
public class SearchDeserializer implements JsonDeserializer<SearchResponse> {

    @Override
    public SearchResponse deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
            throws JsonParseException {
        Gson gson = GsonFactory.getRawInstance();
        JsonArray results = json.getAsJsonObject().get("results").getAsJsonArray();

        Entity clazz;
        try {
            clazz = (Entity) EntityType.getClassOf(
                    results.get(0).getAsJsonObject().get("result_type").getAsString()).newInstance();
        } catch (InstantiationException e) {
            throw new ZendeskException("Cannot deserialize search results. Please check the search operation documentation.");
        } catch (IllegalAccessException e) {
            throw new ZendeskException("Cannot deserialize search results. Please check the search operation documentation.");
        }

        ArrayList searchResults = new ArrayList();
        SearchResponse response;

        try {
            for(JsonElement obj : results )
            {
                searchResults.add(gson.fromJson(obj, clazz.getClass()));
            }

            response = gson.fromJson(json, typeOfT);
            response.setResults(searchResults);
        }
        catch (Exception e) {
            throw new ZendeskException("Cannot deserialize search results. Please check the search operation documentation.");
        }

        return response;
    }
}
