/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.zendesk.jersey;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.mule.modules.zendesk.model.Entity;
import org.mule.modules.zendesk.model.responses.SearchResponse;

import java.util.Date;

/**
 *
 */
public abstract class GsonFactory {

	private final static Gson instance = new GsonBuilder()
            .setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES)
            .registerTypeAdapter(Date.class, new DateDeserializer())
            .registerTypeHierarchyAdapter(Entity.class, new EntitySerializer())
            .registerTypeHierarchyAdapter(Enum.class, new EnumValueAdapter())
            .registerTypeAdapter(SearchResponse.class, new SearchDeserializer())
            .create();

    private final static Gson raw = new GsonBuilder()
            .setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES)
            .registerTypeAdapter(Date.class, new DateDeserializer())
            .registerTypeHierarchyAdapter(Enum.class, new EnumValueAdapter())
            .create();

    public static Gson get() {
        return instance;
    }

    public static Gson getRawInstance() {
        return raw;
    }
}
