/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.zendesk.jersey;

import com.google.gson.*;

import java.lang.reflect.Type;
import java.util.Locale;

/**
 * @author Mulesoft, Inc
 */
public class EnumValueAdapter<T extends Enum<T>> implements JsonSerializer<T>, JsonDeserializer<T> {

    @Override
    public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(src.toString());
    }

    @SuppressWarnings("unchecked")
    @Override
    public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
            throws JsonParseException {
        return Enum.valueOf((Class<T>) typeOfT, json.getAsString().toUpperCase(Locale.ENGLISH));
    }
}
