/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.zendesk.process;

import org.mule.api.Connection;
import org.mule.api.ConnectionManager;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.UnableToAcquireConnectionException;
import org.mule.api.UnableToReleaseConnectionException;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessInterceptor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.modules.zendesk.adapters.ZendeskConnectorConnectionIdentifierAdapter;
import org.mule.modules.zendesk.connectivity.ZendeskConnectorConnectionKey;
import org.mule.modules.zendesk.processors.AbstractConnectedProcessor;
import org.mule.modules.zendesk.processors.AbstractExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedConnectionProcessInterceptor<T>
extends AbstractExpressionEvaluator
implements ProcessInterceptor<T, ZendeskConnectorConnectionIdentifierAdapter> {
    private static Logger logger = LoggerFactory.getLogger(ManagedConnectionProcessInterceptor.class);
    private final ConnectionManager<ZendeskConnectorConnectionKey, ZendeskConnectorConnectionIdentifierAdapter> connectionManager;
    private final MuleContext muleContext;
    private final ProcessInterceptor<T, ZendeskConnectorConnectionIdentifierAdapter> next;

    public ManagedConnectionProcessInterceptor(ProcessInterceptor<T, ZendeskConnectorConnectionIdentifierAdapter> next, ConnectionManager<ZendeskConnectorConnectionKey, ZendeskConnectorConnectionIdentifierAdapter> connectionManager, MuleContext muleContext) {
        this.next = next;
        this.connectionManager = connectionManager;
        this.muleContext = muleContext;
    }

    public T execute(ProcessCallback<T, ZendeskConnectorConnectionIdentifierAdapter> processCallback, ZendeskConnectorConnectionIdentifierAdapter object, MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        Object _transformedUsername;
        ZendeskConnectorConnectionIdentifierAdapter connection = null;
        ZendeskConnectorConnectionKey key = null;
        if (messageProcessor != null && messageProcessor instanceof AbstractConnectedProcessor && ((AbstractConnectedProcessor)messageProcessor).getUsername() != null) {
            _transformedUsername = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_usernameType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getUsername());
            String _transformedPassword = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_passwordType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getPassword());
            key = new ZendeskConnectorConnectionKey((String)_transformedUsername, _transformedPassword);
        } else {
            key = (ZendeskConnectorConnectionKey)this.connectionManager.getDefaultConnectionKey();
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Attempting to acquire connection using " + key.toString());
            }
            if ((connection = (ZendeskConnectorConnectionIdentifierAdapter)this.connectionManager.acquireConnection((Object)key)) == null) {
                throw new UnableToAcquireConnectionException();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Connection has been acquired with [id=" + connection.getConnectionIdentifier() + "]");
            }
            _transformedUsername = this.next.execute(processCallback, (Object)connection, messageProcessor, event);
            return (T)_transformedUsername;
        }
        catch (Exception e) {
            if (processCallback.getManagedExceptions() != null) {
                for (Class exceptionClass : processCallback.getManagedExceptions()) {
                    if (!exceptionClass.isInstance(e)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("An exception ( " + exceptionClass.getName() + ") has been thrown. Destroying the connection with [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    try {
                        this.connectionManager.destroyConnection((Object)key, (Connection)connection);
                        connection = null;
                    }
                    catch (Exception innerException) {
                        logger.error(innerException.getMessage(), (Throwable)innerException);
                    }
                }
            }
            throw e;
        }
        finally {
            try {
                if (connection != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Releasing the connection back into the pool [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    this.connectionManager.releaseConnection((Object)key, (Connection)connection);
                }
            }
            catch (Exception e) {
                throw new UnableToReleaseConnectionException((Throwable)e);
            }
        }
    }

    public T execute(ProcessCallback<T, ZendeskConnectorConnectionIdentifierAdapter> processCallback, ZendeskConnectorConnectionIdentifierAdapter object, Filter filter, MuleMessage message) throws Exception {
        throw new UnsupportedOperationException();
    }
}

