/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.zendesk.jersey;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.mule.modules.zendesk.jersey.GsonFactory;
import org.mule.modules.zendesk.jersey.ZendeskException;
import org.mule.modules.zendesk.model.Entity;
import org.mule.modules.zendesk.model.EntityType;
import org.mule.modules.zendesk.model.responses.SearchResponse;

public class SearchDeserializer
implements JsonDeserializer<SearchResponse> {
    public SearchResponse deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        SearchResponse response;
        Entity clazz;
        Gson gson = GsonFactory.getRawInstance();
        JsonArray results = json.getAsJsonObject().get("results").getAsJsonArray();
        try {
            clazz = (Entity)EntityType.getClassOf(results.get(0).getAsJsonObject().get("result_type").getAsString()).newInstance();
        }
        catch (InstantiationException e) {
            throw new ZendeskException("Cannot deserialize search results. Please check the search operation documentation.");
        }
        catch (IllegalAccessException e) {
            throw new ZendeskException("Cannot deserialize search results. Please check the search operation documentation.");
        }
        ArrayList<Object> searchResults = new ArrayList<Object>();
        try {
            for (JsonElement obj : results) {
                searchResults.add(gson.fromJson(obj, clazz.getClass()));
            }
            response = (SearchResponse)gson.fromJson(json, typeOfT);
            response.setResults(searchResults);
        }
        catch (Exception e) {
            throw new ZendeskException("Cannot deserialize search results. Please check the search operation documentation.");
        }
        return response;
    }
}

