/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.zendesk;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.mule.api.ConnectionException;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.ConnectionIdentifier;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.Disconnect;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.ValidateConnection;
import org.mule.api.annotations.param.ConnectionKey;
import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.Optional;
import org.mule.commons.jersey.JerseyUtil;
import org.mule.commons.jersey.ResponseHandler;
import org.mule.commons.jersey.provider.GsonProvider;
import org.mule.modules.utils.pagination.PaginatedCollection;
import org.mule.modules.zendesk.jersey.GsonFactory;
import org.mule.modules.zendesk.jersey.ZendeskException;
import org.mule.modules.zendesk.jersey.ZendeskResponseHandler;
import org.mule.modules.zendesk.model.ActivityStream;
import org.mule.modules.zendesk.model.Attachment;
import org.mule.modules.zendesk.model.Automation;
import org.mule.modules.zendesk.model.Category;
import org.mule.modules.zendesk.model.EntityType;
import org.mule.modules.zendesk.model.FileUpload;
import org.mule.modules.zendesk.model.Forum;
import org.mule.modules.zendesk.model.ForumSubscription;
import org.mule.modules.zendesk.model.Group;
import org.mule.modules.zendesk.model.GroupMembership;
import org.mule.modules.zendesk.model.JobStatus;
import org.mule.modules.zendesk.model.Locale;
import org.mule.modules.zendesk.model.Macro;
import org.mule.modules.zendesk.model.Organization;
import org.mule.modules.zendesk.model.OrganizationRelated;
import org.mule.modules.zendesk.model.Request;
import org.mule.modules.zendesk.model.SatisfactionRating;
import org.mule.modules.zendesk.model.SharingAgreement;
import org.mule.modules.zendesk.model.SuspendedTicket;
import org.mule.modules.zendesk.model.Ticket;
import org.mule.modules.zendesk.model.TicketAudit;
import org.mule.modules.zendesk.model.TicketComment;
import org.mule.modules.zendesk.model.TicketField;
import org.mule.modules.zendesk.model.TicketMetric;
import org.mule.modules.zendesk.model.Topic;
import org.mule.modules.zendesk.model.TopicComment;
import org.mule.modules.zendesk.model.TopicSubscription;
import org.mule.modules.zendesk.model.TopicVote;
import org.mule.modules.zendesk.model.Trigger;
import org.mule.modules.zendesk.model.User;
import org.mule.modules.zendesk.model.UserIdentity;
import org.mule.modules.zendesk.model.UserRelated;
import org.mule.modules.zendesk.model.View;
import org.mule.modules.zendesk.model.ViewExecute;
import org.mule.modules.zendesk.model.responses.ApplyMacroResponse;
import org.mule.modules.zendesk.model.responses.EntityResponse;
import org.mule.modules.zendesk.model.responses.SearchResponse;
import org.mule.util.StringUtils;

@Connector(name="zendesk", schemaVersion="1.0", friendlyName="Zendesk")
public class ZendeskConnector {
    @Configurable
    private String apiUrl;
    private Client client;
    private JerseyUtil jerseyUtil;
    private WebResource apiResource;

    @Connect
    public void connect(@ConnectionKey String username, String password) throws ConnectionException {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        clientConfig.getSingletons().add(new GsonProvider(GsonFactory.get()));
        this.setClient(Client.create((ClientConfig)clientConfig));
        this.getClient().addFilter((ClientFilter)new HTTPBasicAuthFilter(username, password));
        this.initJerseyUtil();
        this.setApiResource(this.getClient().resource(this.getApiUrl()));
    }

    private void initJerseyUtil() {
        JerseyUtil.Builder builder = JerseyUtil.builder();
        builder.setResponseHandler((ResponseHandler)new ZendeskResponseHandler());
        this.setJerseyUtil(builder.build());
    }

    @Disconnect
    public void disconnect() {
        this.setClient(null);
    }

    @ValidateConnection
    public boolean isConnected() {
        return this.getClient() != null;
    }

    @ConnectionIdentifier
    public String connectionId() {
        return "{ User: \"" + this.getCurrentUser().getEmail() + " \"}";
    }

    @Processor
    public User getCurrentUser() {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("users").path("me.json"), EntityResponse.class, new int[]{200, 201})).getUser();
    }

    @Processor
    public Ticket createTicket(@Optional @Default(value="#[payload]") Ticket ticket) {
        return ((EntityResponse)this.jerseyUtil.post(this.apiResource.path("tickets.json").entity((Object)ticket), EntityResponse.class, new int[]{201})).getTicket();
    }

    @Processor
    public Collection<Ticket> listTickets() {
        return this.createPaginationResults(EntityType.TICKET, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("tickets.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Ticket getTicket(Long ticketId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("tickets").path(ticketId + ".json"), EntityResponse.class, new int[]{200})).getTicket();
    }

    @Processor
    public Ticket updateTicket(@Optional @Default(value="#[payload]") Ticket ticket) {
        return ((EntityResponse)this.jerseyUtil.put(this.apiResource.path("tickets").path(ticket.getId() + ".json").entity((Object)ticket), EntityResponse.class, new int[]{200})).getTicket();
    }

    @Processor
    public Ticket deleteTicket(@Optional @Default(value="#[payload]") Ticket ticket) {
        this.jerseyUtil.delete(this.apiResource.path("tickets").path(ticket.getId() + ".json").entity((Object)ticket), String.class, new int[]{200});
        return ticket;
    }

    @Processor
    public Collection<TicketAudit> listTicketAudits(Long ticketId) {
        return this.createPaginationResults(EntityType.AUDIT, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("tickets").path(ticketId.toString()).path("audits.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public TicketAudit getTicketAudit(Long ticketId, Long auditId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("tickets").path(ticketId.toString()).path("audits").path(auditId + ".json"), EntityResponse.class, new int[]{200})).getAudit();
    }

    @Processor
    public Collection<TicketField> listTicketFields() {
        return this.createPaginationResults(EntityType.TICKET_FIELD, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("ticket_fields.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public TicketField createTicketField(@Optional @Default(value="#[payload]") TicketField ticketField) {
        return ((EntityResponse)this.jerseyUtil.post(this.apiResource.path("ticket_fields.json").entity((Object)ticketField), EntityResponse.class, new int[]{201})).getTicketField();
    }

    @Processor
    public TicketField updateTicketField(@Optional @Default(value="#[payload]") TicketField ticketField) {
        return ((EntityResponse)this.jerseyUtil.put(this.apiResource.path("ticket_fields").path(ticketField.getId() + ".json").entity((Object)ticketField), EntityResponse.class, new int[]{200})).getTicketField();
    }

    @Processor
    public Ticket bulkImportTicket(@Optional @Default(value="#[payload]") Ticket ticket) {
        return ((EntityResponse)this.jerseyUtil.put(this.apiResource.path("imports").path("tickets.json").entity((Object)ticket), EntityResponse.class, new int[]{201})).getTicket();
    }

    @Processor
    public Collection<TicketMetric> listTicketMetrics() {
        return this.createPaginationResults(EntityType.TICKET_METRIC, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("ticket_metrics.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public TicketMetric getTicketMetrics(Long ticketId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("tickets").path(ticketId.toString()).path("metrics.json"), EntityResponse.class, new int[]{200})).getTicketMetric();
    }

    @Processor
    public Collection<View> listViews() {
        return this.createPaginationResults(EntityType.VIEW, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("views.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Collection<View> listActiveViews() {
        return this.createPaginationResults(EntityType.VIEW, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("views").path("active.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Collection<View> listCompactViews() {
        return this.createPaginationResults(EntityType.VIEW, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("views").path("compact.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public View getView(Long viewId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("views").path(viewId + ".json"), EntityResponse.class, new int[]{200})).getView();
    }

    @Processor
    public View createView(@Optional @Default(value="#[payload]") View view) {
        return ((EntityResponse)this.jerseyUtil.post(this.apiResource.path("views.json").entity((Object)view), EntityResponse.class, new int[]{201})).getView();
    }

    @Processor
    public View updateView(@Optional @Default(value="#[payload]") View view) {
        return ((EntityResponse)this.jerseyUtil.put(this.apiResource.path("views").path(view.getId() + ".json").entity((Object)view), EntityResponse.class, new int[]{200})).getView();
    }

    @Processor
    public Collection<Ticket> getTicketsFromView(Long viewId) {
        return this.createPaginationResults(EntityType.TICKET, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("views").path(viewId.toString()).path("tickets.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public ViewExecute executeView(Long viewId) {
        return (ViewExecute)this.jerseyUtil.get(this.apiResource.path("views").path(viewId.toString()).path("execute.json"), ViewExecute.class, new int[]{200});
    }

    @Processor
    public ViewExecute getViewCounts(List<String> viewIds) {
        return (ViewExecute)this.jerseyUtil.get(this.apiResource.path("views").path("counts_many.json").queryParam("ids", StringUtils.join(viewIds, (String)",")), ViewExecute.class, new int[]{200});
    }

    @Processor
    public Collection<User> listUsers() {
        return this.createPaginationResults(EntityType.USER, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("users.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Collection<User> listUsersByOrganization(Long organizationId) {
        return this.createPaginationResults(EntityType.USER, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("organizations").path(organizationId.toString()).path("users.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public User getUser(Long userId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("users").path(userId + ".json"), EntityResponse.class, new int[]{200})).getUser();
    }

    @Processor
    public Collection<User> listUsersByGroup(Long groupId) {
        return this.createPaginationResults(EntityType.USER, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("groups").path(groupId.toString()).path("users.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public UserRelated getUserRelated(Long userId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("users").path(userId.toString()).path("related.json"), EntityResponse.class, new int[]{200})).getUserRelated();
    }

    @Processor
    public User createUser(@Optional @Default(value="#[payload]") User user) {
        return ((EntityResponse)this.jerseyUtil.post(this.apiResource.path("users.json").entity((Object)user), EntityResponse.class, new int[]{201})).getUser();
    }

    @Processor
    public User updateUser(@Optional @Default(value="#[payload]") User user) {
        return ((EntityResponse)this.jerseyUtil.put(this.apiResource.path("users").path(user.getId() + ".json").entity((Object)user), EntityResponse.class, new int[]{200})).getUser();
    }

    @Processor
    public User deleteUser(@Optional @Default(value="#[payload]") User user) {
        return ((EntityResponse)this.jerseyUtil.delete(this.apiResource.path("users").path(user.getId() + ".json"), EntityResponse.class, new int[]{200})).getUser();
    }

    @Processor
    public Collection<Request> listRequests() {
        return this.createPaginationResults(EntityType.REQUEST, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("requests.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Collection<Request> listRequestsByStatus(String status) {
        Validate.isTrue((boolean)Arrays.asList("ccd", "open", "solved").contains(status), (String)"The status is not valid for the operation");
        return this.createPaginationResults(EntityType.REQUEST, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("requests").path(status + ".json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Collection<Request> listRequestsByUser(Long userId) {
        return this.createPaginationResults(EntityType.REQUEST, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("users").path(userId.toString()).path("requests.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Request getRequest(Long requestId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("requests").path(requestId + ".json"), EntityResponse.class, new int[]{200})).getRequest();
    }

    @Processor
    public Request createRequest(@Optional @Default(value="#[payload]") Request request) {
        return ((EntityResponse)this.jerseyUtil.post(this.apiResource.path("requests.json").entity((Object)request), EntityResponse.class, new int[]{201})).getRequest();
    }

    @Processor
    public Request updateRequest(@Optional @Default(value="#[payload]") Request request) {
        return ((EntityResponse)this.jerseyUtil.put(this.apiResource.path("requests").path(request.getId() + ".json").entity((Object)request), EntityResponse.class, new int[]{200})).getRequest();
    }

    @Processor
    public Collection<TicketComment> listRequestComments(Long requestId) {
        return this.createPaginationResults(EntityType.TICKET_COMMENT, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("requests").path(requestId.toString()).path("comments.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public TicketComment getRequestComment(Long requestId, Long commentId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("requests").path(requestId.toString()).path("comments").path(commentId + ".json"), EntityResponse.class, new int[]{200})).getComment();
    }

    @Processor
    public Collection<UserIdentity> listUserIdentities(Long userId) {
        return this.createPaginationResults(EntityType.IDENTITY, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("users").path(userId.toString()).path("identities.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public UserIdentity getUserIdentity(Long userId, Long userIdentityId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("users").path(userId.toString()).path("identities").path(userIdentityId + ".json"), EntityResponse.class, new int[]{200})).getIdentity();
    }

    @Processor
    public UserIdentity createUserIdentity(@Optional @Default(value="#[payload]") UserIdentity userIdentity) {
        Validate.notNull((Object)userIdentity.getUserId(), (String)"UserID in identity cannot be null");
        return ((EntityResponse)this.jerseyUtil.post(this.apiResource.path("users").path(userIdentity.getUserId().toString()).path("identities.json").entity((Object)userIdentity), EntityResponse.class, new int[]{201})).getIdentity();
    }

    @Processor
    public UserIdentity verifyUserIdentity(@Optional @Default(value="#[payload]") UserIdentity userIdentity) {
        Validate.notNull((Object)userIdentity.getUserId(), (String)"UserID in identity cannot be null");
        return ((EntityResponse)this.jerseyUtil.put(this.apiResource.path("users").path(userIdentity.getUserId().toString()).path("identities").path(userIdentity.getId().toString()).path("verify.json"), EntityResponse.class, new int[]{200})).getIdentity();
    }

    @Processor
    public UserIdentity makeUserIdentityPrimary(@Optional @Default(value="#[payload]") UserIdentity userIdentity) {
        Validate.notNull((Object)userIdentity.getUserId(), (String)"UserID in identity cannot be null");
        return ((EntityResponse)this.jerseyUtil.put(this.apiResource.path("users").path(userIdentity.getUserId().toString()).path("identities").path(userIdentity.getId().toString()).path("make_primary.json"), EntityResponse.class, new int[]{200})).getIdentity();
    }

    @Processor
    public UserIdentity requestUserIdentityVerification(@Optional @Default(value="#[payload]") UserIdentity userIdentity) {
        Validate.notNull((Object)userIdentity.getUserId(), (String)"UserID in identity cannot be null");
        return ((EntityResponse)this.jerseyUtil.put(this.apiResource.path("users").path(userIdentity.getUserId().toString()).path("identities").path(userIdentity.getId().toString()).path("request_verification.json"), EntityResponse.class, new int[]{200})).getIdentity();
    }

    @Processor
    public UserIdentity deleteUserIdentity(@Optional @Default(value="#[payload]") UserIdentity userIdentity) {
        Validate.notNull((Object)userIdentity.getUserId(), (String)"UserID in identity cannot be null");
        return ((EntityResponse)this.jerseyUtil.delete(this.apiResource.path("users").path(userIdentity.getUserId().toString()).path("identities").path(userIdentity.getId() + ".json"), EntityResponse.class, new int[]{200})).getIdentity();
    }

    @Processor
    public Collection<Group> listGroups() {
        return this.createPaginationResults(EntityType.GROUP, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("groups.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Collection<Group> listAssignableGroups() {
        return this.createPaginationResults(EntityType.GROUP, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("groups.json").path("assignable.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Group getGroup(Long groupId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("groups").path(groupId + ".json"), EntityResponse.class, new int[]{200})).getGroup();
    }

    @Processor
    public Group createGroup(@Optional @Default(value="#[payload]") Group group) {
        return ((EntityResponse)this.jerseyUtil.post(this.apiResource.path("groups.json").entity((Object)group), EntityResponse.class, new int[]{201})).getGroup();
    }

    @Processor
    public Group updateGroup(@Optional @Default(value="#[payload]") Group group) {
        Validate.notNull((Object)group.getId(), (String)"GroupId cannot be null");
        return ((EntityResponse)this.jerseyUtil.put(this.apiResource.path("groups").path(group.getId() + ".json").entity((Object)group), EntityResponse.class, new int[]{200})).getGroup();
    }

    @Processor
    public void deleteGroup(@Optional @Default(value="#[payload]") Group group) {
        Validate.notNull((Object)group.getId(), (String)"GroupId cannot be null");
        this.jerseyUtil.delete(this.apiResource.path("groups").path(group.getId() + ".json").entity((Object)group), ClientResponse.class, new int[]{200});
    }

    @Processor
    public Collection<GroupMembership> listGroupMemberships() {
        return this.createPaginationResults(EntityType.GROUP_MEMBERSHIP, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("group_memberships.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Collection<GroupMembership> listGroupMembershipsByUser(Long userId) {
        return this.createPaginationResults(EntityType.GROUP_MEMBERSHIP, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("users").path(userId.toString()).path("group_memberships.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Collection<GroupMembership> listGroupMembershipsByGroup(Long groupId) {
        return this.createPaginationResults(EntityType.GROUP_MEMBERSHIP, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("groups").path(groupId.toString()).path("memberships.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Collection<GroupMembership> listGroupAssignableMemberships() {
        return this.createPaginationResults(EntityType.GROUP_MEMBERSHIP, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("group_memberships").path("assignable.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Collection<GroupMembership> listGroupAssignableMembershipsByGroup(Long groupId) {
        return this.createPaginationResults(EntityType.GROUP_MEMBERSHIP, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("groups").path(groupId.toString()).path("memberships").path("assignable.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public GroupMembership getGroupMembership(Long groupMembershipId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("group_memberships").path(groupMembershipId + ".json"), EntityResponse.class, new int[]{200})).getGroupMembership();
    }

    @Processor
    public GroupMembership getGroupMembershipByUser(Long groupMembershipId, Long userId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("users").path(userId.toString()).path("group_memberships").path(groupMembershipId + ".json"), EntityResponse.class, new int[]{200})).getGroupMembership();
    }

    @Processor
    public GroupMembership createGroupMembership(@Optional @Default(value="#[payload]") GroupMembership groupMembership) {
        return ((EntityResponse)this.jerseyUtil.post(this.apiResource.path("group_memberships.json").entity((Object)groupMembership), EntityResponse.class, new int[]{201})).getGroupMembership();
    }

    @Processor
    public void deleteGroupMembership(@Optional @Default(value="#[payload]") GroupMembership groupMembership) {
        this.jerseyUtil.delete(this.apiResource.path("group_memberships").path(groupMembership.getId() + ".json").entity((Object)groupMembership), ClientResponse.class, new int[]{200});
    }

    @Processor
    public Collection<GroupMembership> setGroupMembershipAsDefault(@Optional @Default(value="#[payload]") GroupMembership groupMembership) {
        return this.createPaginationResults(EntityType.GROUP_MEMBERSHIP, (EntityResponse)this.jerseyUtil.put(this.apiResource.path("users").path(groupMembership.getUserId().toString()).path("group_memberships").path(groupMembership.getId().toString()).path("make_default.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Collection<Organization> listOrganizations() {
        return this.createPaginationResults(EntityType.ORGANIZATION, (EntityResponse)this.jerseyUtil.put(this.apiResource.path("organizations.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public OrganizationRelated getOrganizationRelated(Long organizationId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("organizations").path(organizationId.toString()).path("related.json"), EntityResponse.class, new int[]{200})).getOrganizationRelated();
    }

    @Processor
    public Organization getOrganization(Long organizationId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("organizations").path(organizationId + ".json"), EntityResponse.class, new int[]{200})).getOrganization();
    }

    @Processor
    public Organization createOrganization(@Optional @Default(value="#[payload]") Organization organization) {
        return ((EntityResponse)this.jerseyUtil.post(this.apiResource.path("organizations.json").entity((Object)organization), EntityResponse.class, new int[]{201})).getOrganization();
    }

    @Processor
    public Organization updateOrganization(@Optional @Default(value="#[payload]") Organization organization) {
        return ((EntityResponse)this.jerseyUtil.put(this.apiResource.path("organizations").path(organization.getId() + ".json").entity((Object)organization), EntityResponse.class, new int[]{200})).getOrganization();
    }

    @Processor
    public void deleteOrganization(@Optional @Default(value="#[payload]") Organization organization) {
        this.jerseyUtil.delete(this.apiResource.path("organizations").path(organization.getId() + ".json"), EntityResponse.class, new int[]{200});
    }

    @Processor
    public Collection<Organization> searchOrganization(String searchTerm) {
        return this.createPaginationResults(EntityType.ORGANIZATION, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("organizations").path("search.json").queryParam("external_id", searchTerm), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Collection<Forum> listForums() {
        return this.createPaginationResults(EntityType.FORUM, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("forums.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Collection<Forum> listForumsByCategory(Long categoryId) {
        return this.createPaginationResults(EntityType.FORUM, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("categories").path(categoryId.toString()).path("forums.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Forum getForum(Long forumId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("forums").path(forumId + ".json"), EntityResponse.class, new int[]{200})).getForum();
    }

    @Processor
    public Forum createForum(@Optional @Default(value="#[payload]") Forum forum) {
        return ((EntityResponse)this.jerseyUtil.post(this.apiResource.path("forums.json").entity((Object)forum), EntityResponse.class, new int[]{201})).getForum();
    }

    @Processor
    public Forum updateForum(@Optional @Default(value="#[payload]") Forum forum) {
        return ((EntityResponse)this.jerseyUtil.put(this.apiResource.path("forums").path(forum.getId() + ".json").entity((Object)forum), EntityResponse.class, new int[]{200})).getForum();
    }

    @Processor
    public void deleteForum(@Optional @Default(value="#[payload]") Forum forum) {
        this.jerseyUtil.delete(this.apiResource.path("forums").path(forum.getId() + ".json"), EntityResponse.class, new int[]{200});
    }

    @Processor
    public Collection<ForumSubscription> listForumSubscriptions() {
        return this.createPaginationResults(EntityType.FORUM_SUBSCRIPTION, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("forum_subscriptions.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Collection<ForumSubscription> listForumSubscriptionsByForum(Long forumId) {
        return this.createPaginationResults(EntityType.FORUM_SUBSCRIPTION, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("forums").path(forumId.toString()).path("subscriptions.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public ForumSubscription getForumSubscription(Long forumSubscriptionId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("forum_subscriptions").path(forumSubscriptionId + ".json"), EntityResponse.class, new int[]{200})).getForumSubscription();
    }

    @Processor
    public ForumSubscription createForumSubscription(@Optional @Default(value="#[payload]") ForumSubscription forumSubscription) {
        return ((EntityResponse)this.jerseyUtil.post(this.apiResource.path("forum_subscriptions.json").entity((Object)forumSubscription), EntityResponse.class, new int[]{201})).getForumSubscription();
    }

    @Processor
    public void deleteForumSubscription(@Optional @Default(value="#[payload]") ForumSubscription forumSubscription) {
        this.jerseyUtil.delete(this.apiResource.path("forum_subscriptions").path(forumSubscription.getId() + ".json"), EntityResponse.class, new int[]{200});
    }

    @Processor
    public Collection<Category> listCategories() {
        return this.createPaginationResults(EntityType.CATEGORY, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("categories.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Category getCategory(Long categoryId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("categories").path(categoryId + ".json"), EntityResponse.class, new int[]{200})).getCategory();
    }

    @Processor
    public Category createCategory(@Optional @Default(value="#[payload]") Category category) {
        return ((EntityResponse)this.jerseyUtil.post(this.apiResource.path("categories.json").entity((Object)category), EntityResponse.class, new int[]{201})).getCategory();
    }

    @Processor
    public Category updateCategory(@Optional @Default(value="#[payload]") Category category) {
        return ((EntityResponse)this.jerseyUtil.put(this.apiResource.path("categories").path(category.getId() + ".json").entity((Object)category), EntityResponse.class, new int[]{200})).getCategory();
    }

    @Processor
    public void deleteCategory(@Optional @Default(value="#[payload]") Category category) {
        this.jerseyUtil.delete(this.apiResource.path("categories").path(category.getId() + ".json"), EntityResponse.class, new int[]{200});
    }

    @Processor
    public Collection<Topic> listTopics() {
        return this.createPaginationResults(EntityType.TOPIC, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("topics.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Collection<Topic> listTopicsByForum(Long forumId) {
        return this.createPaginationResults(EntityType.TOPIC, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("forums").path(forumId.toString()).path("topics.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Collection<Topic> listTopicsByUser(Long userId) {
        return this.createPaginationResults(EntityType.TOPIC, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("users").path(userId.toString()).path("topics.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Topic getTopic(Long topicId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("topics").path(topicId + ".json"), EntityResponse.class, new int[]{200})).getTopic();
    }

    @Processor
    public Topic createTopic(@Optional @Default(value="#[payload]") Topic topic) {
        return ((EntityResponse)this.jerseyUtil.post(this.apiResource.path("topics.json").entity((Object)topic), EntityResponse.class, new int[]{201})).getTopic();
    }

    @Processor
    public Topic updateTopic(@Optional @Default(value="#[payload]") Topic topic) {
        return ((EntityResponse)this.jerseyUtil.put(this.apiResource.path("topics").path(topic.getId() + ".json").entity((Object)topic), EntityResponse.class, new int[]{200})).getTopic();
    }

    @Processor
    public Topic importTopic(@Optional @Default(value="#[payload]") Topic topic) {
        return ((EntityResponse)this.jerseyUtil.post(this.apiResource.path("import").path("topics.json").entity((Object)topic), EntityResponse.class, new int[]{201})).getTopic();
    }

    @Processor
    public void deleteTopic(@Optional @Default(value="#[payload]") Topic topic) {
        this.jerseyUtil.delete(this.apiResource.path("topics").path(topic.getId() + ".json"), EntityResponse.class, new int[]{200});
    }

    @Processor
    public Collection<TopicComment> listTopicComments(Long topicId) {
        return this.createPaginationResults(EntityType.TOPIC_COMMENT, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("topics").path(topicId.toString()).path("comments.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Collection<TopicComment> listTopicCommentsByUser(Long userId) {
        return this.createPaginationResults(EntityType.TOPIC_COMMENT, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("users").path(userId.toString()).path("topic_comments.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public TopicComment getTopicComment(Long topicId, Long topicCommentId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("topics").path(topicId.toString()).path("comments").path(topicCommentId + ".json"), EntityResponse.class, new int[]{200})).getTopicComment();
    }

    @Processor
    public TopicComment createTopicComment(@Optional @Default(value="#[payload]") TopicComment topicComment) {
        return ((EntityResponse)this.jerseyUtil.post(this.apiResource.path("topics").path(topicComment.getTopicId().toString()).path("comments.json").entity((Object)topicComment), EntityResponse.class, new int[]{201})).getTopicComment();
    }

    @Processor
    public TopicComment importTopicComment(@Optional @Default(value="#[payload]") TopicComment topicComment) {
        return ((EntityResponse)this.jerseyUtil.post(this.apiResource.path("import").path("topics").path(topicComment.getTopicId().toString()).path("comments.json").entity((Object)topicComment), EntityResponse.class, new int[]{201})).getTopicComment();
    }

    @Processor
    public TopicComment updateTopicComment(@Optional @Default(value="#[payload]") TopicComment topicComment) {
        return ((EntityResponse)this.jerseyUtil.put(this.apiResource.path("topics").path(topicComment.getTopicId().toString()).path("comments").path(topicComment.getId() + ".json").entity((Object)topicComment), EntityResponse.class, new int[]{200})).getTopicComment();
    }

    @Processor
    public void deleteTopicComment(@Optional @Default(value="#[payload]") TopicComment topicComment) {
        this.jerseyUtil.delete(this.apiResource.path("topics").path(topicComment.getTopicId().toString()).path("comments").path(topicComment.getId() + ".json"), EntityResponse.class, new int[]{200});
    }

    @Processor
    public Collection<TopicSubscription> listTopicSubscriptions() {
        return this.createPaginationResults(EntityType.TOPIC_SUBSCRIPTION, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("topic_subscriptions.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Collection<TopicSubscription> listTopicSubscriptionsByTopic(Long topicId) {
        return this.createPaginationResults(EntityType.TOPIC_SUBSCRIPTION, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("topics").path(topicId.toString()).path("subscriptions.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public TopicSubscription getTopicSubscription(Long topicSubscriptionId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("topic_subscriptions").path(topicSubscriptionId + ".json"), EntityResponse.class, new int[]{200})).getTopicSubscription();
    }

    @Processor
    public TopicSubscription createTopicSubscription(@Optional @Default(value="#[payload]") TopicSubscription topicSubscription) {
        return ((EntityResponse)this.jerseyUtil.post(this.apiResource.path("topic_subscriptions.json").entity((Object)topicSubscription), EntityResponse.class, new int[]{201})).getTopicSubscription();
    }

    @Processor
    public void deleteTopicSubscription(@Optional @Default(value="#[payload]") TopicSubscription topicSubscription) {
        this.jerseyUtil.delete(this.apiResource.path("topic_subscriptions").path(topicSubscription.getId() + ".json"), EntityResponse.class, new int[]{200});
    }

    @Processor
    public Collection<TopicVote> listTopicVotes(Long topicId) {
        return this.createPaginationResults(EntityType.TOPIC_VOTE, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("topics").path(topicId.toString()).path("votes.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Collection<TopicVote> listTopicVotesByUser(Long userId) {
        return this.createPaginationResults(EntityType.TOPIC_VOTE, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("users").path(userId.toString()).path("topic_votes.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public TopicComment checkForVote(Long topicId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("topics").path(topicId.toString()).path("vote.json"), EntityResponse.class, new int[]{200})).getTopicComment();
    }

    @Processor
    public TopicVote createTopicVote(@Optional @Default(value="#[payload]") TopicVote topicVote) {
        return ((EntityResponse)this.jerseyUtil.post(this.apiResource.path("topics").path(topicVote.getTopicId().toString()).path("vote.json").entity((Object)topicVote), EntityResponse.class, new int[]{201})).getTopicVote();
    }

    @Processor
    public void deleteTopicVote(@Optional @Default(value="#[payload]") TopicVote topicVote) {
        this.jerseyUtil.delete(this.apiResource.path("topics").path(topicVote.getTopicId().toString()).path("vote.json"), EntityResponse.class, new int[]{200});
    }

    @Processor
    public Collection<ActivityStream> listActivities() {
        return this.createPaginationResults(EntityType.ACTIVITY_STREAM, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("activities.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public ActivityStream getActivity(Long activityId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("activities").path(activityId + ".json"), EntityResponse.class, new int[]{200})).getActivity();
    }

    @Processor
    public FileUpload uploadAttachment(InputStream content, String mediaType, String filename, @Optional String token) {
        return ((EntityResponse)this.jerseyUtil.post((WebResource.Builder)this.apiResource.path("uploads.json").queryParam("filename", filename).type(mediaType).entity((Object)content), EntityResponse.class, new int[]{201})).getUpload();
    }

    @Processor
    public void deleteUpload(String token) {
        this.jerseyUtil.delete(this.apiResource.path("uploads").path(token + ".json"), EntityResponse.class, new int[]{200});
    }

    @Processor
    public Attachment getAttachment(Long attachmentId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("attachments").path(attachmentId + ".json"), EntityResponse.class, new int[]{200})).getAttachment();
    }

    @Processor
    public void deleteAttachment(Long attachmentId) {
        this.jerseyUtil.delete(this.apiResource.path("attachments").path(attachmentId + ".json"), EntityResponse.class, new int[]{200});
    }

    @Processor
    public Collection<Automation> listAutomations() {
        return this.createPaginationResults(EntityType.AUTOMATION, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("automations.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Automation getAutomation(Long automationId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("automations").path(automationId + ".json"), EntityResponse.class, new int[]{200})).getAutomation();
    }

    @Processor
    public Collection<Automation> listActiveAutomations() {
        return this.createPaginationResults(EntityType.AUTOMATION, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("automations").path("active.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Automation createAutomation(@Optional @Default(value="#[payload]") Automation automation) {
        return ((EntityResponse)this.jerseyUtil.post(this.apiResource.path("automations.json").entity((Object)automation), EntityResponse.class, new int[]{201})).getAutomation();
    }

    @Processor
    public Automation updateAutomation(@Optional @Default(value="#[payload]") Automation automation) {
        return ((EntityResponse)this.jerseyUtil.put(this.apiResource.path("automations").path(automation.getId() + ".json").entity((Object)automation), EntityResponse.class, new int[]{200})).getAutomation();
    }

    @Processor
    public JobStatus showJobStatus(Long jobStatusId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("job_statuses").path(jobStatusId + ".json"), EntityResponse.class, new int[]{200})).getJobStatus();
    }

    @Processor
    public Collection<Locale> listLocales() {
        return this.createPaginationResults(EntityType.LOCALE, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("locales.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Locale getLocale(Integer localeId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("locales").path(localeId + ".json"), EntityResponse.class, new int[]{200})).getLocale();
    }

    @Processor
    public Locale getCurrentLocale() {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("locales").path("current.json"), EntityResponse.class, new int[]{200})).getLocale();
    }

    @Processor
    public Collection<Macro> listMacros() {
        return this.createPaginationResults(EntityType.MACRO, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("macros.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Collection<Macro> listActiveMacros() {
        return this.createPaginationResults(EntityType.MACRO, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("macros").path("active.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Macro getMacro(Long macroId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("macros").path(macroId + ".json"), EntityResponse.class, new int[]{200})).getMacro();
    }

    @Processor
    public Macro createMacro(@Optional @Default(value="#[payload]") Macro macro) {
        return ((EntityResponse)this.jerseyUtil.post(this.apiResource.path("macros.json").entity((Object)macro), EntityResponse.class, new int[]{201})).getMacro();
    }

    @Processor
    public Macro updateMacro(@Optional @Default(value="#[payload]") Macro macro) {
        return ((EntityResponse)this.jerseyUtil.put(this.apiResource.path("macros").path(macro.getId() + ".json").entity((Object)macro), EntityResponse.class, new int[]{200})).getMacro();
    }

    @Processor
    public void deleteMacro(@Optional @Default(value="#[payload]") Macro macro) {
        this.jerseyUtil.delete(this.apiResource.path("macros").path(macro.getId() + ".json").entity((Object)macro), EntityResponse.class, new int[]{200});
    }

    @Processor
    public void applyMacro(Long macroId) {
        this.jerseyUtil.get(this.apiResource.path("macros").path(macroId.toString()).path("apply.json"), ApplyMacroResponse.class, new int[]{200});
    }

    @Processor
    public void applyMacroToTicket(Long macroId, Long ticketId) {
        this.jerseyUtil.get(this.apiResource.path("tickets").path(ticketId.toString()).path("macros").path(macroId.toString()).path("apply.json"), ApplyMacroResponse.class, new int[]{200});
    }

    @Processor
    public Collection<SatisfactionRating> listSatisfactionRatings() {
        return this.createPaginationResults(EntityType.SATISFACTION_RATING, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("satisfaction_ratings.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Collection<SatisfactionRating> listReceivedSatisfactionRatings() {
        return this.createPaginationResults(EntityType.SATISFACTION_RATING, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("satisfaction_ratings").path("received.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public SatisfactionRating getSatisfactionRating(Long satisfactionRatingId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("satisfaction_ratings").path(satisfactionRatingId + ".json"), EntityResponse.class, new int[]{200})).getSatisfactionRating();
    }

    @Processor
    public SatisfactionRating createSatisfactionRating(@Optional @Default(value="#[payload]") SatisfactionRating satisfactionRating) {
        return ((EntityResponse)this.jerseyUtil.post(this.apiResource.path("tickets").path(satisfactionRating.getTicketId().toString()).path("satisfaction_rating.json").entity((Object)satisfactionRating), EntityResponse.class, new int[]{201})).getSatisfactionRating();
    }

    @Processor
    public Collection<SharingAgreement> listSharingAgreements() {
        return this.createPaginationResults(EntityType.SHARING_AGREEMENT, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("sharing_agreements.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Collection<SuspendedTicket> listSuspendedTickets() {
        return this.createPaginationResults(EntityType.SUSPENDED_TICKET, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("suspended_tickets.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public SuspendedTicket getSuspendedTicket(Long suspendedTicketId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("suspended_tickets").path(suspendedTicketId + ".json"), EntityResponse.class, new int[]{200})).getSuspendedTicket();
    }

    @Processor
    public void recoverSuspendedTicket(Long suspendedTicketId) {
        this.jerseyUtil.put(this.apiResource.path("suspended_tickets").path(suspendedTicketId.toString()).path("recover.json"), EntityResponse.class, new int[]{200});
    }

    @Processor
    public void deleteSuspendedTicket(Long suspendedTicketId) {
        this.jerseyUtil.delete(this.apiResource.path("suspended_tickets").path(suspendedTicketId + ".json"), EntityResponse.class, new int[]{200});
    }

    @Processor
    public Collection<Trigger> listTriggers() {
        return this.createPaginationResults(EntityType.TRIGGER, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("triggers.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Trigger getTrigger(Long triggerId) {
        return ((EntityResponse)this.jerseyUtil.get(this.apiResource.path("triggers").path(triggerId + ".json"), EntityResponse.class, new int[]{200})).getTrigger();
    }

    @Processor
    public Collection<Trigger> listActiveTriggers() {
        return this.createPaginationResults(EntityType.TRIGGER, (EntityResponse)this.jerseyUtil.get(this.apiResource.path("triggers").path("active.json"), EntityResponse.class, new int[]{200}));
    }

    @Processor
    public Trigger createTrigger(@Optional @Default(value="#[payload]") Trigger trigger) {
        return ((EntityResponse)this.jerseyUtil.post(this.apiResource.path("triggers.json").entity((Object)trigger), EntityResponse.class, new int[]{201})).getTrigger();
    }

    @Processor
    public Trigger updateTrigger(@Optional @Default(value="#[payload]") Trigger trigger) {
        return ((EntityResponse)this.jerseyUtil.put(this.apiResource.path("triggers").path(trigger.getId() + ".json").entity((Object)trigger), EntityResponse.class, new int[]{200})).getTrigger();
    }

    @Processor
    public Iterable search(EntityType type, String query, @Optional String sortBy, @Optional String sortOrder) {
        WebResource searchResource = this.apiResource.path("search.json").queryParam("query", query);
        if (sortBy != null) {
            searchResource.queryParam("sort_by", sortBy);
        }
        if (sortOrder != null) {
            searchResource.queryParam("sort_order", sortOrder);
        }
        return this.createPaginationResults(EntityType.SEARCH_RESULTS, (EntityResponse)this.jerseyUtil.get(searchResource, SearchResponse.class, new int[]{200}));
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public JerseyUtil getJerseyUtil() {
        return this.jerseyUtil;
    }

    public void setJerseyUtil(JerseyUtil jerseyUtil) {
        this.jerseyUtil = jerseyUtil;
    }

    public WebResource getApiResource() {
        return this.apiResource;
    }

    public void setApiResource(WebResource apiResource) {
        this.apiResource = apiResource;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    private <T> Collection<T> createPaginationResults(final EntityType type, final EntityResponse paginatedResponse) {
        return new PaginatedCollection<T, EntityResponse>(){
            private EntityResponse first;

            protected synchronized EntityResponse firstPage() {
                if (this.first == null) {
                    this.first = paginatedResponse;
                }
                return this.first;
            }

            protected boolean hasNextPage(EntityResponse currentPage) {
                return currentPage.getNextPage() != null;
            }

            protected EntityResponse nextPage(EntityResponse page) {
                return (EntityResponse)ZendeskConnector.this.jerseyUtil.get(ZendeskConnector.this.apiResource.path(page.getNextPage()), EntityResponse.class, new int[]{200});
            }

            protected Iterator<T> pageIterator(EntityResponse page) {
                try {
                    return ((List)page.getClass().getMethod("get" + type.getNameForLists(), new Class[0]).invoke((Object)page, new Object[0])).iterator();
                }
                catch (Exception e) {
                    throw new ZendeskException(e);
                }
            }

            public boolean isEmpty() {
                return this.size() == 0;
            }

            public int size() {
                return this.first.getCount();
            }
        };
    }
}

