
package org.mule.modules.zendesk.processors;

import java.io.InputStream;
import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.modules.zendesk.ZendeskConnector;
import org.mule.modules.zendesk.connectivity.ZendeskConnectorConnectionManager;


/**
 * UploadAttachmentMessageProcessor invokes the {@link org.mule.modules.zendesk.ZendeskConnector#uploadAttachment(java.io.InputStream, java.lang.String, java.lang.String, java.lang.String)} method in {@link ZendeskConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.3.2", date = "2013-05-07T06:37:28-03:00", comments = "Build UNNAMED.1377.fd7d4f9")
public class UploadAttachmentMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    protected Object content;
    protected InputStream _contentType;
    protected Object mediaType;
    protected String _mediaTypeType;
    protected Object filename;
    protected String _filenameType;
    protected Object token;
    protected String _tokenType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets content
     * 
     * @param value Value to set
     */
    public void setContent(Object value) {
        this.content = value;
    }

    /**
     * Sets token
     * 
     * @param value Value to set
     */
    public void setToken(Object value) {
        this.token = value;
    }

    /**
     * Sets filename
     * 
     * @param value Value to set
     */
    public void setFilename(Object value) {
        this.filename = value;
    }

    /**
     * Sets mediaType
     * 
     * @param value Value to set
     */
    public void setMediaType(Object value) {
        this.mediaType = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(ZendeskConnectorConnectionManager.class, false, event);
            final InputStream _transformedContent = ((InputStream) evaluateAndTransform(getMuleContext(), event, UploadAttachmentMessageProcessor.class.getDeclaredField("_contentType").getGenericType(), null, content));
            final String _transformedMediaType = ((String) evaluateAndTransform(getMuleContext(), event, UploadAttachmentMessageProcessor.class.getDeclaredField("_mediaTypeType").getGenericType(), null, mediaType));
            final String _transformedFilename = ((String) evaluateAndTransform(getMuleContext(), event, UploadAttachmentMessageProcessor.class.getDeclaredField("_filenameType").getGenericType(), null, filename));
            final String _transformedToken = ((String) evaluateAndTransform(getMuleContext(), event, UploadAttachmentMessageProcessor.class.getDeclaredField("_tokenType").getGenericType(), null, token));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((ZendeskConnector) object).uploadAttachment(_transformedContent, _transformedMediaType, _transformedFilename, _transformedToken);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("uploadAttachment"), event, e);
        }
    }

}
