/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.zendesk.model;

import java.util.Date;
import java.util.List;

/**
 *  Tickets are the means through which your End-users (customers) communicate with Agents in Zendesk. Tickets can
 *  originate via a number of support channels: email, web portal, chat, phone call, Twitter, Facebook and the API.
 *  All tickets have a core set of properties.
 *
 *  @author Mulesoft, Inc
 */
public class Ticket extends Entity {

    private String externalId;
    private String type;
    private String subject;
    private String description;
    private String priority;
    private TicketStatus status;
    private String recipient;
    private String requesterId;
    private String submitterId;
    private Long assigneeId;
    private Long organizationId;
    private Long groupId;
    private List<String> collaboratorIds;
    private Long forumTopicId;
    private Long problemId;
    private Boolean hasIncidents;
    private Date dueAt;
    private List<String> tags;
    private Via via;
    private List<CustomField> customFields;
    private List<CustomField> fields;
    private SatisfactionRating satisfactionRating;
    private List<String> sharingAgreementIds;
    private List<String> followupIds;
    private Long ticketFormId;
    private TicketComment comment;

    public String getExternalId() {
        return externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPriority() {
        return priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public TicketStatus getStatus() {
        return status;
    }

    public void setStatus(TicketStatus status) {
        this.status = status;
    }

    public String getRecipient() {
        return recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public String getRequesterId() {
        return requesterId;
    }

    public void setRequesterId(String requesterId) {
        this.requesterId = requesterId;
    }

    public String getSubmitterId() {
        return submitterId;
    }

    public void setSubmitterId(String submitterId) {
        this.submitterId = submitterId;
    }

    public Long getAssigneeId() {
        return assigneeId;
    }

    public void setAssigneeId(Long assigneeId) {
        this.assigneeId = assigneeId;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public List<String> getCollaboratorIds() {
        return collaboratorIds;
    }

    public void setCollaboratorIds(List<String> collaboratorIds) {
        this.collaboratorIds = collaboratorIds;
    }

    public Long getForumTopicId() {
        return forumTopicId;
    }

    public void setForumTopicId(Long forumTopicId) {
        this.forumTopicId = forumTopicId;
    }

    public Long getProblemId() {
        return problemId;
    }

    public void setProblemId(Long problemId) {
        this.problemId = problemId;
    }

    public Boolean getHasIncidents() {
        return hasIncidents;
    }

    public void setHasIncidents(Boolean hasIncidents) {
        this.hasIncidents = hasIncidents;
    }

    public Date getDueAt() {
        return dueAt;
    }

    public void setDueAt(Date dueAt) {
        this.dueAt = dueAt;
    }

    public List<String> getTags() {
        return tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public Via getVia() {
        return via;
    }

    public void setVia(Via via) {
        this.via = via;
    }

    public List<CustomField> getCustomFields() {
        return customFields;
    }

    public void setCustomFields(List<CustomField> customFields) {
        this.customFields = customFields;
    }

    public SatisfactionRating getSatisfactionRating() {
        return satisfactionRating;
    }

    public void setSatisfactionRating(SatisfactionRating satisfactionRating) {
        this.satisfactionRating = satisfactionRating;
    }

    public List<String> getSharingAgreementIds() {
        return sharingAgreementIds;
    }

    public void setSharingAgreementIds(List<String> sharingAgreementIds) {
        this.sharingAgreementIds = sharingAgreementIds;
    }

    public List<String> getFollowupIds() {
        return followupIds;
    }

    public void setFollowupIds(List<String> followupIds) {
        this.followupIds = followupIds;
    }

    public Long getTicketFormId() {
        return ticketFormId;
    }

    public void setTicketFormId(Long ticketFormId) {
        this.ticketFormId = ticketFormId;
    }

    public TicketComment getComment() {
        return comment;
    }

    public void setComment(TicketComment comment) {
        this.comment = comment;
    }

    public List<CustomField> getFields() {
        return fields;
    }

    public void setFields(List<CustomField> fields) {
        this.fields = fields;
    }
}
