/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.zendesk.jersey;

import com.google.gson.*;
import org.mule.modules.zendesk.model.Entity;
import org.mule.modules.zendesk.model.EntityType;

import java.lang.reflect.Type;

/**
 * @author Mulesoft, Inc
 */
public class EntitySerializer implements JsonSerializer<Entity> {

    @Override
    public JsonElement serialize(Entity src, Type typeOfSrc, JsonSerializationContext context) {
        Gson gson = GsonFactory.getRawInstance();

        JsonObject result = new JsonObject();

        result.add(EntityType.getNameToSerialize(src.getClass())
                    ,gson.toJsonTree(src));

        return result;
    }
}
