
package org.mule.modules.zendesk.connectivity;

import javax.annotation.Generated;
import org.mule.api.ConnectionManager;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessInterceptor;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.modules.zendesk.adapters.ZendeskConnectorConnectionIdentifierAdapter;
import org.mule.modules.zendesk.process.ManagedConnectionProcessInterceptor;
import org.mule.modules.zendesk.process.ProcessCallbackProcessInterceptor;
import org.mule.modules.zendesk.process.RetryProcessInterceptor;

@Generated(value = "Mule DevKit Version 3.3.2", date = "2013-05-07T06:37:28-03:00", comments = "Build UNNAMED.1377.fd7d4f9")
public class ManagedConnectionProcessTemplate<P >implements ProcessTemplate<P, ZendeskConnectorConnectionIdentifierAdapter>
{

    private final ProcessInterceptor<P, ZendeskConnectorConnectionIdentifierAdapter> processInterceptor;

    public ManagedConnectionProcessTemplate(ConnectionManager<ZendeskConnectorConnectionKey, ZendeskConnectorConnectionIdentifierAdapter> connectionManager, MuleContext muleContext) {
        ProcessInterceptor<P, ZendeskConnectorConnectionIdentifierAdapter> processCallbackProcessInterceptor = new ProcessCallbackProcessInterceptor<P, ZendeskConnectorConnectionIdentifierAdapter>();
        ProcessInterceptor<P, ZendeskConnectorConnectionIdentifierAdapter> managedConnectionProcessInterceptor = new ManagedConnectionProcessInterceptor<P>(processCallbackProcessInterceptor, connectionManager, muleContext);
        ProcessInterceptor<P, ZendeskConnectorConnectionIdentifierAdapter> retryProcessInterceptor = new RetryProcessInterceptor<P, ZendeskConnectorConnectionIdentifierAdapter>(managedConnectionProcessInterceptor, muleContext, connectionManager.getRetryPolicyTemplate());
        processInterceptor = retryProcessInterceptor;
    }

    public P execute(ProcessCallback<P, ZendeskConnectorConnectionIdentifierAdapter> processCallback, MessageProcessor messageProcessor, MuleEvent event)
        throws Exception
    {
        return processInterceptor.execute(processCallback, null, messageProcessor, event);
    }

    public P execute(ProcessCallback<P, ZendeskConnectorConnectionIdentifierAdapter> processCallback, Filter filter, MuleMessage message)
        throws Exception
    {
        return processInterceptor.execute(processCallback, null, filter, message);
    }

}
