/*
 * Decompiled with CFR 0.152.
 */
package org.mule.yammer;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.api.representation.Form;
import com.sun.jersey.oauth.client.OAuthClientFilter;
import com.sun.jersey.oauth.signature.OAuthParameters;
import com.sun.jersey.oauth.signature.OAuthSecrets;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.jaxrs.Annotations;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.yammer.Message;
import org.mule.yammer.Messages;

public class YammerConnector
implements Initialisable {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private String consumerKey;
    private String consumerSecret;
    private boolean debug;
    protected String oauthVerifier;
    private Client client;
    private String oauthTokenSecret;
    private String oauthToken;
    private String accessToken;
    private String accessTokenSecret;

    public void initialise() throws InitialisationException {
        if (this.client == null) {
            DefaultClientConfig config = new DefaultClientConfig();
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            JacksonJsonProvider provider = new JacksonJsonProvider(new Annotations[]{Annotations.JACKSON});
            provider.setMapper(mapper);
            config.getSingletons().add(provider);
            this.client = Client.create((ClientConfig)config);
        }
        if (this.debug) {
            this.client.addFilter((ClientFilter)new LoggingFilter());
        }
    }

    public void setOauthVerifier(String oauthVerifier) {
        this.oauthVerifier = oauthVerifier;
        WebResource resource = this.client.resource("https://www.yammer.com/oauth/access_token");
        OAuthSecrets secrets = new OAuthSecrets().consumerSecret(this.consumerSecret).tokenSecret(this.oauthTokenSecret);
        OAuthParameters params = new OAuthParameters().consumerKey(this.consumerKey).verifier(oauthVerifier).signatureMethod("PLAINTEXT").version("1.0");
        params.put((Object)"oauth_token", (Object)this.oauthToken);
        OAuthClientFilter filter = new OAuthClientFilter(this.client.getProviders(), params, secrets);
        resource.addFilter((ClientFilter)filter);
        ClientResponse post = (ClientResponse)resource.post(ClientResponse.class);
        this.handleErrors(post);
        Form form = (Form)post.getEntity(Form.class);
        this.accessToken = form.getFirst("oauth_token");
        this.accessTokenSecret = form.getFirst("oauth_token_secret");
        this.logger.info((Object)("Got OAuth access tokens. Access token:" + this.accessToken + " Access token secret:" + this.accessTokenSecret));
    }

    public String requestAuthorization() {
        WebResource resource = this.client.resource("https://www.yammer.com/oauth/request_token");
        OAuthSecrets secrets = new OAuthSecrets().consumerSecret(this.consumerSecret);
        OAuthParameters params = new OAuthParameters().consumerKey(this.consumerKey).signatureMethod("HMAC-SHA1").version("1.0");
        OAuthClientFilter filter = new OAuthClientFilter(this.client.getProviders(), params, secrets);
        resource.addFilter((ClientFilter)filter);
        ClientResponse post = (ClientResponse)resource.post(ClientResponse.class);
        this.handleErrors(post);
        Form form = (Form)post.getEntity(Form.class);
        this.oauthToken = form.getFirst("oauth_token");
        this.oauthTokenSecret = form.getFirst("oauth_token_secret");
        return "https://www.yammer.com/oauth/authorize?oauth_token=" + this.oauthToken;
    }

    private void handleErrors(ClientResponse response) {
        if (response.getStatus() >= 300) {
            String entity = (String)response.getEntity(String.class);
            throw new RuntimeException("Got status: " + response.getStatus() + ".\nMessage: " + entity);
        }
    }

    public List<Message> getMessages() {
        return this.getMessages("https://www.yammer.com/api/v1/messages.json");
    }

    public List<Message> getSentMessages() {
        return this.getMessages("https://www.yammer.com/api/v1/messages/sent.json");
    }

    public List<Message> getReceivedMessages() {
        return this.getMessages("https://www.yammer.com/api/v1/messages/received.json");
    }

    public List<Message> getPrivateMessages() {
        return this.getMessages("https://www.yammer.com/api/v1/messages/private.json");
    }

    public List<Message> getFollowingMessages() {
        return this.getMessages("https://www.yammer.com/api/v1/messages/following.json");
    }

    private List<Message> getMessages(String url) {
        ClientResponse response = (ClientResponse)this.oauthResource(url).get(ClientResponse.class);
        List<Message> messages = ((Messages)response.getEntity(Messages.class)).getMessages();
        if (messages == null) {
            return Collections.emptyList();
        }
        return messages;
    }

    protected WebResource oauthResource(String url) {
        WebResource resource = this.client.resource(url);
        OAuthParameters params = new OAuthParameters().signatureMethod("HMAC-SHA1").consumerKey(this.consumerKey).token(this.accessToken).version();
        OAuthSecrets secrets = new OAuthSecrets().consumerSecret(this.consumerSecret).tokenSecret(this.accessTokenSecret);
        resource.addFilter((ClientFilter)new OAuthClientFilter(this.client.getProviders(), params, secrets));
        return resource;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String applicationKey) {
        this.consumerKey = applicationKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String applicationSecret) {
        this.consumerSecret = applicationSecret;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getOauthTokenSecret() {
        return this.oauthTokenSecret;
    }

    public void setOauthTokenSecret(String oauthTokenSecret) {
        this.oauthTokenSecret = oauthTokenSecret;
    }

    public String getOauthToken() {
        return this.oauthToken;
    }

    public void setOauthToken(String oauthToken) {
        this.oauthToken = oauthToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String token) {
        this.accessToken = token;
    }

    public String getAccessTokenSecret() {
        return this.accessTokenSecret;
    }

    public void setAccessTokenSecret(String secret) {
        this.accessTokenSecret = secret;
    }
}

