/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.module.xml.util.XMLUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLTestUtils {
    public static List<?> getXmlMessageVariants(String resource) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(XMLTestUtils.toInputStream(resource));
        list.add(XMLTestUtils.toDom4jDocument(resource));
        list.add(XMLTestUtils.toW3cDocument(resource));
        list.add(XMLTestUtils.toInputSource(resource));
        list.add(XMLTestUtils.toSource(resource));
        list.add(XMLTestUtils.toXmlStreamReader(resource));
        return list;
    }

    public static XMLStreamReader toXmlStreamReader(String resource) throws IOException, XMLStreamException {
        InputStream is = XMLTestUtils.toInputStream(resource);
        return XMLUtils.toXMLStreamReader((XMLInputFactory)XMLInputFactory.newInstance(), (Object)is);
    }

    public static Source toSource(String resource) throws Exception {
        InputStream is = XMLTestUtils.toInputStream(resource);
        return XMLUtils.toXmlSource((XMLInputFactory)XMLInputFactory.newInstance(), (boolean)false, (Object)is);
    }

    public static org.w3c.dom.Document toW3cDocument(String resource) throws IOException, SAXException, ParserConfigurationException {
        InputStream is = XMLTestUtils.toInputStream(resource);
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
    }

    public static InputSource toInputSource(String resource) throws IOException {
        InputStream is = XMLTestUtils.toInputStream(resource);
        return new InputSource(is);
    }

    public static Document toDom4jDocument(String resource) throws IOException, DocumentException {
        String xml = XMLTestUtils.toString(resource);
        return DocumentHelper.parseText((String)xml);
    }

    public static String toString(String resource) throws IOException {
        return IOUtils.getResourceAsString((String)resource, XMLTestUtils.class);
    }

    public static InputStream toInputStream(String resource) throws IOException {
        return IOUtils.getResourceAsStream((String)resource, XMLTestUtils.class);
    }
}

