/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformers.xml.xquery;

import java.io.InputStream;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleSession;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.object.ObjectFactory;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.component.DefaultJavaComponent;
import org.mule.runtime.core.object.SingletonObjectFactory;
import org.mule.runtime.core.session.DefaultMuleSession;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.module.xml.transformer.XQueryTransformer;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class ParallelXQueryTransformerTestCase
extends AbstractMuleContextTestCase {
    private static final int TIMEOUT_MILLIS = 30000;
    private String srcData;
    private String resultData;
    private ConcurrentLinkedQueue<Object> actualResults = new ConcurrentLinkedQueue();
    private CountDownLatch latch = new CountDownLatch(this.getParallelThreadCount());

    protected void doSetUp() throws Exception {
        this.srcData = IOUtils.toString((InputStream)IOUtils.getResourceAsStream((String)"cd-catalog.xml", ((Object)((Object)this)).getClass()));
        this.resultData = IOUtils.toString((InputStream)IOUtils.getResourceAsStream((String)"cd-catalog-result.xml", ((Object)((Object)this)).getClass()));
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreComments((boolean)true);
    }

    public Transformer getTransformer() throws Exception {
        XQueryTransformer transformer = new XQueryTransformer();
        transformer.setReturnDataType(DataType.STRING);
        transformer.setXqueryFile("cd-catalog.xquery");
        transformer.setMuleContext(muleContext);
        transformer.initialise();
        return transformer;
    }

    public synchronized void signalDone() {
        this.latch.countDown();
    }

    @Test
    public void testParallelTransformation() throws Exception {
        Transformer transformer = this.getTransformer();
        Flow testFlow = Flow.builder((String)"appleFlow", (MuleContext)muleContext).messageProcessors(Collections.singletonList(new DefaultJavaComponent((ObjectFactory)new SingletonObjectFactory((Object)muleContext)))).build();
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < this.getParallelThreadCount(); ++i) {
            new Thread(() -> {
                try {
                    Event.setCurrentEvent((Event)Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)testFlow, (String)"test")).message((Message)InternalMessage.builder().payload((Object)"test").build()).flow((FlowConstruct)testFlow).session((MuleSession)new DefaultMuleSession()).build());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    return;
                }
                for (int j = 0; j < this.getCallsPerThread(); ++j) {
                    try {
                        this.actualResults.add(transformer.transform((Object)this.srcData));
                        continue;
                    }
                    catch (TransformerException e2) {
                        this.actualResults.add((Object)e2);
                    }
                }
                this.signalDone();
            }).start();
        }
        Assert.assertTrue((boolean)this.latch.await(30000L, TimeUnit.MILLISECONDS));
        long endTime = System.currentTimeMillis();
        this.checkResult();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Parallel transformations in " + this.getParallelThreadCount() + " threads with " + this.getCallsPerThread() + " calls/thread took " + (endTime - startTime) + " ms.");
        }
    }

    protected void checkResult() throws Exception {
        String expectedResult = this.resultData;
        for (Object result : this.actualResults) {
            if (result instanceof Exception) {
                throw (Exception)result;
            }
            if (expectedResult != null && result instanceof String) {
                XMLAssert.assertXMLEqual((String)expectedResult, (String)((String)result));
                continue;
            }
            XMLAssert.assertEquals((Object)expectedResult, (Object)result);
        }
    }

    private int getParallelThreadCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    private int getCallsPerThread() {
        return 100;
    }
}

