/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformers.xml;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.DOMWriter;
import org.junit.Assert;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.message.OutputHandler;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.module.xml.transformer.XmlToOutputHandler;
import org.mule.runtime.module.xml.transformers.xml.AbstractXmlTransformerTestCase;

public class XmlToOutputHandlerByteArrayTestCase
extends AbstractXmlTransformerTestCase {
    private byte[] srcData;
    private String resultData;

    protected void doSetUp() throws Exception {
        InputStream resourceStream = IOUtils.getResourceAsStream((String)"cdcatalog-utf-8.xml", ((Object)((Object)this)).getClass());
        this.resultData = IOUtils.toString((InputStream)resourceStream, (String)"UTF-8");
        this.srcData = this.resultData.getBytes("UTF-8");
    }

    public Transformer getTransformer() throws Exception {
        Transformer trans = (Transformer)this.createObject(XmlToOutputHandler.class);
        trans.setReturnDataType(DataType.fromType(OutputHandler.class));
        return trans;
    }

    public Transformer getRoundTripTransformer() throws Exception {
        return null;
    }

    public Object getTestData() {
        return this.srcData;
    }

    public Object getResultData() {
        return this.resultData;
    }

    @Override
    public boolean compareResults(Object expected, Object result) {
        if (result instanceof OutputHandler) {
            OutputHandler handler = (OutputHandler)result;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                handler.write(null, (OutputStream)bos);
                Document dom4jDoc = null;
                dom4jDoc = DocumentHelper.parseText((String)((String)expected));
                expected = new DOMWriter().write(dom4jDoc);
                dom4jDoc = DocumentHelper.parseText((String)new String(bos.toByteArray(), "UTF-8"));
                result = new DOMWriter().write(dom4jDoc);
            }
            catch (Exception e) {
                Assert.fail();
            }
        }
        return super.compareResults(expected, result);
    }
}

