/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformers.xml;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.DOMWriter;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.module.xml.transformer.DomDocumentToXml;
import org.mule.runtime.module.xml.transformer.XmlToDomDocument;
import org.mule.runtime.module.xml.transformers.xml.AbstractXmlTransformerTestCase;
import org.mule.runtime.module.xml.util.XMLTestUtils;
import org.mule.runtime.module.xml.util.XMLUtils;
import org.w3c.dom.Node;

public class DomXmlTransformersTestCase
extends AbstractXmlTransformerTestCase {
    private String srcData;
    private org.w3c.dom.Document resultData;

    protected void doSetUp() throws Exception {
        this.srcData = IOUtils.getResourceAsString((String)"cdcatalog.xml", ((Object)((Object)this)).getClass());
        Document dom4jDoc = DocumentHelper.parseText((String)this.srcData);
        this.resultData = new DOMWriter().write(dom4jDoc);
    }

    public Transformer getTransformer() throws Exception {
        XmlToDomDocument trans = (XmlToDomDocument)this.createObject(XmlToDomDocument.class);
        trans.setReturnDataType(DataType.fromType(org.w3c.dom.Document.class));
        return trans;
    }

    public Transformer getRoundTripTransformer() throws Exception {
        DomDocumentToXml trans = (DomDocumentToXml)this.createObject(DomDocumentToXml.class);
        trans.setReturnDataType(DataType.STRING);
        return trans;
    }

    public Object getTestData() {
        return this.srcData;
    }

    public Object getResultData() {
        return this.resultData;
    }

    @Test
    public void testTransformXMLStreamReader() throws Exception {
        Object expectedResult = this.getResultData();
        Assert.assertNotNull((Object)expectedResult);
        XmlToDomDocument transformer = (XmlToDomDocument)this.getTransformer();
        InputStream is = IOUtils.getResourceAsStream((String)"cdcatalog.xml", XMLTestUtils.class);
        XMLStreamReader sr = XMLUtils.toXMLStreamReader((XMLInputFactory)transformer.getXMLInputFactory(), (Object)is);
        Object result = transformer.transform((Object)sr);
        DomXmlTransformersTestCase.writeXml((Node)result, System.out);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((String)("expected: " + expectedResult + "\nresult: " + result), (boolean)this.compareResults(expectedResult, result));
    }

    public static void writeXml(Node n, OutputStream os) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        javax.xml.transform.Transformer t = tf.newTransformer();
        t.setOutputProperty("indent", "yes");
        t.transform(new DOMSource(n), new StreamResult(os));
    }

    @Test
    public void testAllXmlMessageTypes() throws Exception {
        List<?> list = XMLTestUtils.getXmlMessageVariants("cdcatalog.xml");
        Iterator<?> it = list.iterator();
        Object expectedResult = this.getResultData();
        Assert.assertNotNull((Object)expectedResult);
        while (it.hasNext()) {
            Object msg = it.next();
            Object result = this.getTransformer().transform(msg);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((String)("Test failed for message type: " + msg.getClass()), (boolean)this.compareResults(expectedResult, result));
        }
    }
}

