/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformers.jaxb;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.junit4.FlowRunner;
import org.mule.functional.junit4.FunctionalTestCase;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.util.IOUtils;
import org.mule.tck.junit4.rule.DynamicPort;
import org.xml.sax.SAXParseException;

public class JaxbSecurityTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort port = new DynamicPort("port");
    protected final String xmlWithEntities = "<?xml version=\"1.0\"?>\n<!DOCTYPE order [\n<!ELEMENT foo ANY >\n<!ENTITY xxe SYSTEM 'file:%s' >\n<!ENTITY lol \"0101\" >\n]>\n<Foo><bar>&xxe; &lol;</bar></Foo>";

    protected String getConfigFile() {
        return "jaxb-transformer-security.xml";
    }

    protected String getXmlWithEntities() {
        return String.format("<?xml version=\"1.0\"?>\n<!DOCTYPE order [\n<!ELEMENT foo ANY >\n<!ENTITY xxe SYSTEM 'file:%s' >\n<!ENTITY lol \"0101\" >\n]>\n<Foo><bar>&xxe; &lol;</bar></Foo>", IOUtils.getResourceAsUrl((String)"xxe-passwd.txt", ((Object)((Object)this)).getClass()).getPath());
    }

    @Test
    public void externalEntitiesEnabled() throws Exception {
        try {
            System.setProperty("mule.xml.expandExternalEntities", "true");
            System.setProperty("mule.xml.expandInternalEntities", "true");
            InternalMessage response = ((FlowRunner)((FlowRunner)this.flowRunner("testFlow").withPayload((Object)this.getXmlWithEntities())).withMediaType(MediaType.APPLICATION_XML)).run().getMessage();
            String payload = this.getPayloadAsString((Message)response);
            MatcherAssert.assertThat((Object)payload, (Matcher)Matchers.containsString((String)"secret"));
            MatcherAssert.assertThat((Object)payload, (Matcher)Matchers.containsString((String)"0101"));
        }
        finally {
            System.clearProperty("mule.xml.expandExternalEntities");
            System.clearProperty("mule.xml.expandInternalEntities");
        }
    }

    @Test
    public void expandsEntitiesEnabled() throws Exception {
        try {
            System.setProperty("mule.xml.expandInternalEntities", "true");
            InternalMessage response = ((FlowRunner)((FlowRunner)this.flowRunner("testFlow").withPayload((Object)this.getXmlWithEntities())).withMediaType(MediaType.APPLICATION_XML)).run().getMessage();
            String payload = this.getPayloadAsString((Message)response);
            MatcherAssert.assertThat((Object)payload, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"secret")));
            MatcherAssert.assertThat((Object)payload, (Matcher)Matchers.containsString((String)"0101"));
        }
        finally {
            System.clearProperty("mule.xml.expandInternalEntities");
        }
    }

    @Test
    public void expandsEntitiesWhenDisabled() throws Exception {
        try {
            InternalMessage response = ((FlowRunner)((FlowRunner)this.flowRunner("testFlow").withPayload((Object)this.getXmlWithEntities())).withMediaType(MediaType.APPLICATION_XML)).run().getMessage();
            String payload = this.getPayloadAsString((Message)response);
            Assert.fail((String)"Should've thrown exception");
        }
        catch (MessagingException e) {
            MatcherAssert.assertThat((Object)e.getRootCause(), (Matcher)Matchers.instanceOf(SAXParseException.class));
        }
    }
}

